/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.integrations.cdi.types.extension;

import java.lang.annotation.Annotation;
import java.util.Objects;
import java.util.Set;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.InjectionException;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.CDI;

public final class BeanManagers {
    public static <T> T getInstance(Class<T> clazz, BeanManager beanManager) {
        Objects.requireNonNull(clazz, "clazz is required");
        Objects.requireNonNull(beanManager, "beanManager is required");
        return BeanManagers.getInstanceImpl(clazz, beanManager);
    }

    public static <T> T getInstance(Class<T> clazz, Annotation qualifier, BeanManager beanManager) {
        Objects.requireNonNull(clazz, "clazz is required");
        Objects.requireNonNull(qualifier, "qualifier is required");
        Objects.requireNonNull(beanManager, "beanManager is required");
        return BeanManagers.getInstanceImpl(clazz, qualifier, beanManager);
    }

    public static BeanManager getBeanManager() {
        return CDI.current().getBeanManager();
    }

    public static <T> T getInstance(Class<T> clazz) {
        Objects.requireNonNull(clazz, "clazz is required");
        return BeanManagers.getInstanceImpl(clazz, BeanManagers.getBeanManager());
    }

    public static <T> T getInstance(Class<T> clazz, Annotation qualifier) {
        Objects.requireNonNull(clazz, "clazz is required");
        return BeanManagers.getInstanceImpl(clazz, qualifier, BeanManagers.getBeanManager());
    }

    private static <T> T getInstanceImpl(Class<T> clazz, BeanManager beanManager) {
        Set beans = beanManager.getBeans(clazz, new Annotation[0]);
        if (beans.isEmpty()) {
            throw new InjectionException("Does not find the bean class: " + clazz + " into CDI container");
        }
        Bean bean = (Bean)beans.iterator().next();
        CreationalContext ctx = beanManager.createCreationalContext((Contextual)bean);
        return (T)beanManager.getReference(bean, clazz, ctx);
    }

    private static <T> T getInstanceImpl(Class<T> clazz, Annotation qualifier, BeanManager beanManager) {
        Set beans = beanManager.getBeans(clazz, new Annotation[]{qualifier});
        BeanManagers.checkInjection(clazz, beans);
        Bean bean = (Bean)beans.iterator().next();
        CreationalContext ctx = beanManager.createCreationalContext((Contextual)bean);
        return (T)beanManager.getReference(bean, clazz, ctx);
    }

    private static <T> void checkInjection(Class<T> clazz, Set<Bean<?>> beans) {
        if (beans.isEmpty()) {
            throw new InjectionException("Does not find the bean class: " + clazz + " into CDI container");
        }
    }

    private BeanManagers() {
        throw new UnsupportedOperationException();
    }
}

