/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.integrations.cdi.types.extension;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.microstream.integrations.cdi.types.extension.FieldMetadata;

class EntityMetadata {
    private final Class<?> type;
    private final List<FieldMetadata> fields;

    private EntityMetadata(Class<?> type, List<FieldMetadata> fields) {
        this.type = type;
        this.fields = fields;
    }

    public List<FieldMetadata> getFields() {
        return Collections.unmodifiableList(this.fields);
    }

    public Stream<Object> values(Object entity, String[] filters) {
        Objects.requireNonNull(entity, "entity is required");
        Objects.requireNonNull(this.fields, "fields is required");
        if (!this.type.equals(entity.getClass())) {
            throw new IllegalArgumentException(String.format("The entity %s is not compatible with the metadata %s", entity.getClass(), this.type));
        }
        return this.getFields(filters).map(f -> f.read(entity)).filter(Objects::nonNull);
    }

    private Stream<FieldMetadata> getFields(String[] filters) {
        if (this.isFieldsEmpty(filters)) {
            return this.fields.stream();
        }
        List storeFields = Stream.of(filters).sorted().collect(Collectors.toList());
        Predicate<FieldMetadata> find = f -> Collections.binarySearch(storeFields, f.getName()) >= 0;
        return this.getFields().stream().filter(find);
    }

    private boolean isFieldsEmpty(String[] filters) {
        return Stream.of(filters).allMatch(s -> s == null || s.isBlank());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityMetadata that = (EntityMetadata)o;
        return Objects.equals(this.type, that.type) && Objects.equals(this.fields, that.fields);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.fields);
    }

    static <T> EntityMetadata of(Class<T> entity) {
        ArrayList<FieldMetadata> fields = new ArrayList<FieldMetadata>();
        Field[] fieldArray = entity.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            Class<?> type = field.getType();
            if (EntityMetadata.isLazyFields(type)) {
                field.setAccessible(true);
                fields.add(FieldMetadata.of(field));
            }
            ++n2;
        }
        return new EntityMetadata(entity, fields);
    }

    private static boolean isLazyFields(Class<?> type) {
        return Iterable.class.isAssignableFrom(type) || Map.class.isAssignableFrom(type);
    }
}

