/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.integrations.cdi.types.extension;

import java.lang.reflect.Field;
import java.util.Objects;
import java.util.function.Supplier;
import one.microstream.exceptions.IllegalAccessRuntimeException;

class FieldMetadata
implements Supplier<Field> {
    private final Field field;
    private final String name;

    private FieldMetadata(Field field) {
        this.field = field;
        this.name = field.getName();
    }

    Object read(Object entity) {
        try {
            return this.field.get(entity);
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessRuntimeException(e);
        }
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Field get() {
        return this.field;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldMetadata that = (FieldMetadata)o;
        return Objects.equals(this.field, that.field);
    }

    public int hashCode() {
        return Objects.hashCode(this.field);
    }

    public String toString() {
        return "FieldMetadata{field=" + this.field + ", name='" + this.name + '\'' + '}';
    }

    static FieldMetadata of(Field field) {
        return new FieldMetadata(field);
    }
}

