/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.integrations.cdi.types.extension;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.BeanManager;
import one.microstream.integrations.cdi.exceptions.CDIExceptionStorage;
import one.microstream.integrations.cdi.types.Storage;
import one.microstream.integrations.cdi.types.extension.AbstractBean;
import one.microstream.reflect.XReflect;
import one.microstream.storage.types.StorageManager;

class StorageBean<T>
extends AbstractBean<T> {
    private final Class<T> type;
    private final Set<Type> types;
    private final Set<Annotation> qualifiers;

    protected StorageBean(BeanManager beanManager, Class<T> type) {
        super(beanManager);
        this.type = type;
        this.types = Collections.singleton(type);
        this.qualifiers = new HashSet<Annotation>();
        this.qualifiers.add((Annotation)new Default.Literal());
        this.qualifiers.add((Annotation)new Any.Literal());
    }

    public Class<T> getBeanClass() {
        return this.type;
    }

    public T create(CreationalContext<T> context) {
        Object entity;
        StorageManager manager = this.getInstance(StorageManager.class);
        Object root = manager.root();
        if (Objects.isNull(root)) {
            entity = XReflect.defaultInstantiate(this.type);
            manager.setRoot(entity);
            manager.storeRoot();
        } else if (this.type.isInstance(root)) {
            entity = root;
        } else {
            throw new CDIExceptionStorage(this.type, root.getClass());
        }
        return (T)entity;
    }

    @Override
    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.singleton(Storage.class);
    }

    public Set<Type> getTypes() {
        return this.types;
    }

    public Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    public String getId() {
        return String.valueOf(this.type.getName()) + " @Storage";
    }

    public String toString() {
        return "StorageBean{type=" + this.type + ", types=" + this.types + ", qualifiers=" + this.qualifiers + '}';
    }
}

