/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.integrations.cdi.types.extension;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.WithAnnotations;
import one.microstream.integrations.cdi.types.Storage;
import one.microstream.integrations.cdi.types.extension.EntityMetadata;
import one.microstream.integrations.cdi.types.extension.StorageBean;

@ApplicationScoped
public class StorageExtension
implements Extension {
    private static final Logger LOGGER = Logger.getLogger(StorageExtension.class.getName());
    private final Set<Class<?>> storageRoot = new HashSet();
    private final Map<Class<?>, EntityMetadata> entities = new HashMap();

    <T> void loadEntity(@Observes @WithAnnotations(value={Storage.class}) ProcessAnnotatedType<T> target) {
        AnnotatedType annotatedType = target.getAnnotatedType();
        if (annotatedType.isAnnotationPresent(Storage.class)) {
            Class javaClass = target.getAnnotatedType().getJavaClass();
            this.storageRoot.add(javaClass);
            LOGGER.info("New class found annotated with @Storage is " + javaClass);
        }
    }

    void onAfterBeanDiscovery(@Observes AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        LOGGER.info(String.format("Processing StorageExtension:  %d found", this.storageRoot.size()));
        if (this.storageRoot.size() > 1) {
            throw new IllegalStateException("In the application must have only a class with the Storage annotation, classes: " + this.storageRoot);
        }
        this.storageRoot.forEach(entity -> {
            StorageBean bean = new StorageBean(beanManager, entity);
            afterBeanDiscovery.addBean(bean);
            this.entities.put((Class<?>)entity, EntityMetadata.of(entity));
        });
    }

    <T> Optional<EntityMetadata> get(Class<T> entity) {
        return Optional.ofNullable(this.entities.get(entity));
    }

    public String toString() {
        return "StorageExtension{storageRoot=" + this.storageRoot + ", entities=" + this.entities + '}';
    }
}

