/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.integrations.cdi.types.extension;

import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import one.microstream.concurrency.XThreads;
import one.microstream.integrations.cdi.types.Store;
import one.microstream.integrations.cdi.types.extension.StorageExtension;
import one.microstream.integrations.cdi.types.extension.StoreStrategy;
import one.microstream.storage.types.StorageManager;

@Store
@Interceptor
@Priority(value=2000)
class StoreInterceptor {
    private static final Logger LOGGER = Logger.getLogger(StoreInterceptor.class.getName());
    @Inject
    private StorageManager manager;
    @Inject
    private StorageExtension extension;

    StoreInterceptor() {
    }

    @AroundInvoke
    public Object store(InvocationContext context) throws Exception {
        Store store = Optional.ofNullable(context.getMethod().getAnnotation(Store.class)).orElse(context.getMethod().getDeclaringClass().getAnnotation(Store.class));
        LOGGER.log(Level.FINEST, "Using Store operation in the " + context.getMethod() + " using the store type: " + (Object)((Object)store.value()));
        Object result = context.proceed();
        XThreads.executeSynchronized(() -> {
            StoreStrategy strategy = StoreStrategy.of(store);
            strategy.store(store, this.manager, this.extension);
        });
        return result;
    }
}

