/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.integrations.cdi.types.extension;

import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import one.microstream.integrations.cdi.types.Store;
import one.microstream.integrations.cdi.types.extension.EntityMetadata;
import one.microstream.integrations.cdi.types.extension.StorageExtension;
import one.microstream.integrations.cdi.types.extension.StoreStrategy;
import one.microstream.persistence.types.PersistenceStoring;
import one.microstream.persistence.types.Storer;
import one.microstream.storage.types.StorageManager;

enum StoreTypeStrategy implements StoreStrategy
{
    EAGER{

        @Override
        public void store(Store store, StorageManager manager, StorageExtension extension) {
            LOGGER.log(Level.WARNING, "Store with Eager has a high cost of performance.");
            Object root = manager.root();
            Storer storer = manager.createEagerStorer();
            StoreTypeStrategy.execute(store, extension, root, (PersistenceStoring)storer);
            storer.commit();
        }
    }
    ,
    LAZY{

        @Override
        public void store(Store store, StorageManager manager, StorageExtension extension) {
            Object root = manager.root();
            StoreTypeStrategy.execute(store, extension, root, (PersistenceStoring)manager);
        }
    };

    private static final Logger LOGGER;

    static {
        LOGGER = Logger.getLogger(StoreTypeStrategy.class.getName());
    }

    private static void execute(Store store, StorageExtension extension, Object root, PersistenceStoring storing) {
        if (store.root()) {
            StoreTypeStrategy.storeRoot(root, storing);
        } else {
            Optional<EntityMetadata> metadata = extension.get(root.getClass());
            if (metadata.isEmpty()) {
                LOGGER.log(Level.FINEST, "There is no entity with the @Storage annotation to the current root class " + root.getClass() + " so it will store by root");
                StoreTypeStrategy.storeRoot(root, storing);
            }
            metadata.ifPresent(m -> m.values(root, store.fields()).forEach(arg_0 -> ((PersistenceStoring)storing).store(arg_0)));
            LOGGER.log(Level.FINEST, "Storing Iterables and Maps fields from the root class " + root.getClass() + " the fields: " + store.fields());
        }
    }

    private static void storeRoot(Object root, PersistenceStoring storing) {
        long storeId = storing.store(root);
        LOGGER.log(Level.WARNING, "Store the root it might return performance issue " + storeId);
    }
}

