/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.binary.jdk8.java.util;

import java.util.ArrayList;
import one.microstream.X;
import one.microstream.persistence.binary.internal.AbstractBinaryHandlerCustomIterableSizedArray;
import one.microstream.persistence.binary.jdk8.types.SunJdk8Internals;
import one.microstream.persistence.binary.types.Binary;
import one.microstream.persistence.types.Persistence;
import one.microstream.persistence.types.PersistenceFunction;
import one.microstream.persistence.types.PersistenceLoadHandler;
import one.microstream.persistence.types.PersistenceObjectIdAcceptor;
import one.microstream.persistence.types.PersistenceReferenceLoader;
import one.microstream.persistence.types.PersistenceSizedArrayLengthController;
import one.microstream.persistence.types.PersistenceStoreHandler;
import one.microstream.persistence.types.PersistenceTypeDefinitionMemberFieldGeneric;

public final class BinaryHandlerArrayList
extends AbstractBinaryHandlerCustomIterableSizedArray<ArrayList<?>> {
    static final long BINARY_OFFSET_SIZED_ARRAY = 0L;

    private static Class<ArrayList<?>> handledType() {
        return ArrayList.class;
    }

    public static BinaryHandlerArrayList New(PersistenceSizedArrayLengthController controller) {
        return new BinaryHandlerArrayList((PersistenceSizedArrayLengthController)X.notNull((Object)controller));
    }

    BinaryHandlerArrayList(PersistenceSizedArrayLengthController controller) {
        super(BinaryHandlerArrayList.handledType(), BinaryHandlerArrayList.SizedArrayFields((PersistenceTypeDefinitionMemberFieldGeneric[])new PersistenceTypeDefinitionMemberFieldGeneric[0]), controller);
    }

    public final void store(Binary bytes, ArrayList<?> instance, long objectId, PersistenceStoreHandler<Binary> handler) {
        bytes.storeSizedArray(this.typeId(), objectId, 0L, SunJdk8Internals.accessArray(instance), instance.size(), handler);
    }

    public final ArrayList<?> create(Binary bytes, PersistenceLoadHandler idResolver) {
        int arrayLength = this.determineArrayLength(bytes, 0L);
        return arrayLength == 0 ? new ArrayList(0) : new ArrayList(1);
    }

    public final void updateState(Binary bytes, ArrayList<?> instance, PersistenceLoadHandler handler) {
        instance.clear();
        int arrayLength = this.determineArrayLength(bytes, 0L);
        if (arrayLength == 0) {
            instance.trimToSize();
            return;
        }
        instance.ensureCapacity(arrayLength);
        int size = bytes.updateSizedArrayObjectReferences(0L, handler, SunJdk8Internals.accessArray(instance));
        SunJdk8Internals.setSize(instance, size);
    }

    public final void iterateInstanceReferences(ArrayList<?> instance, PersistenceFunction iterator) {
        Persistence.iterateReferences((PersistenceFunction)iterator, (Object[])SunJdk8Internals.accessArray(instance), (int)0, (int)instance.size());
    }

    public final void iterateLoadableReferences(Binary bytes, PersistenceReferenceLoader iterator) {
        bytes.iterateSizedArrayElementReferences(0L, (PersistenceObjectIdAcceptor)iterator);
    }
}

