/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.binary.jdk8.java.util;

import java.util.HashSet;
import one.microstream.X;
import one.microstream.collections.old.OldCollections;
import one.microstream.persistence.binary.internal.AbstractBinaryHandlerCustomCollection;
import one.microstream.persistence.binary.jdk8.types.SunJdk8Internals;
import one.microstream.persistence.binary.types.Binary;
import one.microstream.persistence.types.Persistence;
import one.microstream.persistence.types.PersistenceFunction;
import one.microstream.persistence.types.PersistenceLoadHandler;
import one.microstream.persistence.types.PersistenceObjectIdAcceptor;
import one.microstream.persistence.types.PersistenceReferenceLoader;
import one.microstream.persistence.types.PersistenceStoreHandler;
import one.microstream.persistence.types.PersistenceTypeDefinitionMemberFieldGeneric;

public final class BinaryHandlerHashSet
extends AbstractBinaryHandlerCustomCollection<HashSet<?>> {
    static final long BINARY_OFFSET_LOAD_FACTOR = 0L;
    static final long BINARY_OFFSET_ELEMENTS = 4L;

    private static Class<HashSet<?>> handledType() {
        return HashSet.class;
    }

    static final float getLoadFactor(Binary bytes) {
        return bytes.read_float(0L);
    }

    static final int getElementCount(Binary bytes) {
        return X.checkArrayRange((long)bytes.getListElementCountReferences(4L));
    }

    public static BinaryHandlerHashSet New() {
        return new BinaryHandlerHashSet();
    }

    BinaryHandlerHashSet() {
        super(BinaryHandlerHashSet.handledType(), BinaryHandlerHashSet.SimpleArrayFields((PersistenceTypeDefinitionMemberFieldGeneric[])new PersistenceTypeDefinitionMemberFieldGeneric[]{BinaryHandlerHashSet.CustomField(Float.TYPE, (String)"loadFactor")}));
    }

    public final void store(Binary bytes, HashSet<?> instance, long objectId, PersistenceStoreHandler<Binary> handler) {
        bytes.storeIterableAsList(this.typeId(), objectId, 4L, instance, (long)instance.size(), handler);
        bytes.store_float(0L, SunJdk8Internals.getLoadFactor(instance));
    }

    public final HashSet<?> create(Binary bytes, PersistenceLoadHandler idResolver) {
        return new HashSet(BinaryHandlerHashSet.getElementCount(bytes), BinaryHandlerHashSet.getLoadFactor(bytes));
    }

    public final void updateState(Binary bytes, HashSet<?> instance, PersistenceLoadHandler idResolver) {
        instance.clear();
        Object[] elementsHelper = new Object[BinaryHandlerHashSet.getElementCount(bytes)];
        bytes.collectElementsIntoArray(4L, idResolver, elementsHelper);
        bytes.registerHelper(instance, (Object)elementsHelper);
    }

    public void complete(Binary bytes, HashSet<?> instance, PersistenceLoadHandler idResolver) {
        OldCollections.populateCollectionFromHelperArray(instance, (Object)bytes.getHelper(instance));
    }

    public final void iterateInstanceReferences(HashSet<?> instance, PersistenceFunction iterator) {
        Persistence.iterateReferencesIterable((PersistenceFunction)iterator, instance);
    }

    public final void iterateLoadableReferences(Binary bytes, PersistenceReferenceLoader iterator) {
        bytes.iterateListElementReferences(4L, (PersistenceObjectIdAcceptor)iterator);
    }
}

