/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.binary.jdk8.java.util;

import java.util.Hashtable;
import java.util.function.BiConsumer;
import one.microstream.X;
import one.microstream.collections.old.KeyValueFlatCollector;
import one.microstream.collections.old.OldCollections;
import one.microstream.persistence.binary.internal.AbstractBinaryHandlerCustomCollection;
import one.microstream.persistence.binary.jdk8.types.SunJdk8Internals;
import one.microstream.persistence.binary.types.Binary;
import one.microstream.persistence.types.Persistence;
import one.microstream.persistence.types.PersistenceFunction;
import one.microstream.persistence.types.PersistenceLoadHandler;
import one.microstream.persistence.types.PersistenceObjectIdAcceptor;
import one.microstream.persistence.types.PersistenceReferenceLoader;
import one.microstream.persistence.types.PersistenceStoreHandler;
import one.microstream.persistence.types.PersistenceTypeDefinitionMemberFieldGeneric;

public final class BinaryHandlerHashtable
extends AbstractBinaryHandlerCustomCollection<Hashtable<?, ?>> {
    static final long BINARY_OFFSET_LOAD_FACTOR = 0L;
    static final long BINARY_OFFSET_ELEMENTS = 4L;

    private static Class<Hashtable<?, ?>> handledType() {
        return Hashtable.class;
    }

    static final float getLoadFactor(Binary bytes) {
        return bytes.read_float(0L);
    }

    static final int getElementCount(Binary bytes) {
        return X.checkArrayRange((long)bytes.getListElementCountKeyValue(4L));
    }

    public static BinaryHandlerHashtable New() {
        return new BinaryHandlerHashtable();
    }

    BinaryHandlerHashtable() {
        super(BinaryHandlerHashtable.handledType(), BinaryHandlerHashtable.keyValuesFields((PersistenceTypeDefinitionMemberFieldGeneric[])new PersistenceTypeDefinitionMemberFieldGeneric[]{BinaryHandlerHashtable.CustomField(Float.TYPE, (String)"loadFactor")}));
    }

    public final void store(Binary bytes, Hashtable<?, ?> instance, long objectId, PersistenceStoreHandler<Binary> handler) {
        bytes.storeMapEntrySet(this.typeId(), objectId, 4L, instance.entrySet(), handler);
        bytes.store_float(0L, SunJdk8Internals.getLoadFactor(instance));
    }

    public final Hashtable<?, ?> create(Binary bytes, PersistenceLoadHandler idResolver) {
        return new Hashtable(BinaryHandlerHashtable.getElementCount(bytes), BinaryHandlerHashtable.getLoadFactor(bytes));
    }

    public final void updateState(Binary bytes, Hashtable<?, ?> instance, PersistenceLoadHandler idResolver) {
        instance.clear();
        int elementCount = BinaryHandlerHashtable.getElementCount(bytes);
        KeyValueFlatCollector collector = KeyValueFlatCollector.New((int)elementCount);
        bytes.collectKeyValueReferences(4L, elementCount, idResolver, (BiConsumer)collector);
        bytes.registerHelper(instance, (Object)collector.yield());
    }

    public void complete(Binary bytes, Hashtable<?, ?> instance, PersistenceLoadHandler idResolver) {
        OldCollections.populateMapFromHelperArray(instance, (Object)bytes.getHelper(instance));
    }

    public final void iterateInstanceReferences(Hashtable<?, ?> instance, PersistenceFunction iterator) {
        Persistence.iterateReferencesMap((PersistenceFunction)iterator, instance);
    }

    public final void iterateLoadableReferences(Binary bytes, PersistenceReferenceLoader iterator) {
        bytes.iterateKeyValueEntriesReferences(4L, (PersistenceObjectIdAcceptor)iterator);
    }
}

