/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.binary.jdk8.java.util;

import java.util.LinkedHashMap;
import java.util.function.BiConsumer;
import one.microstream.X;
import one.microstream.collections.old.KeyValueFlatCollector;
import one.microstream.collections.old.OldCollections;
import one.microstream.persistence.binary.internal.AbstractBinaryHandlerCustomCollection;
import one.microstream.persistence.binary.jdk8.types.SunJdk8Internals;
import one.microstream.persistence.binary.types.Binary;
import one.microstream.persistence.types.Persistence;
import one.microstream.persistence.types.PersistenceFunction;
import one.microstream.persistence.types.PersistenceLoadHandler;
import one.microstream.persistence.types.PersistenceObjectIdAcceptor;
import one.microstream.persistence.types.PersistenceReferenceLoader;
import one.microstream.persistence.types.PersistenceStoreHandler;
import one.microstream.persistence.types.PersistenceTypeDefinitionMemberFieldGeneric;

public final class BinaryHandlerLinkedHashMap
extends AbstractBinaryHandlerCustomCollection<LinkedHashMap<?, ?>> {
    static final long BINARY_OFFSET_LOAD_FACTOR = 0L;
    static final long BINARY_OFFSET_ACCESS_ORDER = 4L;
    static final long BINARY_OFFSET_ELEMENTS = 5L;

    private static Class<LinkedHashMap<?, ?>> handledType() {
        return LinkedHashMap.class;
    }

    static final float getLoadFactor(Binary bytes) {
        return bytes.read_float(0L);
    }

    static final boolean getAccessOrder(Binary bytes) {
        return bytes.read_boolean(4L);
    }

    static final int getElementCount(Binary bytes) {
        return X.checkArrayRange((long)bytes.getListElementCountKeyValue(5L));
    }

    public static BinaryHandlerLinkedHashMap New() {
        return new BinaryHandlerLinkedHashMap();
    }

    BinaryHandlerLinkedHashMap() {
        super(BinaryHandlerLinkedHashMap.handledType(), BinaryHandlerLinkedHashMap.keyValuesFields((PersistenceTypeDefinitionMemberFieldGeneric[])new PersistenceTypeDefinitionMemberFieldGeneric[]{BinaryHandlerLinkedHashMap.CustomField(Float.TYPE, (String)"loadFactor"), BinaryHandlerLinkedHashMap.CustomField(Boolean.TYPE, (String)"accessOrder")}));
    }

    public final void store(Binary bytes, LinkedHashMap<?, ?> instance, long objectId, PersistenceStoreHandler<Binary> handler) {
        bytes.storeMapEntrySet(this.typeId(), objectId, 5L, instance.entrySet(), handler);
        bytes.store_float(0L, SunJdk8Internals.getLoadFactor(instance));
        bytes.store_boolean(4L, SunJdk8Internals.getAccessOrder(instance));
    }

    public final LinkedHashMap<?, ?> create(Binary bytes, PersistenceLoadHandler idResolver) {
        return new LinkedHashMap(BinaryHandlerLinkedHashMap.getElementCount(bytes), BinaryHandlerLinkedHashMap.getLoadFactor(bytes), BinaryHandlerLinkedHashMap.getAccessOrder(bytes));
    }

    public final void updateState(Binary data, LinkedHashMap<?, ?> instance, PersistenceLoadHandler idResolver) {
        instance.clear();
        int elementCount = BinaryHandlerLinkedHashMap.getElementCount(data);
        KeyValueFlatCollector collector = KeyValueFlatCollector.New((int)elementCount);
        data.collectKeyValueReferences(5L, elementCount, idResolver, (BiConsumer)collector);
        data.registerHelper(instance, (Object)collector.yield());
    }

    public void complete(Binary bytes, LinkedHashMap<?, ?> instance, PersistenceLoadHandler idResolver) {
        OldCollections.populateMapFromHelperArray(instance, (Object)bytes.getHelper(instance));
    }

    public final void iterateInstanceReferences(LinkedHashMap<?, ?> instance, PersistenceFunction iterator) {
        Persistence.iterateReferencesMap((PersistenceFunction)iterator, instance);
    }

    public final void iterateLoadableReferences(Binary bytes, PersistenceReferenceLoader iterator) {
        bytes.iterateKeyValueEntriesReferences(5L, (PersistenceObjectIdAcceptor)iterator);
    }
}

