/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.binary.jdk8.java.util;

import java.util.Comparator;
import java.util.PriorityQueue;
import one.microstream.X;
import one.microstream.persistence.binary.internal.AbstractBinaryHandlerCustomCollection;
import one.microstream.persistence.binary.jdk8.types.SunJdk8Internals;
import one.microstream.persistence.binary.types.Binary;
import one.microstream.persistence.types.Persistence;
import one.microstream.persistence.types.PersistenceFunction;
import one.microstream.persistence.types.PersistenceLoadHandler;
import one.microstream.persistence.types.PersistenceObjectIdAcceptor;
import one.microstream.persistence.types.PersistenceReferenceLoader;
import one.microstream.persistence.types.PersistenceStoreHandler;
import one.microstream.persistence.types.PersistenceTypeDefinitionMemberFieldGeneric;

public final class BinaryHandlerPriorityQueue
extends AbstractBinaryHandlerCustomCollection<PriorityQueue<?>> {
    static final long BINARY_OFFSET_COMPARATOR = 0L;
    static final long BINARY_OFFSET_ELEMENTS = 0L + (long)Binary.objectIdByteLength();

    private static Class<PriorityQueue<?>> handledType() {
        return PriorityQueue.class;
    }

    static final int getElementCount(Binary bytes) {
        return X.checkArrayRange((long)bytes.getListElementCountReferences(BINARY_OFFSET_ELEMENTS));
    }

    private static <E> Comparator<? super E> getComparator(Binary bytes, PersistenceLoadHandler idResolver) {
        return (Comparator)idResolver.lookupObject(bytes.read_long(0L));
    }

    public static BinaryHandlerPriorityQueue New() {
        return new BinaryHandlerPriorityQueue();
    }

    BinaryHandlerPriorityQueue() {
        super(BinaryHandlerPriorityQueue.handledType(), BinaryHandlerPriorityQueue.SimpleArrayFields((PersistenceTypeDefinitionMemberFieldGeneric[])new PersistenceTypeDefinitionMemberFieldGeneric[]{BinaryHandlerPriorityQueue.CustomField(Comparator.class, (String)"comparator")}));
    }

    public final void store(Binary bytes, PriorityQueue<?> instance, long objectId, PersistenceStoreHandler<Binary> handler) {
        bytes.storeIterableAsList(this.typeId(), objectId, BINARY_OFFSET_ELEMENTS, instance, (long)instance.size(), handler);
        bytes.store_long(0L, handler.apply(instance.comparator()));
    }

    public final PriorityQueue<?> create(Binary bytes, PersistenceLoadHandler handler) {
        return new PriorityQueue(bytes.getSizedArrayLength(BINARY_OFFSET_ELEMENTS), BinaryHandlerPriorityQueue.getComparator(bytes, handler));
    }

    public final void updateState(Binary data, PriorityQueue<?> instance, PersistenceLoadHandler handler) {
        instance.clear();
        PriorityQueue<?> castedInstance = instance;
        data.collectObjectReferences(BINARY_OFFSET_ELEMENTS, X.checkArrayRange((long)BinaryHandlerPriorityQueue.getElementCount(data)), handler, e -> {
            boolean bl = castedInstance.add(e);
        });
    }

    public final void iterateInstanceReferences(PriorityQueue<?> instance, PersistenceFunction iterator) {
        iterator.apply(instance.comparator());
        Persistence.iterateReferences((PersistenceFunction)iterator, (Object[])SunJdk8Internals.accessArray(instance), (int)0, (int)instance.size());
    }

    public final void iterateLoadableReferences(Binary data, PersistenceReferenceLoader iterator) {
        iterator.acceptObjectId(data.read_long(0L));
        data.iterateListElementReferences(BINARY_OFFSET_ELEMENTS, (PersistenceObjectIdAcceptor)iterator);
    }
}

