/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.binary.jdk8.java.util;

import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import one.microstream.X;
import one.microstream.collections.old.KeyValueFlatCollector;
import one.microstream.collections.old.OldCollections;
import one.microstream.persistence.binary.internal.AbstractBinaryHandlerCustomCollection;
import one.microstream.persistence.binary.jdk8.types.SunJdk8Internals;
import one.microstream.persistence.binary.types.Binary;
import one.microstream.persistence.types.Persistence;
import one.microstream.persistence.types.PersistenceFunction;
import one.microstream.persistence.types.PersistenceLoadHandler;
import one.microstream.persistence.types.PersistenceObjectIdAcceptor;
import one.microstream.persistence.types.PersistenceReferenceLoader;
import one.microstream.persistence.types.PersistenceStoreHandler;
import one.microstream.persistence.types.PersistenceTypeDefinitionMemberFieldGeneric;

public final class BinaryHandlerProperties
extends AbstractBinaryHandlerCustomCollection<Properties> {
    static final long BINARY_OFFSET_DEFAULTS = 0L;
    static final long BINARY_OFFSET_ELEMENTS = 0L + (long)Binary.objectIdByteLength();

    private static Class<Properties> typeWorkaround() {
        return Properties.class;
    }

    static final int getElementCount(Binary bytes) {
        return X.checkArrayRange((long)bytes.getListElementCountKeyValue(BINARY_OFFSET_ELEMENTS));
    }

    public static BinaryHandlerProperties New() {
        return new BinaryHandlerProperties();
    }

    BinaryHandlerProperties() {
        super(BinaryHandlerProperties.typeWorkaround(), BinaryHandlerProperties.keyValuesFields((PersistenceTypeDefinitionMemberFieldGeneric[])new PersistenceTypeDefinitionMemberFieldGeneric[]{BinaryHandlerProperties.CustomField(Properties.class, (String)"defaults")}));
    }

    public final void store(Binary bytes, Properties instance, long objectId, PersistenceStoreHandler<Binary> handler) {
        bytes.storeMapEntrySet(this.typeId(), objectId, BINARY_OFFSET_ELEMENTS, instance.entrySet(), handler);
        bytes.store_long(0L, handler.apply((Object)SunJdk8Internals.accessDefaults(instance)));
    }

    public final Properties create(Binary data, PersistenceLoadHandler idResolver) {
        return new Properties();
    }

    public final void updateState(Binary data, Properties instance, PersistenceLoadHandler handler) {
        instance.clear();
        Object defaults = handler.lookupObject(data.read_long(0L));
        SunJdk8Internals.setDefaults(instance, (Properties)defaults);
        int elementCount = BinaryHandlerProperties.getElementCount(data);
        KeyValueFlatCollector collector = KeyValueFlatCollector.New((int)elementCount);
        data.collectKeyValueReferences(BINARY_OFFSET_ELEMENTS, elementCount, handler, (BiConsumer)collector);
        data.registerHelper((Object)instance, (Object)collector.yield());
    }

    public void complete(Binary data, Properties instance, PersistenceLoadHandler handler) {
        OldCollections.populateMapFromHelperArray((Map)instance, (Object)data.getHelper((Object)instance));
    }

    public final void iterateInstanceReferences(Properties instance, PersistenceFunction iterator) {
        iterator.apply((Object)SunJdk8Internals.accessDefaults(instance));
        Persistence.iterateReferencesMap((PersistenceFunction)iterator, (Map)instance);
    }

    public final void iterateLoadableReferences(Binary data, PersistenceReferenceLoader iterator) {
        iterator.acceptObjectId(data.read_long(0L));
        data.iterateKeyValueEntriesReferences(BINARY_OFFSET_ELEMENTS, (PersistenceObjectIdAcceptor)iterator);
    }
}

