/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.binary.jdk8.java.util;

import java.util.Vector;
import one.microstream.X;
import one.microstream.persistence.binary.internal.AbstractBinaryHandlerCustomIterableSizedArray;
import one.microstream.persistence.binary.jdk8.types.SunJdk8Internals;
import one.microstream.persistence.binary.types.Binary;
import one.microstream.persistence.types.Persistence;
import one.microstream.persistence.types.PersistenceFunction;
import one.microstream.persistence.types.PersistenceLoadHandler;
import one.microstream.persistence.types.PersistenceObjectIdAcceptor;
import one.microstream.persistence.types.PersistenceReferenceLoader;
import one.microstream.persistence.types.PersistenceSizedArrayLengthController;
import one.microstream.persistence.types.PersistenceStoreHandler;
import one.microstream.persistence.types.PersistenceTypeDefinitionMemberFieldGeneric;

public final class BinaryHandlerVector
extends AbstractBinaryHandlerCustomIterableSizedArray<Vector<?>> {
    static final long BINARY_OFFSET_CAPACITY_INCREMENT = 0L;
    static final long BINARY_OFFSET_SIZED_ARRAY = 4L;

    private static Class<Vector<?>> handledType() {
        return Vector.class;
    }

    public static BinaryHandlerVector New(PersistenceSizedArrayLengthController controller) {
        return new BinaryHandlerVector((PersistenceSizedArrayLengthController)X.notNull((Object)controller));
    }

    BinaryHandlerVector(PersistenceSizedArrayLengthController controller) {
        super(BinaryHandlerVector.handledType(), BinaryHandlerVector.SizedArrayFields((PersistenceTypeDefinitionMemberFieldGeneric[])new PersistenceTypeDefinitionMemberFieldGeneric[]{BinaryHandlerVector.CustomField(Integer.TYPE, (String)"capacityIncrement")}), controller);
    }

    public final void store(Binary bytes, Vector<?> instance, long objectId, PersistenceStoreHandler<Binary> handler) {
        bytes.storeSizedArray(this.typeId(), objectId, 4L, SunJdk8Internals.accessArray(instance), instance.size(), handler);
        bytes.store_int(0L, SunJdk8Internals.getCapacityIncrement(instance));
    }

    public final Vector<?> create(Binary bytes, PersistenceLoadHandler idResolver) {
        return new Vector(1, bytes.read_int(0L));
    }

    public final void updateState(Binary bytes, Vector<?> instance, PersistenceLoadHandler idResolver) {
        instance.clear();
        instance.ensureCapacity(this.determineArrayLength(bytes, 4L));
        int size = bytes.updateSizedArrayObjectReferences(4L, idResolver, SunJdk8Internals.accessArray(instance));
        SunJdk8Internals.setElementCount(instance, size);
    }

    public final void iterateInstanceReferences(Vector<?> instance, PersistenceFunction iterator) {
        Persistence.iterateReferences((PersistenceFunction)iterator, (Object[])SunJdk8Internals.accessArray(instance), (int)0, (int)instance.size());
    }

    public final void iterateLoadableReferences(Binary bytes, PersistenceReferenceLoader iterator) {
        bytes.iterateSizedArrayElementReferences(4L, (PersistenceObjectIdAcceptor)iterator);
    }
}

