/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.binary.jdk8.types;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.PriorityQueue;
import java.util.Properties;
import java.util.Vector;
import one.microstream.X;
import one.microstream.memory.sun.JdkInternals;

public final class SunJdk8Internals {
    private static final long OFFSET_ArrayList_elementData = SunJdk8Internals.getFieldOffset(ArrayList.class, "elementData");
    private static final long OFFSET_ArrayList_size = SunJdk8Internals.getFieldOffset(ArrayList.class, "size");
    private static final long OFFSET_HashSet_map = SunJdk8Internals.getFieldOffset(HashSet.class, "map");
    private static final long OFFSET_HashMap_loadFactor = SunJdk8Internals.getFieldOffset(HashMap.class, "loadFactor");
    private static final long OFFSET_Hashtable_loadFactor = SunJdk8Internals.getFieldOffset(Hashtable.class, "loadFactor");
    private static final long OFFSET_LinkedHashMap_loadFactor = SunJdk8Internals.getFieldOffset(LinkedHashMap.class, "loadFactor");
    private static final long OFFSET_LinkedHashMap_accessOrder = SunJdk8Internals.getFieldOffset(LinkedHashMap.class, "accessOrder");
    private static final long OFFSET_PriorityQueue_queue = SunJdk8Internals.getFieldOffset(PriorityQueue.class, "queue");
    private static final long OFFSET_PriorityQueue_size = SunJdk8Internals.getFieldOffset(PriorityQueue.class, "size");
    private static final long OFFSET_Vector_elementData = SunJdk8Internals.getFieldOffset(Vector.class, "elementData");
    private static final long OFFSET_Vector_elementCount = SunJdk8Internals.getFieldOffset(Vector.class, "elementCount");
    private static final long OFFSET_Vector_capacityIncrement = SunJdk8Internals.getFieldOffset(Vector.class, "capacityIncrement");
    private static final long OFFSET_Properties_Defaults = SunJdk8Internals.getFieldOffset(Properties.class, "defaults");

    static final long getFieldOffset(Class<?> type, String declaredFieldName) {
        Class<?> c = type;
        while (c != null && c != Object.class) {
            try {
                Field[] fieldArray = c.getDeclaredFields();
                int n = fieldArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Field field = fieldArray[n2];
                    if (field.getName().equals(declaredFieldName)) {
                        return JdkInternals.VM().objectFieldOffset(field);
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                throw new Error(e);
            }
            c = c.getSuperclass();
        }
        throw new Error("Field not found: " + type.getName() + '#' + declaredFieldName);
    }

    public static Object[] accessArray(ArrayList<?> arrayList) {
        return (Object[])JdkInternals.VM().getObject(X.notNull(arrayList), OFFSET_ArrayList_elementData);
    }

    public static void setSize(ArrayList<?> arrayList, int size) {
        JdkInternals.VM().putInt(X.notNull(arrayList), OFFSET_ArrayList_size, size);
    }

    public static float getLoadFactor(HashSet<?> hashSet) {
        HashMap map = (HashMap)JdkInternals.VM().getObject(X.notNull(hashSet), OFFSET_HashSet_map);
        return SunJdk8Internals.getLoadFactor(map);
    }

    public static float getLoadFactor(HashMap<?, ?> hashMap) {
        return JdkInternals.VM().getFloat(X.notNull(hashMap), OFFSET_HashMap_loadFactor);
    }

    public static float getLoadFactor(Hashtable<?, ?> hashtable) {
        return JdkInternals.VM().getFloat(X.notNull(hashtable), OFFSET_Hashtable_loadFactor);
    }

    public static float getLoadFactor(LinkedHashMap<?, ?> linkedHashMap) {
        return JdkInternals.VM().getFloat(X.notNull(linkedHashMap), OFFSET_LinkedHashMap_loadFactor);
    }

    public static boolean getAccessOrder(LinkedHashMap<?, ?> linkedHashMap) {
        return JdkInternals.VM().getBoolean(X.notNull(linkedHashMap), OFFSET_LinkedHashMap_accessOrder);
    }

    public static Object[] accessArray(Vector<?> vector) {
        return (Object[])JdkInternals.VM().getObject(X.notNull(vector), OFFSET_Vector_elementData);
    }

    public static int getElementCount(Vector<?> vector) {
        return JdkInternals.VM().getInt(X.notNull(vector), OFFSET_Vector_elementCount);
    }

    public static void setElementCount(Vector<?> vector, int size) {
        JdkInternals.VM().putInt(X.notNull(vector), OFFSET_Vector_elementCount, size);
    }

    public static int getCapacityIncrement(Vector<?> vector) {
        return JdkInternals.VM().getInt(X.notNull(vector), OFFSET_Vector_capacityIncrement);
    }

    public static void setCapacityIncrement(Vector<?> vector, int size) {
        JdkInternals.VM().putInt(X.notNull(vector), OFFSET_Vector_capacityIncrement, size);
    }

    public static Properties accessDefaults(Properties properties) {
        return (Properties)JdkInternals.VM().getObject(X.notNull((Object)properties), OFFSET_Properties_Defaults);
    }

    public static void setDefaults(Properties properties, Properties defaults) {
        JdkInternals.VM().putObject(X.notNull((Object)properties), OFFSET_Properties_Defaults, defaults);
    }

    public static Object[] accessArray(PriorityQueue<?> priorityQueue) {
        return (Object[])JdkInternals.VM().getObject(X.notNull(priorityQueue), OFFSET_PriorityQueue_queue);
    }

    public static void setSize(PriorityQueue<?> priorityQueue, int size) {
        JdkInternals.VM().putInt(X.notNull(priorityQueue), OFFSET_PriorityQueue_size, size);
    }

    private SunJdk8Internals() {
        throw new UnsupportedOperationException();
    }
}

