/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.binary.jdk8.java.util;

import java.util.LinkedHashSet;
import one.microstream.X;
import one.microstream.collections.old.OldCollections;
import one.microstream.persistence.binary.internal.AbstractBinaryHandlerCustomCollection;
import one.microstream.persistence.binary.jdk8.types.SunJdk8Internals;
import one.microstream.persistence.binary.types.Binary;
import one.microstream.persistence.types.Persistence;
import one.microstream.persistence.types.PersistenceFunction;
import one.microstream.persistence.types.PersistenceLoadHandler;
import one.microstream.persistence.types.PersistenceObjectIdAcceptor;
import one.microstream.persistence.types.PersistenceReferenceLoader;
import one.microstream.persistence.types.PersistenceStoreHandler;
import one.microstream.persistence.types.PersistenceTypeDefinitionMemberFieldGeneric;

public final class BinaryHandlerLinkedHashSet
extends AbstractBinaryHandlerCustomCollection<LinkedHashSet<?>> {
    static final long BINARY_OFFSET_LOAD_FACTOR = 0L;
    static final long BINARY_OFFSET_ELEMENTS = 4L;

    private static Class<LinkedHashSet<?>> handledType() {
        return LinkedHashSet.class;
    }

    static final float getLoadFactor(Binary bytes) {
        return bytes.read_float(0L);
    }

    static final int getElementCount(Binary bytes) {
        return X.checkArrayRange((long)bytes.getListElementCountReferences(4L));
    }

    public static BinaryHandlerLinkedHashSet New() {
        return new BinaryHandlerLinkedHashSet();
    }

    BinaryHandlerLinkedHashSet() {
        super(BinaryHandlerLinkedHashSet.handledType(), BinaryHandlerLinkedHashSet.SimpleArrayFields((PersistenceTypeDefinitionMemberFieldGeneric[])new PersistenceTypeDefinitionMemberFieldGeneric[]{BinaryHandlerLinkedHashSet.CustomField(Float.TYPE, (String)"loadFactor")}));
    }

    public final void store(Binary bytes, LinkedHashSet<?> instance, long objectId, PersistenceStoreHandler<Binary> handler) {
        bytes.storeIterableAsList(this.typeId(), objectId, 4L, instance, (long)instance.size(), handler);
        bytes.store_float(0L, SunJdk8Internals.getLoadFactor(instance));
    }

    public final LinkedHashSet<?> create(Binary bytes, PersistenceLoadHandler idResolver) {
        return new LinkedHashSet(BinaryHandlerLinkedHashSet.getElementCount(bytes), BinaryHandlerLinkedHashSet.getLoadFactor(bytes));
    }

    public final void updateState(Binary bytes, LinkedHashSet<?> instance, PersistenceLoadHandler idResolver) {
        instance.clear();
        Object[] elementsHelper = new Object[BinaryHandlerLinkedHashSet.getElementCount(bytes)];
        bytes.collectElementsIntoArray(4L, idResolver, elementsHelper);
        bytes.registerHelper(instance, (Object)elementsHelper);
    }

    public void complete(Binary bytes, LinkedHashSet<?> instance, PersistenceLoadHandler idResolver) {
        OldCollections.populateCollectionFromHelperArray(instance, (Object)bytes.getHelper(instance));
    }

    public final void iterateInstanceReferences(LinkedHashSet<?> instance, PersistenceFunction iterator) {
        Persistence.iterateReferencesIterable((PersistenceFunction)iterator, instance);
    }

    public final void iterateLoadableReferences(Binary bytes, PersistenceReferenceLoader iterator) {
        bytes.iterateListElementReferences(4L, (PersistenceObjectIdAcceptor)iterator);
    }
}

