/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.binary.jdk8.java.util;

import java.util.Stack;
import one.microstream.X;
import one.microstream.persistence.binary.internal.AbstractBinaryHandlerCustomIterableSizedArray;
import one.microstream.persistence.binary.jdk8.types.SunJdk8Internals;
import one.microstream.persistence.binary.types.Binary;
import one.microstream.persistence.types.Persistence;
import one.microstream.persistence.types.PersistenceFunction;
import one.microstream.persistence.types.PersistenceLoadHandler;
import one.microstream.persistence.types.PersistenceObjectIdAcceptor;
import one.microstream.persistence.types.PersistenceReferenceLoader;
import one.microstream.persistence.types.PersistenceSizedArrayLengthController;
import one.microstream.persistence.types.PersistenceStoreHandler;
import one.microstream.persistence.types.PersistenceTypeDefinitionMemberFieldGeneric;

public final class BinaryHandlerStack
extends AbstractBinaryHandlerCustomIterableSizedArray<Stack<?>> {
    static final long BINARY_OFFSET_CAPACITY_INCREMENT = 0L;
    static final long BINARY_OFFSET_SIZED_ARRAY = 4L;

    private static Class<Stack<?>> handledType() {
        return Stack.class;
    }

    public static BinaryHandlerStack New(PersistenceSizedArrayLengthController controller) {
        return new BinaryHandlerStack((PersistenceSizedArrayLengthController)X.notNull((Object)controller));
    }

    BinaryHandlerStack(PersistenceSizedArrayLengthController controller) {
        super(BinaryHandlerStack.handledType(), BinaryHandlerStack.SizedArrayFields((PersistenceTypeDefinitionMemberFieldGeneric[])new PersistenceTypeDefinitionMemberFieldGeneric[]{BinaryHandlerStack.CustomField(Integer.TYPE, (String)"capacityIncrement")}), controller);
    }

    public final void store(Binary bytes, Stack<?> instance, long objectId, PersistenceStoreHandler<Binary> handler) {
        bytes.storeSizedArray(this.typeId(), objectId, 4L, SunJdk8Internals.accessArray(instance), instance.size(), handler);
        bytes.store_int(0L, SunJdk8Internals.getCapacityIncrement(instance));
    }

    public final Stack<?> create(Binary bytes, PersistenceLoadHandler idResolver) {
        return new Stack();
    }

    public final void updateState(Binary bytes, Stack<?> instance, PersistenceLoadHandler idResolver) {
        instance.clear();
        instance.ensureCapacity(bytes.getSizedArrayLength(4L));
        int size = bytes.updateSizedArrayObjectReferences(4L, idResolver, SunJdk8Internals.accessArray(instance));
        SunJdk8Internals.setElementCount(instance, size);
    }

    public final void iterateInstanceReferences(Stack<?> instance, PersistenceFunction iterator) {
        Persistence.iterateReferences((PersistenceFunction)iterator, (Object[])SunJdk8Internals.accessArray(instance), (int)0, (int)instance.size());
    }

    public final void iterateLoadableReferences(Binary bytes, PersistenceReferenceLoader iterator) {
        bytes.iterateSizedArrayElementReferences(4L, (PersistenceObjectIdAcceptor)iterator);
    }
}

