/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.binary.internal;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.util.function.Consumer;
import java.util.function.Predicate;
import one.microstream.collections.BulkList;
import one.microstream.collections.EqConstHashEnum;
import one.microstream.collections.EqHashEnum;
import one.microstream.collections.types.XGettingCollection;
import one.microstream.collections.types.XGettingEnum;
import one.microstream.collections.types.XGettingSequence;
import one.microstream.exceptions.TypeCastException;
import one.microstream.hashing.HashEqualator;
import one.microstream.memory.XMemory;
import one.microstream.persistence.binary.types.Binary;
import one.microstream.persistence.binary.types.BinaryPersistence;
import one.microstream.persistence.binary.types.BinaryTypeHandler;
import one.microstream.persistence.binary.types.BinaryValueFunctions;
import one.microstream.persistence.binary.types.BinaryValueSetter;
import one.microstream.persistence.binary.types.BinaryValueStorer;
import one.microstream.persistence.exceptions.PersistenceExceptionTypeConsistency;
import one.microstream.persistence.types.PersistenceEagerStoringFieldEvaluator;
import one.microstream.persistence.types.PersistenceFieldLengthResolver;
import one.microstream.persistence.types.PersistenceFunction;
import one.microstream.persistence.types.PersistenceLoadHandler;
import one.microstream.persistence.types.PersistenceObjectIdAcceptor;
import one.microstream.persistence.types.PersistenceReferenceLoader;
import one.microstream.persistence.types.PersistenceStoreHandler;
import one.microstream.persistence.types.PersistenceTypeDefinitionMember;
import one.microstream.persistence.types.PersistenceTypeDefinitionMemberFieldReflective;
import one.microstream.persistence.types.PersistenceTypeDescriptionMember;
import one.microstream.persistence.types.PersistenceTypeHandlerReflective;
import one.microstream.persistence.types.Persister;
import one.microstream.reflect.XReflect;
import one.microstream.util.UtilStackTrace;

public abstract class AbstractBinaryHandlerReflective<T>
extends BinaryTypeHandler.Abstract<T>
implements PersistenceTypeHandlerReflective<Binary, T> {
    private final EqConstHashEnum<PersistenceTypeDefinitionMember> membersInDeclaredOrder;
    private final EqConstHashEnum<PersistenceTypeDefinitionMemberFieldReflective> referenceMembers;
    private final EqConstHashEnum<PersistenceTypeDefinitionMemberFieldReflective> primitiveMembers;
    private final EqConstHashEnum<PersistenceTypeDefinitionMemberFieldReflective> storingMembers;
    private final EqConstHashEnum<PersistenceTypeDefinitionMemberFieldReflective> settingMembers;
    private final long[] storingMemoryOffsets;
    private final long[] settingMemoryOffsets;
    private final long[] refrnceMemoryOffsets;
    private final long refBinaryOffsetStart;
    private final long refBinaryOffsetBound;
    private final long binaryContentLength;
    private final BinaryValueStorer[] storers;
    private final BinaryValueSetter[] setters;
    private final EqConstHashEnum<Field> declOrderFields;
    private final EqConstHashEnum<Field> referenceFields;
    private final EqConstHashEnum<Field> primitiveFields;
    private final Field[] persisterFields;
    private final boolean switchByteOrder;

    protected static <D extends PersistenceTypeDefinitionMember> EqHashEnum<D> MemberEnum() {
        return EqHashEnum.New((HashEqualator)PersistenceTypeDescriptionMember.identityHashEqualator());
    }

    protected static <D extends PersistenceTypeDefinitionMember> EqHashEnum<D> MemberEnum(XGettingCollection<D> initialMembers) {
        return AbstractBinaryHandlerReflective.MemberEnum().addAll(initialMembers);
    }

    protected static EqHashEnum<PersistenceTypeDefinitionMemberFieldReflective> deriveMembers(XGettingEnum<Field> fields, PersistenceFieldLengthResolver lengthResolver) {
        EqHashEnum members = AbstractBinaryHandlerReflective.MemberEnum();
        for (Field field : fields) {
            if (XReflect.isStatic((Member)field)) {
                throw new PersistenceExceptionTypeConsistency("static fields are not persistable.");
            }
            PersistenceTypeDefinitionMemberFieldReflective member = AbstractBinaryHandlerReflective.declaredField((Field)field, (PersistenceFieldLengthResolver)lengthResolver);
            if (members.add((Object)member)) continue;
            throw new PersistenceExceptionTypeConsistency("Duplicate member descriptions.");
        }
        return members;
    }

    protected static final EqConstHashEnum<PersistenceTypeDefinitionMemberFieldReflective> filter(XGettingCollection<? extends PersistenceTypeDefinitionMemberFieldReflective> fields, Predicate<? super PersistenceTypeDefinitionMemberFieldReflective> predicate) {
        return ((EqHashEnum)fields.filterTo((Consumer)EqHashEnum.New(), predicate)).immure();
    }

    protected static final <C extends Consumer<? super Field>> C unbox(XGettingCollection<? extends PersistenceTypeDefinitionMemberFieldReflective> members, C collector) {
        return (C)PersistenceTypeDefinitionMemberFieldReflective.unbox(members, collector);
    }

    protected static final long equal(long value1, long value2) throws IllegalArgumentException {
        if (value1 != value2) {
            throw (IllegalArgumentException)UtilStackTrace.cutStacktraceByOne((Throwable)new IllegalArgumentException());
        }
        return value1;
    }

    protected static void createStorers(Class<?> entityType, Iterable<PersistenceTypeDefinitionMemberFieldReflective> storingMembers, BinaryValueStorer[] storers, PersistenceEagerStoringFieldEvaluator eagerEvaluator, boolean switchByteOrder) {
        int i = 0;
        for (PersistenceTypeDefinitionMemberFieldReflective member : storingMembers) {
            boolean isEager = eagerEvaluator.isEagerStoring(entityType, member.field());
            storers[i++] = BinaryValueFunctions.getObjectValueStorer(member.type(), isEager, switchByteOrder);
        }
    }

    protected static long calculcateBinaryContentLength(Iterable<PersistenceTypeDefinitionMemberFieldReflective> storingMembers) {
        long binaryContentLength = 0L;
        for (PersistenceTypeDefinitionMemberFieldReflective member : storingMembers) {
            long fixedBinaryLength = AbstractBinaryHandlerReflective.equal(member.persistentMinimumLength(), member.persistentMaximumLength());
            binaryContentLength += fixedBinaryLength;
        }
        return binaryContentLength;
    }

    protected static final XGettingSequence<PersistenceTypeDefinitionMemberFieldReflective> createTypeDescriptionMembers(Field[] persistentOrderFields, PersistenceFieldLengthResolver lengthResolver) {
        BulkList members = BulkList.New();
        Field[] fieldArray = persistentOrderFields;
        int n = persistentOrderFields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            members.add((Object)AbstractBinaryHandlerReflective.declaredField((Field)field, (PersistenceFieldLengthResolver)lengthResolver));
            ++n2;
        }
        return members;
    }

    protected static final long[] objectFieldOffsets(Class<?> entityClass, XGettingSequence<? extends PersistenceTypeDefinitionMemberFieldReflective> members) {
        Field[] fields = (Field[])AbstractBinaryHandlerReflective.unbox(members, BulkList.New()).toArray(Field.class);
        long[] objectFieldOffsets = XMemory.objectFieldOffsets(entityClass, (Field[])fields);
        return objectFieldOffsets;
    }

    protected AbstractBinaryHandlerReflective(Class<T> type, String typeName, XGettingEnum<Field> persistableFields, XGettingEnum<Field> persisterFields, PersistenceFieldLengthResolver lengthResolver, PersistenceEagerStoringFieldEvaluator eagerEvaluator, boolean switchByteOrder) {
        super(type, typeName);
        this.switchByteOrder = switchByteOrder;
        XMemory.ensureClassInitialized(type, persistableFields);
        EqHashEnum<PersistenceTypeDefinitionMemberFieldReflective> instMembersInDeclOrdr = AbstractBinaryHandlerReflective.deriveMembers(persistableFields, lengthResolver);
        this.membersInDeclaredOrder = this.deriveAllMembers((XGettingSequence<? extends PersistenceTypeDefinitionMember>)instMembersInDeclOrdr);
        this.referenceMembers = this.filterReferenceMembers((XGettingCollection<PersistenceTypeDefinitionMemberFieldReflective>)instMembersInDeclOrdr, (EqHashEnum<PersistenceTypeDefinitionMemberFieldReflective>)AbstractBinaryHandlerReflective.MemberEnum()).immure();
        this.primitiveMembers = this.filterPrimitiveMembers((XGettingCollection<PersistenceTypeDefinitionMemberFieldReflective>)instMembersInDeclOrdr, (EqHashEnum<PersistenceTypeDefinitionMemberFieldReflective>)AbstractBinaryHandlerReflective.MemberEnum()).immure();
        this.storingMembers = AbstractBinaryHandlerReflective.MemberEnum(this.referenceMembers).addAll(this.primitiveMembers).immure();
        this.settingMembers = this.filterSettingMembers(this.storingMembers);
        this.storingMemoryOffsets = this.initializeStoringMemoryOffsets();
        this.settingMemoryOffsets = this.initializeSettingMemoryOffsets();
        this.refrnceMemoryOffsets = this.initializeStoringRefMemOffsets();
        this.refBinaryOffsetStart = 0L;
        this.refBinaryOffsetBound = Binary.referenceBinaryLength(this.referenceMembers.size());
        this.storers = new BinaryValueStorer[this.storingMembers.intSize()];
        AbstractBinaryHandlerReflective.createStorers(type, this.storingMembers, this.storers, eagerEvaluator, switchByteOrder);
        this.setters = this.deriveSetters();
        this.binaryContentLength = AbstractBinaryHandlerReflective.calculcateBinaryContentLength(this.storingMembers);
        this.declOrderFields = AbstractBinaryHandlerReflective.unbox(instMembersInDeclOrdr, EqHashEnum.New()).immure();
        this.referenceFields = AbstractBinaryHandlerReflective.unbox(this.referenceMembers, EqHashEnum.New()).immure();
        this.primitiveFields = AbstractBinaryHandlerReflective.unbox(this.primitiveMembers, EqHashEnum.New()).immure();
        this.persisterFields = persisterFields == null || persisterFields.isEmpty() ? null : (Field[])persisterFields.toArray(Field.class);
    }

    protected long[] initializeStoringMemoryOffsets() {
        return AbstractBinaryHandlerReflective.objectFieldOffsets(this.type(), this.storingMembers);
    }

    protected long[] initializeSettingMemoryOffsets() {
        return this.storingMemoryOffsets;
    }

    protected BinaryValueSetter[] deriveSetters() {
        EqConstHashEnum<PersistenceTypeDefinitionMemberFieldReflective> members = this.settingMembers;
        BinaryValueSetter[] setters = new BinaryValueSetter[members.intSize()];
        int i = 0;
        for (PersistenceTypeDefinitionMemberFieldReflective member : members) {
            setters[i++] = this.deriveSetter(member);
        }
        return setters;
    }

    protected BinaryValueSetter deriveSetter(PersistenceTypeDefinitionMemberFieldReflective member) {
        return BinaryValueFunctions.getObjectValueSetter(member.type(), this.isSwitchedByteOrder());
    }

    protected long[] initializeStoringRefMemOffsets() {
        return AbstractBinaryHandlerReflective.objectFieldOffsets(this.type(), this.referenceMembers);
    }

    protected EqConstHashEnum<PersistenceTypeDefinitionMemberFieldReflective> filterSettingMembers(EqConstHashEnum<PersistenceTypeDefinitionMemberFieldReflective> members) {
        return members;
    }

    protected EqHashEnum<PersistenceTypeDefinitionMemberFieldReflective> filterReferenceMembers(XGettingCollection<PersistenceTypeDefinitionMemberFieldReflective> members, EqHashEnum<PersistenceTypeDefinitionMemberFieldReflective> target) {
        return (EqHashEnum)members.filterTo(target, m -> m.isReference());
    }

    protected EqHashEnum<PersistenceTypeDefinitionMemberFieldReflective> filterPrimitiveMembers(XGettingCollection<PersistenceTypeDefinitionMemberFieldReflective> members, EqHashEnum<PersistenceTypeDefinitionMemberFieldReflective> target) {
        return (EqHashEnum)members.filterTo(target, m -> m.isPrimitive());
    }

    protected EqConstHashEnum<PersistenceTypeDefinitionMember> deriveAllMembers(XGettingSequence<? extends PersistenceTypeDefinitionMember> declaredOrderInstanceMembers) {
        return EqConstHashEnum.New(declaredOrderInstanceMembers);
    }

    public final boolean isSwitchedByteOrder() {
        return this.switchByteOrder;
    }

    public XGettingEnum<Field> instanceFields() {
        return this.declOrderFields;
    }

    public XGettingEnum<Field> instancePrimitiveFields() {
        return this.primitiveFields;
    }

    public XGettingEnum<Field> instanceReferenceFields() {
        return this.referenceFields;
    }

    public final boolean isPrimitiveType() {
        return false;
    }

    public XGettingEnum<? extends PersistenceTypeDefinitionMember> allMembers() {
        return this.instanceMembers();
    }

    public XGettingEnum<? extends PersistenceTypeDefinitionMemberFieldReflective> instanceMembers() {
        return this.storingMembers();
    }

    public XGettingEnum<? extends PersistenceTypeDefinitionMemberFieldReflective> storingMembers() {
        return this.storingMembers;
    }

    public XGettingEnum<? extends PersistenceTypeDefinitionMemberFieldReflective> settingMembers() {
        return this.settingMembers;
    }

    public XGettingEnum<? extends PersistenceTypeDefinitionMember> membersInDeclaredOrder() {
        return this.membersInDeclaredOrder;
    }

    public final boolean hasPersistedReferences() {
        return !this.referenceMembers.isEmpty();
    }

    public final long membersPersistedLengthMinimum() {
        return this.binaryContentLength;
    }

    public final long membersPersistedLengthMaximum() {
        return this.binaryContentLength;
    }

    public final boolean hasPersistedVariableLength() {
        return false;
    }

    public final boolean hasVaryingPersistedLengthInstances() {
        return false;
    }

    public void store(Binary data, T instance, long objectId, PersistenceStoreHandler<Binary> handler) {
        data.storeFixedSize(handler, this.binaryContentLength, this.typeId(), objectId, instance, this.storingMemoryOffsets, this.storers);
    }

    public abstract T create(Binary var1, PersistenceLoadHandler var2);

    public void updateState(Binary data, T instance, PersistenceLoadHandler handler) {
        if (!this.type().isInstance(instance)) {
            throw new TypeCastException(this.type(), instance);
        }
        data.updateFixedSize(instance, this.setters, this.settingMemoryOffsets, handler);
        this.setPersister(instance, handler);
    }

    private void setPersister(T instance, PersistenceLoadHandler handler) {
        if (this.persisterFields == null) {
            return;
        }
        Persister persister = handler.getPersister();
        Field[] fieldArray = this.persisterFields;
        int n = this.persisterFields.length;
        int n2 = 0;
        while (n2 < n) {
            Object existingPersister;
            Field field = fieldArray[n2];
            if (field.getType().isAssignableFrom(persister.getClass()) && (existingPersister = XReflect.getFieldValue((Field)field, instance)) == null) {
                XReflect.setFieldValue((Field)field, instance, (Object)persister);
            }
            ++n2;
        }
    }

    public final void complete(Binary data, T instance, PersistenceLoadHandler handler) {
    }

    public void iterateInstanceReferences(T instance, PersistenceFunction iterator) {
        BinaryPersistence.iterateInstanceReferences(iterator, instance, this.refrnceMemoryOffsets);
    }

    public void iterateLoadableReferences(Binary data, PersistenceReferenceLoader iterator) {
        data.iterateReferenceRange(this.refBinaryOffsetStart, this.refBinaryOffsetBound, (PersistenceObjectIdAcceptor)iterator);
    }

    public <C extends Consumer<? super Class<?>>> C iterateMemberTypes(C logic) {
        for (Field field : this.instanceFields()) {
            logic.accept(field.getType());
        }
        return logic;
    }
}

