/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.binary.java.lang;

import java.lang.reflect.Array;
import one.microstream.X;
import one.microstream.collections.types.XGettingSequence;
import one.microstream.persistence.binary.java.lang.AbstractBinaryHandlerNativeArray;
import one.microstream.persistence.binary.types.Binary;
import one.microstream.persistence.types.Persistence;
import one.microstream.persistence.types.PersistenceFunction;
import one.microstream.persistence.types.PersistenceLoadHandler;
import one.microstream.persistence.types.PersistenceObjectIdAcceptor;
import one.microstream.persistence.types.PersistenceReferenceLoader;
import one.microstream.persistence.types.PersistenceStoreHandler;
import one.microstream.persistence.types.PersistenceTypeDefinitionMemberFieldGeneric;
import one.microstream.reflect.XReflect;

public final class BinaryHandlerNativeArrayObject<A>
extends AbstractBinaryHandlerNativeArray<A> {
    static final long BINARY_OFFSET_ELEMENTS = 0L;
    private final Class<A> arrayType;
    private final transient Class<?> componentType;

    public static <T> BinaryHandlerNativeArrayObject<T> New(Class<T> type) {
        return new BinaryHandlerNativeArrayObject((Class)X.notNull(type));
    }

    BinaryHandlerNativeArrayObject(Class<A> arrayType) {
        super(XReflect.validateArrayType(arrayType), (XGettingSequence<? extends PersistenceTypeDefinitionMemberFieldGeneric>)BinaryHandlerNativeArrayObject.defineElementsType(arrayType.getComponentType()));
        this.arrayType = arrayType;
        this.componentType = XReflect.validateNonPrimitiveType(arrayType.getComponentType());
    }

    public final Class<A> getArrayType() {
        return this.arrayType;
    }

    public final boolean hasPersistedReferences() {
        return true;
    }

    @Override
    public final void store(Binary data, A instance, long objectId, PersistenceStoreHandler<Binary> handler) {
        data.storeReferences(this.typeId(), objectId, 0L, (PersistenceFunction)handler, (Object[])instance, 0, ((Object[])instance).length);
    }

    @Override
    public final A create(Binary data, PersistenceLoadHandler handler) {
        long rawElementCount = data.getListElementCountReferences(0L);
        return this.arrayType.cast(Array.newInstance(this.componentType, X.checkArrayRange((long)rawElementCount)));
    }

    public final void updateState(Binary data, A instance, PersistenceLoadHandler handler) {
        Object[] arrayInstance = (Object[])instance;
        data.validateArrayLength(arrayInstance, 0L);
        data.collectElementsIntoArray(0L, handler, arrayInstance);
    }

    @Override
    public final void iterateInstanceReferences(A instance, PersistenceFunction iterator) {
        Persistence.iterateReferences((PersistenceFunction)iterator, (Object[])((Object[])instance), (int)0, (int)((Object[])instance).length);
    }

    public final void iterateLoadableReferences(Binary data, PersistenceReferenceLoader iterator) {
        data.iterateListElementReferences(0L, (PersistenceObjectIdAcceptor)iterator);
    }
}

