/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.binary.one.microstream.persistence.types;

import one.microstream.X;
import one.microstream.chars.XChars;
import one.microstream.collections.EqHashTable;
import one.microstream.collections.types.XGettingEnum;
import one.microstream.collections.types.XGettingSequence;
import one.microstream.collections.types.XGettingTable;
import one.microstream.collections.types.XMap;
import one.microstream.collections.types.XTable;
import one.microstream.persistence.binary.internal.AbstractBinaryHandlerCustom;
import one.microstream.persistence.binary.types.Binary;
import one.microstream.persistence.types.Persistence;
import one.microstream.persistence.types.PersistenceFunction;
import one.microstream.persistence.types.PersistenceLoadHandler;
import one.microstream.persistence.types.PersistenceObjectIdAcceptor;
import one.microstream.persistence.types.PersistenceObjectRegistry;
import one.microstream.persistence.types.PersistenceReferenceLoader;
import one.microstream.persistence.types.PersistenceRootEntry;
import one.microstream.persistence.types.PersistenceRootResolver;
import one.microstream.persistence.types.PersistenceRootResolverProvider;
import one.microstream.persistence.types.PersistenceRoots;
import one.microstream.persistence.types.PersistenceStoreHandler;
import one.microstream.persistence.types.PersistenceTypeDefinitionMember;
import one.microstream.persistence.types.PersistenceTypeDefinitionMemberFieldGeneric;
import one.microstream.persistence.types.PersistenceTypeDescriptionMemberFieldGeneric;
import one.microstream.reference.Referencing;
import one.microstream.typing.KeyValue;

public final class BinaryHandlerPersistenceRootsDefault
extends AbstractBinaryHandlerCustom<PersistenceRoots.Default> {
    private final PersistenceRootResolverProvider rootResolverProvider;
    final PersistenceObjectRegistry globalRegistry;

    public static BinaryHandlerPersistenceRootsDefault New(PersistenceRootResolverProvider rootResolverProvider, PersistenceObjectRegistry globalRegistry) {
        return new BinaryHandlerPersistenceRootsDefault((PersistenceRootResolverProvider)X.notNull((Object)rootResolverProvider), (PersistenceObjectRegistry)X.notNull((Object)globalRegistry));
    }

    BinaryHandlerPersistenceRootsDefault(PersistenceRootResolverProvider rootResolverProvider, PersistenceObjectRegistry globalRegistry) {
        super(PersistenceRoots.Default.class, (XGettingSequence<? extends PersistenceTypeDefinitionMember>)BinaryHandlerPersistenceRootsDefault.CustomFields(new PersistenceTypeDefinitionMemberFieldGeneric[]{BinaryHandlerPersistenceRootsDefault.Complex("instances", new PersistenceTypeDescriptionMemberFieldGeneric[]{BinaryHandlerPersistenceRootsDefault.CustomField(Object.class, "instance")}), BinaryHandlerPersistenceRootsDefault.Complex("identifiers", new PersistenceTypeDescriptionMemberFieldGeneric[]{BinaryHandlerPersistenceRootsDefault.chars("identifier")})}));
        this.rootResolverProvider = rootResolverProvider;
        this.globalRegistry = globalRegistry;
    }

    public final boolean hasVaryingPersistedLengthInstances() {
        return true;
    }

    public final boolean hasPersistedReferences() {
        return true;
    }

    public final boolean hasPersistedVariableLength() {
        return true;
    }

    @Override
    public final void store(Binary data, PersistenceRoots.Default instance, long objectId, PersistenceStoreHandler<Binary> handler) {
        data.storeRoots(this.typeId(), objectId, (XGettingTable<String, Object>)instance.entries(), (PersistenceFunction)handler);
    }

    @Override
    public final PersistenceRoots.Default create(Binary data, PersistenceLoadHandler handler) {
        EqHashTable rootIdMapping = data.buildRootMapping(EqHashTable.New());
        return PersistenceRoots.Default.New((PersistenceRootResolver)this.rootResolverProvider.provideRootResolver(), (EqHashTable)rootIdMapping);
    }

    public final void updateState(Binary data, PersistenceRoots.Default instance, PersistenceLoadHandler handler) {
        PersistenceRootResolver rootResolver = instance.$rootResolver();
        EqHashTable rootIdMapping = instance.$rootIdMapping();
        EqHashTable resolvedRootEntries = EqHashTable.New();
        this.ensureRefactoredOldRoots((EqHashTable<String, Long>)rootIdMapping, (EqHashTable<String, PersistenceRootEntry>)resolvedRootEntries, handler);
        rootResolver.resolveRootEntries((XMap)resolvedRootEntries, (XGettingEnum)rootIdMapping.keys());
        XTable resolvedRoots = rootResolver.resolveRootInstances((XGettingTable)resolvedRootEntries);
        instance.loadingUpdateEntries((XGettingTable)resolvedRoots);
        this.registerInstancesPerObjectId((XGettingTable<String, PersistenceRootEntry>)resolvedRootEntries, (XGettingTable<String, Long>)rootIdMapping);
    }

    @Deprecated
    private boolean ensureRefactoredOldRoots(EqHashTable<String, Long> rootIdMapping, EqHashTable<String, PersistenceRootEntry> resolvedRoots, PersistenceLoadHandler handler) {
        Long customRootOid = (Long)rootIdMapping.get((Object)Persistence.customRootIdentifier());
        Long defaultRootOid = (Long)rootIdMapping.get((Object)Persistence.defaultRootIdentifier());
        if (customRootOid == null && defaultRootOid == null) {
            return false;
        }
        Object root = this.rootResolverProvider.rootReference().get();
        if (root == null) {
            if (customRootOid != null) {
                Object customRoot = handler.lookupObject(customRootOid.longValue());
                if (customRoot == null) {
                    throw new Error("Root instance missing for identifier \"" + Persistence.customRootIdentifier() + "\"");
                }
                this.rootResolverProvider.rootReference().set(customRoot);
                resolvedRoots.add((Object)Persistence.customRootIdentifier(), null);
                return true;
            }
            if (defaultRootOid != null) {
                Object defaultRoot = handler.lookupObject(defaultRootOid.longValue());
                if (defaultRoot == null) {
                    throw new Error("Root instance missing for identifier \"" + Persistence.defaultRootIdentifier() + "\"");
                }
                if (!(defaultRoot instanceof Referencing)) {
                    throw new Error("Inconsistently typed default root instance: " + XChars.systemString((Object)defaultRoot));
                }
                Referencing casted = (Referencing)defaultRoot;
                this.rootResolverProvider.rootReference().setRootSupplier(() -> casted.get());
                resolvedRoots.add((Object)Persistence.defaultRootIdentifier(), null);
                return true;
            }
        } else {
            if (customRootOid != null) {
                handler.registerCustomRootRefactoring(root, customRootOid.longValue());
                resolvedRoots.add((Object)Persistence.customRootIdentifier(), null);
                return true;
            }
            if (defaultRootOid != null) {
                handler.registerDefaultRootRefactoring(root, defaultRootOid.longValue());
                resolvedRoots.add((Object)Persistence.defaultRootIdentifier(), null);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerInstancesPerObjectId(XGettingTable<String, PersistenceRootEntry> resolvedRootEntries, XGettingTable<String, Long> rootIdMapping) {
        PersistenceObjectRegistry registry;
        PersistenceObjectRegistry persistenceObjectRegistry = registry = this.globalRegistry;
        synchronized (persistenceObjectRegistry) {
            for (KeyValue rootEntry : resolvedRootEntries) {
                Object rootInstance;
                if (rootEntry.value() == null || (rootInstance = ((PersistenceRootEntry)rootEntry.value()).instance()) == null) continue;
                Long rootObjectId = (Long)rootIdMapping.get((Object)((String)rootEntry.key()));
                registry.registerConstant(rootObjectId.longValue(), rootInstance);
            }
        }
    }

    @Override
    public final void complete(Binary data, PersistenceRoots.Default instance, PersistenceLoadHandler handler) {
        instance.$discardRootIdMapping();
    }

    @Override
    public final void iterateInstanceReferences(PersistenceRoots.Default instance, PersistenceFunction iterator) {
        for (Object object : instance.entries().values()) {
            iterator.apply(object);
        }
    }

    public final void iterateLoadableReferences(Binary data, PersistenceReferenceLoader iterator) {
        data.iterateListElementReferences(0L, (PersistenceObjectIdAcceptor)iterator);
    }
}

