/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.binary.types;

import java.nio.ByteBuffer;
import one.microstream.X;
import one.microstream.collections.types.XGettingEnum;
import one.microstream.memory.XMemory;
import one.microstream.persistence.binary.internal.AbstractBinaryLegacyTypeHandlerTranslating;
import one.microstream.persistence.binary.types.Binary;
import one.microstream.persistence.binary.types.BinaryReferenceTraverser;
import one.microstream.persistence.binary.types.BinaryValueSetter;
import one.microstream.persistence.types.PersistenceLegacyTypeHandlingListener;
import one.microstream.persistence.types.PersistenceLoadHandler;
import one.microstream.persistence.types.PersistenceObjectIdAcceptor;
import one.microstream.persistence.types.PersistenceReferenceLoader;
import one.microstream.persistence.types.PersistenceTypeDefinition;
import one.microstream.persistence.types.PersistenceTypeHandler;
import one.microstream.typing.KeyValue;

public final class BinaryLegacyTypeHandlerRerouting<T>
extends AbstractBinaryLegacyTypeHandlerTranslating<T> {
    private final BinaryReferenceTraverser[] newBinaryLayoutReferenceTraversers;

    public static <T> BinaryLegacyTypeHandlerRerouting<T> New(PersistenceTypeDefinition typeDefinition, PersistenceTypeHandler<Binary, T> typeHandler, XGettingEnum<KeyValue<Long, BinaryValueSetter>> translatorsWithTargetOffsets, PersistenceLegacyTypeHandlingListener<Binary> listener, boolean switchByteOrder) {
        return new BinaryLegacyTypeHandlerRerouting<T>((PersistenceTypeDefinition)X.notNull((Object)typeDefinition), (PersistenceTypeHandler)X.notNull(typeHandler), BinaryLegacyTypeHandlerRerouting.toTranslators(translatorsWithTargetOffsets), BinaryLegacyTypeHandlerRerouting.toTargetOffsets(translatorsWithTargetOffsets), (PersistenceLegacyTypeHandlingListener<Binary>)((PersistenceLegacyTypeHandlingListener)X.mayNull(listener)), switchByteOrder);
    }

    BinaryLegacyTypeHandlerRerouting(PersistenceTypeDefinition typeDefinition, PersistenceTypeHandler<Binary, T> typeHandler, BinaryValueSetter[] valueTranslators, long[] targetOffsets, PersistenceLegacyTypeHandlingListener<Binary> listener, boolean switchByteOrder) {
        super(typeDefinition, typeHandler, valueTranslators, targetOffsets, listener, switchByteOrder);
        this.newBinaryLayoutReferenceTraversers = BinaryLegacyTypeHandlerRerouting.deriveReferenceTraversers(typeHandler, switchByteOrder);
    }

    public final void iterateLoadableReferences(Binary rawData, PersistenceReferenceLoader iterator) {
        rawData.iterateReferences(this.newBinaryLayoutReferenceTraversers, (PersistenceObjectIdAcceptor)iterator);
    }

    @Override
    protected T internalCreate(Binary rawData, PersistenceLoadHandler handler) {
        long entityContentLength = this.typeHandler().membersPersistedLengthMaximum();
        long entityTotalLength = Binary.entityTotalLength(entityContentLength);
        long entityTypeId = this.typeHandler().typeId();
        long entityObjectId = rawData.getBuildItemObjectId();
        ByteBuffer directByteBuffer = XMemory.allocateDirectNative((long)entityTotalLength);
        long entityOffset = 0L;
        long targetContentOffset = Binary.toEntityContentOffset(0L);
        rawData.copyMemory(directByteBuffer, targetContentOffset, this.valueTranslators(), this.targetOffsets());
        rawData.modifyLoadItem(directByteBuffer, 0L, entityTotalLength, entityTypeId, entityObjectId);
        rawData.registerHelper(directByteBuffer, directByteBuffer);
        Object instance = this.typeHandler().create((Object)rawData, handler);
        return (T)instance;
    }

    public final void updateState(Binary rawData, T instance, PersistenceLoadHandler handler) {
        this.typeHandler().updateState((Object)rawData, instance, handler);
    }

    public final void complete(Binary rawData, T instance, PersistenceLoadHandler handler) {
        this.typeHandler().complete((Object)rawData, instance, handler);
    }
}

