/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.binary.types;

import one.microstream.X;
import one.microstream.hashing.XHashing;
import one.microstream.math.XMath;
import one.microstream.persistence.binary.types.Binary;
import one.microstream.persistence.binary.types.BinaryChannelCountProvider;
import one.microstream.persistence.binary.types.ChunksBuffer;
import one.microstream.persistence.binary.types.ChunksBufferByteReversing;
import one.microstream.persistence.types.PersistenceAcceptor;
import one.microstream.persistence.types.PersistenceLocalObjectIdRegistry;
import one.microstream.persistence.types.PersistenceObjectIdRequestor;
import one.microstream.persistence.types.PersistenceObjectManager;
import one.microstream.persistence.types.PersistenceStoreHandler;
import one.microstream.persistence.types.PersistenceStorer;
import one.microstream.persistence.types.PersistenceStoring;
import one.microstream.persistence.types.PersistenceTarget;
import one.microstream.persistence.types.PersistenceTypeHandler;
import one.microstream.persistence.types.PersistenceTypeHandlerManager;
import one.microstream.reference.ObjectSwizzling;
import one.microstream.reference.Swizzling;
import one.microstream.util.BufferSizeProviderIncremental;

public interface BinaryStorer
extends PersistenceStorer {
    public PersistenceStorer reinitialize();

    public PersistenceStorer reinitialize(long var1);

    public PersistenceStorer ensureCapacity(long var1);

    public long currentCapacity();

    public long maximumCapacity();

    public static Creator Creator(BinaryChannelCountProvider channelCountProvider, boolean switchByteOrder) {
        return new Creator.Default((BinaryChannelCountProvider)X.notNull((Object)channelCountProvider), switchByteOrder);
    }

    public static interface Creator
    extends PersistenceStorer.Creator<Binary> {
        public BinaryStorer createLazyStorer(PersistenceTypeHandlerManager<Binary> var1, PersistenceObjectManager<Binary> var2, ObjectSwizzling var3, PersistenceTarget<Binary> var4, BufferSizeProviderIncremental var5);

        default public BinaryStorer createStorer(PersistenceTypeHandlerManager<Binary> typeManager, PersistenceObjectManager<Binary> objectManager, ObjectSwizzling objectRetriever, PersistenceTarget<Binary> target, BufferSizeProviderIncremental bufferSizeProvider) {
            return this.createLazyStorer((PersistenceTypeHandlerManager)typeManager, (PersistenceObjectManager)objectManager, objectRetriever, (PersistenceTarget)target, bufferSizeProvider);
        }

        public BinaryStorer createEagerStorer(PersistenceTypeHandlerManager<Binary> var1, PersistenceObjectManager<Binary> var2, ObjectSwizzling var3, PersistenceTarget<Binary> var4, BufferSizeProviderIncremental var5);

        public static abstract class Abstract
        implements Creator {
            private final BinaryChannelCountProvider channelCountProvider;
            private final boolean switchByteOrder;

            protected Abstract(BinaryChannelCountProvider channelCountProvider, boolean switchByteOrder) {
                this.channelCountProvider = channelCountProvider;
                this.switchByteOrder = switchByteOrder;
            }

            protected int channelCount() {
                return this.channelCountProvider.getChannelCount();
            }

            protected boolean switchByteOrder() {
                return this.switchByteOrder;
            }
        }

        public static final class Default
        extends Abstract {
            Default(BinaryChannelCountProvider channelCountProvider, boolean switchByteOrder) {
                super(channelCountProvider, switchByteOrder);
            }

            @Override
            public final BinaryStorer createLazyStorer(PersistenceTypeHandlerManager<Binary> typeManager, PersistenceObjectManager<Binary> objectManager, ObjectSwizzling objectRetriever, PersistenceTarget<Binary> target, BufferSizeProviderIncremental bufferSizeProvider) {
                this.validateIsStoring(target);
                one.microstream.persistence.binary.types.BinaryStorer$Default storer = new one.microstream.persistence.binary.types.BinaryStorer$Default(objectManager, objectRetriever, typeManager, target, bufferSizeProvider, this.channelCount(), this.switchByteOrder());
                objectManager.registerLocalRegistry((PersistenceLocalObjectIdRegistry)storer);
                return storer;
            }

            @Override
            public BinaryStorer createEagerStorer(PersistenceTypeHandlerManager<Binary> typeManager, PersistenceObjectManager<Binary> objectManager, ObjectSwizzling objectRetriever, PersistenceTarget<Binary> target, BufferSizeProviderIncremental bufferSizeProvider) {
                this.validateIsStoring(target);
                Eager storer = new Eager(objectManager, objectRetriever, typeManager, target, bufferSizeProvider, this.channelCount(), this.switchByteOrder());
                objectManager.registerLocalRegistry((PersistenceLocalObjectIdRegistry)storer);
                return storer;
            }

            protected void validateIsStoring(PersistenceTarget<Binary> target) {
                target.validateIsStoringEnabled();
            }
        }
    }

    public static class Default
    implements BinaryStorer,
    PersistenceStoreHandler<Binary>,
    PersistenceLocalObjectIdRegistry<Binary> {
        private final boolean switchByteOrder;
        private final PersistenceObjectManager<Binary> objectManager;
        private final ObjectSwizzling objectRetriever;
        private final PersistenceTypeHandlerManager<Binary> typeManager;
        private final PersistenceTarget<Binary> target;
        private final BufferSizeProviderIncremental bufferSizeProvider;
        private final int chunksHashRange;
        private ChunksBuffer[] chunks;
        final Item head = new Item(null, 0L, null, null);
        private Item tail;
        private Item[] hashSlots;
        private int hashRange;
        private long itemCount;

        protected static int defaultSlotSize() {
            return 1024;
        }

        protected Default(PersistenceObjectManager<Binary> objectManager, ObjectSwizzling objectRetriever, PersistenceTypeHandlerManager<Binary> typeManager, PersistenceTarget<Binary> target, BufferSizeProviderIncremental bufferSizeProvider, int channelCount, boolean switchByteOrder) {
            this.objectManager = (PersistenceObjectManager)X.notNull(objectManager);
            this.objectRetriever = (ObjectSwizzling)X.notNull((Object)objectRetriever);
            this.typeManager = (PersistenceTypeHandlerManager)X.notNull(typeManager);
            this.target = (PersistenceTarget)X.notNull(target);
            this.bufferSizeProvider = (BufferSizeProviderIncremental)X.notNull((Object)bufferSizeProvider);
            this.chunksHashRange = channelCount - 1;
            this.switchByteOrder = switchByteOrder;
            this.defaultInitialize();
        }

        public final PersistenceObjectManager<Binary> parentObjectManager() {
            return this.objectManager;
        }

        public final ObjectSwizzling getObjectRetriever() {
            return this.objectRetriever;
        }

        @Override
        public final long maximumCapacity() {
            return Long.MAX_VALUE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final long currentCapacity() {
            Item item = this.head;
            synchronized (item) {
                return this.hashSlots.length;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final long size() {
            Item item = this.head;
            synchronized (item) {
                return this.itemCount;
            }
        }

        protected ChunksBuffer synchLookupChunk(long objectId) {
            return this.chunks[(int)(objectId & (long)this.chunksHashRange)];
        }

        protected Binary synchComplete() {
            ChunksBuffer[] chunksBufferArray = this.chunks;
            int n = this.chunks.length;
            int n2 = 0;
            while (n2 < n) {
                ChunksBuffer chunk = chunksBufferArray[n2];
                chunk.complete();
                ++n2;
            }
            return this.chunks[0];
        }

        @Override
        public PersistenceStorer reinitialize() {
            this.defaultInitialize();
            return this;
        }

        @Override
        public PersistenceStorer reinitialize(long initialCapacity) {
            this.internalInitialize(XHashing.padHashLength((long)initialCapacity));
            return this;
        }

        public void clear() {
            this.reinitialize();
        }

        private void defaultInitialize() {
            this.internalInitialize(Default.defaultSlotSize());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void internalInitialize(int hashLength) {
            Item item = this.head;
            synchronized (item) {
                this.hashSlots = new Item[hashLength];
                this.hashRange = hashLength - 1;
                this.tail = this.head;
                this.head.next = null;
                this.synchCreateStoringChunksBuffers();
            }
        }

        private void synchCreateStoringChunksBuffers() {
            this.chunks = new ChunksBuffer[this.chunksHashRange + 1];
            ChunksBuffer[] chunks = this.chunks;
            int i = 0;
            while (i < chunks.length) {
                chunks[i] = this.switchByteOrder ? ChunksBufferByteReversing.New(chunks, this.bufferSizeProvider) : ChunksBuffer.New(chunks, this.bufferSizeProvider);
                ++i;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public PersistenceStorer ensureCapacity(long desiredCapacity) {
            Item item = this.head;
            synchronized (item) {
                if (this.currentCapacity() >= desiredCapacity) {
                    return this;
                }
                this.synchRebuildStoreItems(XHashing.padHashLength((long)desiredCapacity));
            }
            return this;
        }

        public <T> long apply(T instance) {
            if (instance == null) {
                return Swizzling.nullId();
            }
            long objectIdLocal = this.lookupOid(instance);
            if (Swizzling.isFoundId((long)objectIdLocal)) {
                return objectIdLocal;
            }
            return this.register(instance);
        }

        public <T> long apply(T instance, PersistenceTypeHandler<Binary, T> localTypeHandler) {
            if (instance == null) {
                return Swizzling.nullId();
            }
            long objectIdLocal = this.lookupOid(instance);
            if (Swizzling.isFoundId((long)objectIdLocal)) {
                return objectIdLocal;
            }
            return this.objectManager.ensureObjectId(instance, (PersistenceObjectIdRequestor)this, localTypeHandler);
        }

        public final <T> long applyEager(T instance) {
            if (instance == null) {
                return Swizzling.nullId();
            }
            long objectIdLocal = this.lookupOid(instance);
            if (Swizzling.isFoundId((long)objectIdLocal)) {
                return objectIdLocal;
            }
            return this.registerGuaranteed(instance);
        }

        public <T> long applyEager(T instance, PersistenceTypeHandler<Binary, T> localTypeHandler) {
            if (instance == null) {
                return Swizzling.nullId();
            }
            long objectIdLocal = this.lookupOid(instance);
            if (Swizzling.isFoundId((long)objectIdLocal)) {
                return objectIdLocal;
            }
            return this.objectManager.ensureObjectIdGuaranteedRegister(instance, (PersistenceObjectIdRequestor)this, localTypeHandler);
        }

        protected final long storeGraph(Object root) {
            long rootOid = this.lookupOid(root);
            if (Swizzling.isFoundId((long)rootOid)) {
                return rootOid;
            }
            rootOid = this.registerGuaranteed(X.notNull((Object)root));
            Item item = this.tail;
            while (item != null) {
                this.storeItem(item);
                item = item.next;
            }
            return rootOid;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void storeItem(Item item) {
            Item item2 = this.head;
            synchronized (item2) {
                item.typeHandler.store((Object)this.synchLookupChunk(item.oid), item.instance, item.oid, (PersistenceStoreHandler)this);
            }
        }

        public final long store(Object root) {
            return this.storeGraph(root);
        }

        public final long[] storeAll(Object ... instances) {
            long[] oids = new long[instances.length];
            int i = 0;
            while (i < instances.length) {
                oids[i] = this.storeGraph(instances[i]);
                ++i;
            }
            return oids;
        }

        public void storeAll(Iterable<?> instances) {
            for (Object instance : instances) {
                this.storeGraph(instance);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void iterateMergeableEntries(PersistenceAcceptor iterator) {
            Item item = this.head;
            synchronized (item) {
                Item e = this.head;
                while ((e = e.next) != null) {
                    if (Default.isSkipItem(e)) continue;
                    iterator.accept(e.oid, e.instance);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final Object commit() {
            if (!this.isEmpty()) {
                Binary writeData;
                this.target.validateIsStoringEnabled();
                Item item = this.head;
                synchronized (item) {
                    this.typeManager.checkForPendingRootInstances();
                    this.typeManager.checkForPendingRootsStoring((PersistenceStoring)this);
                    writeData = this.synchComplete();
                }
                this.target.write((Object)writeData);
                item = this.head;
                synchronized (item) {
                    this.typeManager.clearStorePendingRoots();
                    this.objectManager.mergeEntries((PersistenceLocalObjectIdRegistry)this);
                }
            }
            this.clear();
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final long lookupOid(Object object) {
            Item item = this.head;
            synchronized (item) {
                Item e = this.hashSlots[System.identityHashCode(object) & this.hashRange];
                while (e != null) {
                    if (e.instance == object) {
                        return e.oid;
                    }
                    e = e.link;
                }
                return Swizzling.notFoundId();
            }
        }

        private static boolean isSkipItem(Item item) {
            return item.typeHandler == null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final <T> long lookupObjectId(T object, PersistenceObjectIdRequestor<Binary> objectIdRequestor, PersistenceTypeHandler<Binary, T> optionalHandler) {
            Item item = this.head;
            synchronized (item) {
                Item e = this.hashSlots[System.identityHashCode(object) & this.hashRange];
                while (e != null) {
                    if (e.instance == object) {
                        if (Default.isSkipItem(e)) break;
                        objectIdRequestor.registerGuaranteed(e.oid, object, optionalHandler);
                        return e.oid;
                    }
                    e = e.link;
                }
                return Swizzling.notFoundId();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final <T> void registerGuaranteed(long objectId, T instance, PersistenceTypeHandler<Binary, T> optionalHandler) {
            Item item = this.head;
            synchronized (item) {
                Item item2;
                PersistenceTypeHandler typeHandler = optionalHandler != null ? optionalHandler : this.typeManager.ensureTypeHandler(instance);
                this.tail = this.tail.next = (item2 = this.synchRegisterObjectId(instance, typeHandler, objectId));
            }
        }

        public <T> void registerLazyOptional(long objectId, T instance, PersistenceTypeHandler<Binary, T> optionalHandler) {
            this.registerGuaranteed(objectId, instance, optionalHandler);
        }

        public <T> void registerEagerOptional(long objectId, T instance, PersistenceTypeHandler<Binary, T> optionalHandler) {
        }

        protected final long register(Object instance) {
            return this.objectManager.ensureObjectId(instance, (PersistenceObjectIdRequestor)this, null);
        }

        protected final long registerGuaranteed(Object instance) {
            return this.objectManager.ensureObjectIdGuaranteedRegister(instance, (PersistenceObjectIdRequestor)this, null);
        }

        public final boolean skipMapped(Object instance, long objectId) {
            return this.internalSkip(instance, objectId);
        }

        public final boolean skip(Object instance) {
            long foundObjectId = this.objectManager.lookupObjectId(instance);
            if (Swizzling.isNotFoundId((long)foundObjectId)) {
                return this.skipNulled(instance);
            }
            return this.internalSkip(instance, foundObjectId);
        }

        public final boolean skipNulled(Object instance) {
            return this.internalSkip(instance, Swizzling.nullId());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final boolean internalSkip(Object instance, long objectId) {
            Item item = this.head;
            synchronized (item) {
                block4: {
                    if (!Swizzling.isNotFoundId((long)this.lookupOid(instance))) break block4;
                    this.synchRegisterObjectId(instance, null, objectId);
                    return true;
                }
                return false;
            }
        }

        public final <T> Item synchRegisterObjectId(T instance, PersistenceTypeHandler<Binary, ? super T> typeHandler, long objectId) {
            if (++this.itemCount >= (long)this.hashRange) {
                this.synchRebuildStoreItems();
            }
            Item item = new Item(instance, objectId, typeHandler, this.hashSlots[System.identityHashCode(instance) & this.hashRange]);
            this.hashSlots[System.identityHashCode(instance) & this.hashRange] = item;
            return item;
        }

        public final void synchRebuildStoreItems() {
            this.synchRebuildStoreItems(this.hashSlots.length * 2);
        }

        public final void synchRebuildStoreItems(int newLength) {
            if (this.hashSlots.length >= XMath.highestPowerOf2_int()) {
                return;
            }
            int newRange = newLength - 1;
            Item[] newSlots = new Item[newRange + 1];
            Item[] itemArray = this.hashSlots;
            int n = this.hashSlots.length;
            int n2 = 0;
            while (n2 < n) {
                Item entry = itemArray[n2];
                while (entry != null) {
                    Item next = entry.link;
                    entry.link = newSlots[System.identityHashCode(entry.instance) & newRange];
                    newSlots[System.identityHashCode((Object)entry.instance) & newRange] = entry;
                    entry = next;
                }
                ++n2;
            }
            this.hashSlots = newSlots;
            this.hashRange = newRange;
        }
    }

    public static final class Eager
    extends Default {
        Eager(PersistenceObjectManager<Binary> objectManager, ObjectSwizzling objectRetriever, PersistenceTypeHandlerManager<Binary> typeManager, PersistenceTarget<Binary> target, BufferSizeProviderIncremental bufferSizeProvider, int channelCount, boolean switchByteOrder) {
            super(objectManager, objectRetriever, typeManager, target, bufferSizeProvider, channelCount, switchByteOrder);
        }

        @Override
        public final <T> long apply(T instance) {
            return this.applyEager(instance);
        }

        @Override
        public <T> void registerLazyOptional(long objectId, T instance, PersistenceTypeHandler<Binary, T> optionalHandler) {
        }

        @Override
        public <T> void registerEagerOptional(long objectId, T instance, PersistenceTypeHandler<Binary, T> optionalHandler) {
            this.registerGuaranteed(objectId, instance, optionalHandler);
        }
    }

    public static final class Item {
        final PersistenceTypeHandler<Binary, Object> typeHandler;
        final Object instance;
        final long oid;
        Item link;
        Item next;

        Item(Object instance, long oid, PersistenceTypeHandler<Binary, Object> typeHandler, Item link) {
            this.instance = instance;
            this.oid = oid;
            this.typeHandler = typeHandler;
            this.link = link;
        }
    }
}

