/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.binary.types;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import one.microstream.persistence.binary.types.Binary;
import one.microstream.persistence.binary.types.BinaryEntityDataReader;
import one.microstream.persistence.binary.types.BinaryReferenceTraverser;
import one.microstream.persistence.types.PersistenceObjectIdAcceptor;
import one.microstream.typing.XTypes;

public class ChunksWrapper
extends Binary {
    private final ByteBuffer[] buffers;
    private final long totalLength;

    public static ChunksWrapper New(ByteBuffer ... chunkDirectBuffers) {
        return new ChunksWrapper(chunkDirectBuffers);
    }

    protected ChunksWrapper(ByteBuffer[] chunks) {
        long totalLength = 0L;
        int i = 0;
        while (i < chunks.length) {
            if (!XTypes.isDirectByteBuffer((ByteBuffer)chunks[i])) {
                throw new IllegalArgumentException();
            }
            totalLength += (long)chunks[i].position();
            ++i;
        }
        this.buffers = chunks;
        this.totalLength = totalLength;
    }

    @Override
    public void iterateEntityData(BinaryEntityDataReader reader) {
        ByteBuffer[] buffers = this.buffers;
        int i = 0;
        while (i < buffers.length) {
            reader.readBinaryEntities(buffers[i]);
            ++i;
        }
    }

    @Override
    public void iterateChannelChunks(Consumer<? super Binary> logic) {
        logic.accept(this);
    }

    @Override
    public final Binary channelChunk(int channelIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final int channelCount() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean isEmpty() {
        return this.totalLength != 0L;
    }

    @Override
    public final long totalLength() {
        return this.totalLength;
    }

    @Override
    public final ByteBuffer[] buffers() {
        return this.buffers;
    }

    @Override
    public final void storeEntityHeader(long entityContentLength, long entityTypeId, long entityObjectId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final long loadItemEntityContentAddress() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void modifyLoadItem(ByteBuffer directByteBuffer, long offset, long entityTotalLength, long entityTypeId, long entityObjectId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long iterateReferences(BinaryReferenceTraverser[] traversers, PersistenceObjectIdAcceptor acceptor) {
        throw new UnsupportedOperationException();
    }
}

