/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.binary.util;

import java.io.Closeable;
import one.microstream.X;
import one.microstream.collections.types.XGettingCollection;
import one.microstream.collections.types.XReference;
import one.microstream.persistence.binary.types.Binary;
import one.microstream.persistence.binary.types.BinaryPersistence;
import one.microstream.persistence.binary.types.BinaryPersistenceFoundation;
import one.microstream.persistence.exceptions.PersistenceExceptionTransfer;
import one.microstream.persistence.types.PersistenceContextDispatcher;
import one.microstream.persistence.types.PersistenceIdSet;
import one.microstream.persistence.types.PersistenceManager;
import one.microstream.persistence.types.PersistenceSource;
import one.microstream.persistence.types.PersistenceTarget;
import one.microstream.persistence.types.PersistenceTypeDictionaryCreator;
import one.microstream.persistence.types.PersistenceTypeDictionaryManager;
import one.microstream.reference.Reference;

public interface ObjectCopier
extends Closeable {
    public <T> T copy(T var1);

    @Override
    public void close();

    public static ObjectCopier New() {
        return new Default(BinaryPersistence.Foundation());
    }

    public static ObjectCopier New(BinaryPersistenceFoundation<?> foundation) {
        return new Default((BinaryPersistenceFoundation)X.notNull(foundation));
    }

    public static class Default
    implements ObjectCopier {
        private final BinaryPersistenceFoundation<?> foundation;
        private PersistenceManager<Binary> persistenceManager;

        Default(BinaryPersistenceFoundation<?> foundation) {
            this.foundation = foundation;
        }

        @Override
        public synchronized <T> T copy(T source) {
            this.lazyInit();
            this.persistenceManager.store(source);
            return (T)this.persistenceManager.get();
        }

        @Override
        public synchronized void close() {
            if (this.persistenceManager != null) {
                this.persistenceManager.objectRegistry().clearAll();
                this.persistenceManager.close();
                this.persistenceManager = null;
            }
        }

        private void lazyInit() {
            if (this.persistenceManager == null) {
                XReference buffer = X.Reference(null);
                CopySource source = () -> Default.lambda$0((Reference)buffer);
                CopyTarget target = arg_0 -> Default.lambda$1((Reference)buffer, arg_0);
                BinaryPersistenceFoundation foundation = (BinaryPersistenceFoundation)((BinaryPersistenceFoundation)((BinaryPersistenceFoundation)this.foundation.setPersistenceSource(source)).setPersistenceTarget(target)).setContextDispatcher((PersistenceContextDispatcher)PersistenceContextDispatcher.LocalObjectRegistration());
                foundation.setTypeDictionaryManager(PersistenceTypeDictionaryManager.Transient((PersistenceTypeDictionaryCreator)foundation.getTypeDictionaryCreator()));
                this.persistenceManager = foundation.createPersistenceManager();
            } else {
                this.persistenceManager.objectRegistry().truncateAll();
            }
        }

        private static /* synthetic */ XGettingCollection lambda$0(Reference reference) throws PersistenceExceptionTransfer {
            return X.Constant((Object)((Binary)reference.get()));
        }

        private static /* synthetic */ void lambda$1(Reference reference, Binary data) throws PersistenceExceptionTransfer {
            reference.set((Object)data);
        }

        static interface CopySource
        extends PersistenceSource<Binary> {
            default public XGettingCollection<? extends Binary> readByObjectIds(PersistenceIdSet[] oids) throws PersistenceExceptionTransfer {
                return null;
            }
        }

        static interface CopyTarget
        extends PersistenceTarget<Binary> {
            default public boolean isWritable() {
                return true;
            }
        }
    }
}

