/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.binary.internal;

import one.microstream.X;
import one.microstream.afs.types.AFS;
import one.microstream.afs.types.AFile;
import one.microstream.afs.types.AFileSystem;
import one.microstream.collections.ArrayView;
import one.microstream.persistence.binary.types.Binary;
import one.microstream.persistence.exceptions.PersistenceException;
import one.microstream.persistence.exceptions.PersistenceExceptionTransfer;
import one.microstream.persistence.types.PersistenceTarget;

public class BinaryFileTarget
implements PersistenceTarget<Binary> {
    private final AFile file;
    private final AFileSystem fs;

    public BinaryFileTarget(AFile file) {
        this.file = (AFile)X.notNull((Object)file);
        this.fs = file.fileSystem();
    }

    public void write(Binary chunk) throws PersistenceExceptionTransfer {
        try {
            this.validateIsWritable();
            ArrayView buffers = X.ArrayView((Object[])chunk.buffers());
            AFS.executeWriting((AFile)this.file, wf -> {
                long l = wf.writeBytes((Iterable)buffers);
            });
        }
        catch (Exception e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public final void validateIsWritable() {
        this.fs.validateIsWritable();
    }

    public final boolean isWritable() {
        return this.fs.isWritable();
    }
}

