/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.binary.internal;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import one.microstream.X;
import one.microstream.chars.XChars;
import one.microstream.collections.BulkList;
import one.microstream.collections.EqConstHashTable;
import one.microstream.collections.EqHashTable;
import one.microstream.collections.HashTable;
import one.microstream.collections.types.XAddingCollection;
import one.microstream.collections.types.XGettingSequence;
import one.microstream.collections.types.XGettingTable;
import one.microstream.collections.types.XImmutableEnum;
import one.microstream.collections.types.XTable;
import one.microstream.persistence.binary.internal.AbstractBinaryHandlerCustom;
import one.microstream.persistence.binary.types.Binary;
import one.microstream.persistence.binary.types.BinaryField;
import one.microstream.persistence.exceptions.PersistenceException;
import one.microstream.persistence.types.PersistenceFunction;
import one.microstream.persistence.types.PersistenceLoadHandler;
import one.microstream.persistence.types.PersistenceReferenceLoader;
import one.microstream.persistence.types.PersistenceStoreHandler;
import one.microstream.persistence.types.PersistenceTypeDefinitionMember;
import one.microstream.persistence.types.PersistenceTypeInstantiator;
import one.microstream.reflect.Getter;
import one.microstream.reflect.Getter_boolean;
import one.microstream.reflect.Getter_byte;
import one.microstream.reflect.Getter_char;
import one.microstream.reflect.Getter_double;
import one.microstream.reflect.Getter_float;
import one.microstream.reflect.Getter_int;
import one.microstream.reflect.Getter_long;
import one.microstream.reflect.Getter_short;
import one.microstream.reflect.Setter;
import one.microstream.reflect.Setter_boolean;
import one.microstream.reflect.Setter_byte;
import one.microstream.reflect.Setter_char;
import one.microstream.reflect.Setter_double;
import one.microstream.reflect.Setter_float;
import one.microstream.reflect.Setter_int;
import one.microstream.reflect.Setter_long;
import one.microstream.reflect.Setter_short;
import one.microstream.reflect.XReflect;
import one.microstream.typing.KeyValue;

public class CustomBinaryHandler<T>
extends AbstractBinaryHandlerCustom<T> {
    private final PersistenceTypeInstantiator<Binary, T> instantiator;
    private EqConstHashTable<String, ? extends BinaryField<? super T>> binaryFields;
    private boolean hasSettingMembers;
    private boolean hasNonSettingMembers;
    private boolean hasPersistedReferences;
    private BinaryField<? super T>[] storingFields;
    private BinaryField<? super T>[] nonSettingFields;
    private BinaryField<? super T>[] allReferenceFields;
    private BinaryField<? super T>[] settingRefrncFields;
    private BinaryField<? super T>[] settingNonRefFields;
    private BinaryField<? super T> trailingVariableLengthField;
    private int fixedLengthBinaryContent;

    protected static final <T> BinaryField<T> Field_byte(Getter_byte<T> getter) {
        return CustomBinaryHandler.Field_byte(getter, null);
    }

    protected static final <T> BinaryField<T> Field_byte(Getter_byte<T> getter, Setter_byte<T> setter) {
        return Binary.Field_byte(BinaryField.Defaults.defaultUninitializedName(), getter, setter);
    }

    protected static final <T> BinaryField<T> Field_boolean(Getter_boolean<T> getter) {
        return CustomBinaryHandler.Field_boolean(getter, null);
    }

    protected static final <T> BinaryField<T> Field_boolean(Getter_boolean<T> getter, Setter_boolean<T> setter) {
        return Binary.Field_boolean(BinaryField.Defaults.defaultUninitializedName(), getter, setter);
    }

    protected static final <T> BinaryField<T> Field_short(Getter_short<T> getter) {
        return CustomBinaryHandler.Field_short(getter, null);
    }

    protected static final <T> BinaryField<T> Field_short(Getter_short<T> getter, Setter_short<T> setter) {
        return Binary.Field_short(BinaryField.Defaults.defaultUninitializedName(), getter, setter);
    }

    protected static final <T> BinaryField<T> Field_char(Getter_char<T> getter) {
        return CustomBinaryHandler.Field_char(getter, null);
    }

    protected static final <T> BinaryField<T> Field_char(Getter_char<T> getter, Setter_char<T> setter) {
        return Binary.Field_char(BinaryField.Defaults.defaultUninitializedName(), getter, setter);
    }

    protected static final <T> BinaryField<T> Field_int(Getter_int<T> getter) {
        return CustomBinaryHandler.Field_int(getter, null);
    }

    protected static final <T> BinaryField<T> Field_int(Getter_int<T> getter, Setter_int<T> setter) {
        return Binary.Field_int(BinaryField.Defaults.defaultUninitializedName(), getter, setter);
    }

    protected static final <T> BinaryField<T> Field_float(Getter_float<T> getter) {
        return CustomBinaryHandler.Field_float(getter, null);
    }

    protected static final <T> BinaryField<T> Field_float(Getter_float<T> getter, Setter_float<T> setter) {
        return Binary.Field_float(BinaryField.Defaults.defaultUninitializedName(), getter, setter);
    }

    protected static final <T> BinaryField<T> Field_long(Getter_long<T> getter) {
        return CustomBinaryHandler.Field_long(getter, null);
    }

    protected static final <T> BinaryField<T> Field_long(Getter_long<T> getter, Setter_long<T> setter) {
        return Binary.Field_long(BinaryField.Defaults.defaultUninitializedName(), getter, setter);
    }

    protected static final <T> BinaryField<T> Field_double(Getter_double<T> getter) {
        return CustomBinaryHandler.Field_double(getter, null);
    }

    protected static final <T> BinaryField<T> Field_double(Getter_double<T> getter, Setter_double<T> setter) {
        return Binary.Field_double(BinaryField.Defaults.defaultUninitializedName(), getter, setter);
    }

    protected static final <T, R> BinaryField<T> Field(Class<R> referenceType, Getter<T, R> getter) {
        return CustomBinaryHandler.Field(referenceType, getter, null);
    }

    protected static final <T, R> BinaryField<T> Field(Class<R> referenceType, Getter<T, R> getter, Setter<T, R> setter) {
        return Binary.Field(referenceType, BinaryField.Defaults.defaultUninitializedName(), getter, setter);
    }

    protected EqConstHashTable<String, ? extends BinaryField<? super T>> initializeDefinedFields(XGettingSequence<? extends BinaryField<? super T>> binaryFields) {
        if (binaryFields == null) {
            return null;
        }
        EqHashTable mappedBinaryFields = EqHashTable.New();
        for (BinaryField binaryField : binaryFields) {
            if (!(binaryField instanceof BinaryField.Initializable)) {
                throw new PersistenceException(String.valueOf(BinaryField.class.getSimpleName()) + "\"" + binaryField.name() + "\" is not " + BinaryField.Initializable.class.getSimpleName() + ".");
            }
            String identifier = binaryField.identifier();
            if (identifier == null) {
                throw new PersistenceException("Unnamed " + BinaryField.class.getSimpleName() + " of type " + binaryField.type());
            }
            if (mappedBinaryFields.add((Object)identifier, (Object)((BinaryField.Initializable)binaryField))) continue;
            throw new PersistenceException("Duplicate " + BinaryField.class.getSimpleName() + " \"" + binaryField.type() + "\"");
        }
        this.initializeBinaryFields(mappedBinaryFields);
        return mappedBinaryFields.immure();
    }

    public static <T> CustomBinaryHandler<T> New(Class<T> type, PersistenceTypeInstantiator<Binary, T> instantiator, XGettingSequence<? extends BinaryField<? super T>> binaryFields) {
        return new CustomBinaryHandler<T>((Class)X.notNull(type), (PersistenceTypeInstantiator)X.notNull(instantiator), (XGettingSequence)X.notNull(binaryFields));
    }

    protected CustomBinaryHandler(Class<T> type) {
        this(type, (XGettingSequence<BinaryField<T>>)null);
    }

    protected CustomBinaryHandler(Class<T> type, XGettingSequence<? extends BinaryField<? super T>> binaryFields) {
        this(type, CustomBinaryHandler.deriveTypeName(type), null, binaryFields);
    }

    protected CustomBinaryHandler(Class<T> type, String typeName, XGettingSequence<? extends BinaryField<? super T>> binaryFields) {
        this(type, typeName, null, binaryFields);
    }

    protected CustomBinaryHandler(Class<T> type, PersistenceTypeInstantiator<Binary, T> instantiator) {
        this(type, instantiator, null);
    }

    protected CustomBinaryHandler(Class<T> type, PersistenceTypeInstantiator<Binary, T> instantiator, XGettingSequence<? extends BinaryField<? super T>> binaryFields) {
        this(type, CustomBinaryHandler.deriveTypeName(type), instantiator, binaryFields);
    }

    protected CustomBinaryHandler(Class<T> type, String typeName, PersistenceTypeInstantiator<Binary, T> instantiator, XGettingSequence<? extends BinaryField<? super T>> binaryFields) {
        super(type, typeName, binaryFields);
        this.instantiator = (PersistenceTypeInstantiator)X.mayNull(instantiator);
        this.binaryFields = this.initializeDefinedFields(binaryFields);
    }

    public final boolean hasPersistedReferences() {
        this.ensureInitializeInstanceMembers();
        return this.hasPersistedReferences;
    }

    public final boolean hasVaryingPersistedLengthInstances() {
        this.ensureInitializeInstanceMembers();
        return this.trailingVariableLengthField != null;
    }

    @Override
    protected XImmutableEnum<? extends PersistenceTypeDefinitionMember> initializeInstanceMembers() {
        XGettingSequence<BinaryField<T>> binaryFields = this.reflectiveInitializeBinaryFields();
        return CustomBinaryHandler.validateAndImmure(binaryFields);
    }

    private long calculcateContentLength(T instance) {
        if (this.trailingVariableLengthField != null) {
            return (long)this.fixedLengthBinaryContent + this.trailingVariableLengthField.calculateBinaryLength(instance);
        }
        return this.fixedLengthBinaryContent;
    }

    @Override
    public void store(Binary data, T instance, long objectId, PersistenceStoreHandler<Binary> handler) {
        long contentLength = this.calculcateContentLength(instance);
        data.storeEntityHeader(contentLength, this.typeId(), objectId);
        BinaryField<? super T>[] binaryFieldArray = this.storingFields;
        int n = this.storingFields.length;
        int n2 = 0;
        while (n2 < n) {
            BinaryField<T> storingField = binaryFieldArray[n2];
            storingField.storeFromInstance(instance, data, handler);
            ++n2;
        }
    }

    protected T instantiate(Binary data) {
        return (T)this.instantiator.instantiate((Object)data);
    }

    @Override
    public T create(Binary data, PersistenceLoadHandler handler) {
        T instance = this.instantiate(data);
        this.setNonReferenceValues(instance, data, handler);
        return instance;
    }

    public void initializeState(Binary data, T instance, PersistenceLoadHandler handler) {
        this.setReferenceValues(instance, data, handler);
    }

    public void updateState(Binary data, T instance, PersistenceLoadHandler handler) {
        if (this.hasNonSettingMembers) {
            this.validateReadOnlyFields(instance, data, handler);
        }
        if (this.hasSettingMembers) {
            this.setNonReferenceValues(instance, data, handler);
            this.setReferenceValues(instance, data, handler);
        }
    }

    protected void validateReadOnlyFields(T instance, Binary data, PersistenceLoadHandler handler) {
        BinaryField<? super T>[] binaryFieldArray = this.nonSettingFields;
        int n = this.nonSettingFields.length;
        int n2 = 0;
        while (n2 < n) {
            BinaryField<T> nonSettingFieldField = binaryFieldArray[n2];
            nonSettingFieldField.validateState(instance, data, handler);
            ++n2;
        }
    }

    private void setNonReferenceValues(T instance, Binary data, PersistenceLoadHandler handler) {
        BinaryField<? super T>[] binaryFieldArray = this.settingNonRefFields;
        int n = this.settingNonRefFields.length;
        int n2 = 0;
        while (n2 < n) {
            BinaryField<T> settingNonRefField = binaryFieldArray[n2];
            settingNonRefField.setToInstance(instance, data, handler);
            ++n2;
        }
    }

    private void setReferenceValues(T instance, Binary data, PersistenceLoadHandler handler) {
        BinaryField<? super T>[] binaryFieldArray = this.settingRefrncFields;
        int n = this.settingRefrncFields.length;
        int n2 = 0;
        while (n2 < n) {
            BinaryField<T> settingRefrncField = binaryFieldArray[n2];
            settingRefrncField.setToInstance(instance, data, handler);
            ++n2;
        }
    }

    @Override
    public void complete(Binary data, T instance, PersistenceLoadHandler handler) {
    }

    @Override
    public <C extends Consumer<? super Class<?>>> C iterateMemberTypes(C logic) {
        BinaryField<? super T>[] binaryFieldArray = this.storingFields;
        int n = this.storingFields.length;
        int n2 = 0;
        while (n2 < n) {
            BinaryField<T> storingField = binaryFieldArray[n2];
            logic.accept(storingField.type());
            ++n2;
        }
        return logic;
    }

    protected final synchronized XGettingSequence<? extends BinaryField<? super T>> reflectiveInitializeBinaryFields() {
        HashTable binaryFieldsPerClass = HashTable.New();
        this.collectBinaryFields(binaryFieldsPerClass);
        EqHashTable binaryFieldsInOrder = EqHashTable.New();
        this.defineBinaryFieldOrder((XGettingTable<Class<?>, XGettingSequence<BinaryField.Initializable<T>>>)binaryFieldsPerClass, (identifier, field) -> {
            if (!binaryFieldsInOrder.add(identifier, field)) {
                throw new PersistenceException(String.valueOf(BinaryField.class.getSimpleName()) + " with the unique identifier \"" + identifier + "\" is already registered.");
            }
        });
        this.initializeBinaryFields(binaryFieldsInOrder);
        this.binaryFields = binaryFieldsInOrder.immure();
        return this.binaryFields.values();
    }

    private void collectBinaryFields(HashTable<Class<?>, XGettingSequence<BinaryField.Initializable<T>>> binaryFieldsPerClass) {
        Class<?> c = this.getClass();
        while (c != CustomBinaryHandler.class) {
            BulkList binaryFieldsOfClass = BulkList.New();
            this.collectDeclaredBinaryFields(c, (XAddingCollection<BinaryField.Initializable<T>>)binaryFieldsOfClass);
            binaryFieldsPerClass.add(c, (Object)binaryFieldsOfClass);
            c = c.getSuperclass();
        }
        binaryFieldsPerClass.reverse();
    }

    protected void validateBinaryFieldGenericType(Field binaryFieldField) {
        Type genericType = binaryFieldField.getGenericType();
        if (!(genericType instanceof ParameterizedType)) {
            return;
        }
        ParameterizedType parameterizedType = (ParameterizedType)genericType;
        Type typeParameter = parameterizedType.getActualTypeArguments()[0];
        if (!(typeParameter instanceof Class)) {
            return;
        }
        Class typeParameterClass = (Class)typeParameter;
        if (XReflect.isActualClass((Class)typeParameterClass) && typeParameterClass.isAssignableFrom(this.type())) {
            return;
        }
        throw new PersistenceException(String.valueOf(BinaryField.class.getSimpleName()) + " type parameter \"" + typeParameterClass + "\"" + " of field \"" + binaryFieldField + "\"" + " is not compatible with this type handler's handled type \"" + this.type() + "\"");
    }

    protected void collectDeclaredBinaryFields(Class<?> clazz, XAddingCollection<BinaryField.Initializable<T>> target) {
        Field[] fieldArray = clazz.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (BinaryField.class.isAssignableFrom(field.getType())) {
                try {
                    field.setAccessible(true);
                    BinaryField binaryField = (BinaryField)field.get(this);
                    if (binaryField instanceof BinaryField.Initializable) {
                        this.validateBinaryFieldGenericType(field);
                        BinaryField.Initializable initializable = (BinaryField.Initializable)binaryField;
                        initializable.initializeIdentifierOptional(clazz.getName(), field.getName());
                        target.add((Object)initializable);
                    }
                }
                catch (Exception e) {
                    throw new PersistenceException((Throwable)e);
                }
            }
            ++n2;
        }
    }

    protected void defineBinaryFieldOrder(XGettingTable<Class<?>, XGettingSequence<BinaryField.Initializable<T>>> binaryFieldsPerClass, BiConsumer<String, BinaryField.Initializable<T>> collector) {
        for (XGettingSequence binaryFieldsOfClass : binaryFieldsPerClass.values()) {
            for (BinaryField.Initializable binaryField : binaryFieldsOfClass) {
                collector.accept(binaryField.identifier(), binaryField);
            }
        }
    }

    private void initializeBinaryFields(EqHashTable<String, BinaryField.Initializable<? super T>> binaryFields) {
        BinaryField.Initializable<? super T> varLengthField = CustomBinaryHandler.checkVariableLengthLayout(binaryFields);
        BulkList storingFields = BulkList.New();
        BulkList allReferenceFields = BulkList.New();
        BulkList settingNonRefFields = BulkList.New();
        BulkList settingRefrncFields = BulkList.New();
        BulkList nonSettingFields = BulkList.New();
        int offset = 0;
        for (BinaryField.Initializable binaryField : binaryFields.values()) {
            binaryField.initializeOffset(offset);
            storingFields.add((Object)binaryField);
            if (binaryField.hasReferences()) {
                allReferenceFields.add((Object)binaryField);
            }
            if (binaryField != varLengthField) {
                offset = (int)((long)offset + binaryField.persistentMinimumLength());
            }
            if (!binaryField.canSet()) {
                nonSettingFields.add((Object)binaryField);
                continue;
            }
            if (binaryField.hasReferences()) {
                settingRefrncFields.add((Object)binaryField);
                continue;
            }
            settingNonRefFields.add((Object)binaryField);
        }
        this.storingFields = (BinaryField[])storingFields.toArray(this.binaryFieldClass());
        this.nonSettingFields = (BinaryField[])nonSettingFields.toArray(this.binaryFieldClass());
        this.allReferenceFields = (BinaryField[])allReferenceFields.toArray(this.binaryFieldClass());
        this.settingRefrncFields = (BinaryField[])settingRefrncFields.toArray(this.binaryFieldClass());
        this.settingNonRefFields = (BinaryField[])settingNonRefFields.toArray(this.binaryFieldClass());
        this.trailingVariableLengthField = varLengthField;
        this.hasPersistedReferences = !allReferenceFields.isEmpty();
        this.hasSettingMembers = !settingRefrncFields.isEmpty() || !settingNonRefFields.isEmpty();
        this.hasNonSettingMembers = !nonSettingFields.isEmpty();
        this.fixedLengthBinaryContent = offset;
    }

    private Class<BinaryField<? super T>> binaryFieldClass() {
        return BinaryField.class;
    }

    private static <F extends BinaryField<?>> F checkVariableLengthLayout(XTable<String, F> binaryFields) {
        if (binaryFields.isEmpty()) {
            return null;
        }
        KeyValue varLengthEntry = null;
        for (KeyValue e : binaryFields) {
            if (!((BinaryField)e.value()).isVariableLength()) continue;
            if (varLengthEntry == null) {
                varLengthEntry = e;
                continue;
            }
            throw new PersistenceException("Multiple variable length fields detected: " + XChars.systemString((Object)varLengthEntry.value()) + ": " + ((BinaryField)varLengthEntry.value()).identifier() + ", " + XChars.systemString((Object)e.value()) + ": " + ((BinaryField)e.value()).identifier());
        }
        if (varLengthEntry == null) {
            return null;
        }
        binaryFields.put(varLengthEntry);
        return (F)((BinaryField)varLengthEntry.value());
    }

    @Override
    public final void iterateInstanceReferences(T instance, PersistenceFunction iterator) {
        BinaryField<? super T>[] binaryFieldArray = this.allReferenceFields;
        int n = this.allReferenceFields.length;
        int n2 = 0;
        while (n2 < n) {
            BinaryField<T> referenceField = binaryFieldArray[n2];
            referenceField.iterateReferences(instance, iterator);
            ++n2;
        }
    }

    public void iterateLoadableReferences(Binary data, PersistenceReferenceLoader loader) {
        BinaryField<? super T>[] binaryFieldArray = this.allReferenceFields;
        int n = this.allReferenceFields.length;
        int n2 = 0;
        while (n2 < n) {
            BinaryField<T> referenceField = binaryFieldArray[n2];
            referenceField.iterateLoadableReferences(data, loader);
            ++n2;
        }
    }
}

