/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.binary.java.lang;

import one.microstream.collections.types.XGettingSequence;
import one.microstream.persistence.binary.internal.AbstractBinaryHandlerCustomValueFixedLength;
import one.microstream.persistence.binary.types.Binary;
import one.microstream.persistence.types.PersistenceLoadHandler;
import one.microstream.persistence.types.PersistenceStoreHandler;
import one.microstream.persistence.types.PersistenceTypeDefinitionMember;

public final class BinaryHandlerFloat
extends AbstractBinaryHandlerCustomValueFixedLength<Float, Float> {
    public static BinaryHandlerFloat New() {
        return new BinaryHandlerFloat();
    }

    BinaryHandlerFloat() {
        super(Float.class, (XGettingSequence<? extends PersistenceTypeDefinitionMember>)BinaryHandlerFloat.defineValueType(Float.TYPE));
    }

    private static float instanceState(Float instance) {
        return instance.floatValue();
    }

    private static float binaryState(Binary data) {
        return data.read_float(0L);
    }

    @Override
    public void store(Binary data, Float instance, long objectId, PersistenceStoreHandler<Binary> handler) {
        data.storeFloat(this.typeId(), objectId, instance.floatValue());
    }

    @Override
    public Float create(Binary data, PersistenceLoadHandler handler) {
        return data.buildFloat();
    }

    @Override
    public Float getValidationStateFromInstance(Float instance) {
        return instance;
    }

    @Override
    public Float getValidationStateFromBinary(Binary data) {
        return Float.valueOf(BinaryHandlerFloat.binaryState(data));
    }

    @Override
    public void validateState(Binary data, Float instance, PersistenceLoadHandler handler) {
        float binaryState;
        float instanceState = BinaryHandlerFloat.instanceState(instance);
        if (instanceState == (binaryState = BinaryHandlerFloat.binaryState(data))) {
            return;
        }
        this.throwInconsistentStateException(instance, Float.valueOf(instanceState), Float.valueOf(binaryState));
    }
}

