/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.binary.types;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Comparator;
import java.util.Optional;
import one.microstream.afs.types.AFile;
import one.microstream.collections.ConstList;
import one.microstream.collections.types.XGettingCollection;
import one.microstream.collections.types.XGettingSequence;
import one.microstream.functional.IndexedAcceptor;
import one.microstream.functional.InstanceDispatcherLogic;
import one.microstream.memory.XMemory;
import one.microstream.persistence.binary.exceptions.BinaryPersistenceException;
import one.microstream.persistence.binary.internal.AbstractBinaryHandlerCustom;
import one.microstream.persistence.binary.internal.BinaryHandlerPrimitive;
import one.microstream.persistence.binary.internal.BinaryHandlerSingletonStatelessEnum;
import one.microstream.persistence.binary.internal.BinaryHandlerStatelessConstant;
import one.microstream.persistence.binary.java.io.BinaryHandlerFile;
import one.microstream.persistence.binary.java.lang.BinaryHandlerBoolean;
import one.microstream.persistence.binary.java.lang.BinaryHandlerByte;
import one.microstream.persistence.binary.java.lang.BinaryHandlerCharacter;
import one.microstream.persistence.binary.java.lang.BinaryHandlerClass;
import one.microstream.persistence.binary.java.lang.BinaryHandlerDouble;
import one.microstream.persistence.binary.java.lang.BinaryHandlerFloat;
import one.microstream.persistence.binary.java.lang.BinaryHandlerInteger;
import one.microstream.persistence.binary.java.lang.BinaryHandlerLong;
import one.microstream.persistence.binary.java.lang.BinaryHandlerNativeArray_boolean;
import one.microstream.persistence.binary.java.lang.BinaryHandlerNativeArray_byte;
import one.microstream.persistence.binary.java.lang.BinaryHandlerNativeArray_char;
import one.microstream.persistence.binary.java.lang.BinaryHandlerNativeArray_double;
import one.microstream.persistence.binary.java.lang.BinaryHandlerNativeArray_float;
import one.microstream.persistence.binary.java.lang.BinaryHandlerNativeArray_int;
import one.microstream.persistence.binary.java.lang.BinaryHandlerNativeArray_long;
import one.microstream.persistence.binary.java.lang.BinaryHandlerNativeArray_short;
import one.microstream.persistence.binary.java.lang.BinaryHandlerObject;
import one.microstream.persistence.binary.java.lang.BinaryHandlerShort;
import one.microstream.persistence.binary.java.lang.BinaryHandlerString;
import one.microstream.persistence.binary.java.lang.BinaryHandlerStringBuffer;
import one.microstream.persistence.binary.java.lang.BinaryHandlerStringBuilder;
import one.microstream.persistence.binary.java.lang.BinaryHandlerVoid;
import one.microstream.persistence.binary.java.math.BinaryHandlerBigDecimal;
import one.microstream.persistence.binary.java.math.BinaryHandlerBigInteger;
import one.microstream.persistence.binary.java.net.BinaryHandlerInet4Address;
import one.microstream.persistence.binary.java.net.BinaryHandlerInet6Address;
import one.microstream.persistence.binary.java.net.BinaryHandlerInetAddress;
import one.microstream.persistence.binary.java.net.BinaryHandlerInetSocketAddress;
import one.microstream.persistence.binary.java.net.BinaryHandlerURI;
import one.microstream.persistence.binary.java.net.BinaryHandlerURL;
import one.microstream.persistence.binary.java.nio.file.BinaryHandlerPath;
import one.microstream.persistence.binary.java.sql.BinaryHandlerSqlDate;
import one.microstream.persistence.binary.java.sql.BinaryHandlerSqlTime;
import one.microstream.persistence.binary.java.sql.BinaryHandlerSqlTimestamp;
import one.microstream.persistence.binary.java.time.BinaryHandlerZoneOffset;
import one.microstream.persistence.binary.java.util.BinaryHandlerArrayDeque;
import one.microstream.persistence.binary.java.util.BinaryHandlerArrayList;
import one.microstream.persistence.binary.java.util.BinaryHandlerCopyOnWriteArrayList;
import one.microstream.persistence.binary.java.util.BinaryHandlerCopyOnWriteArraySet;
import one.microstream.persistence.binary.java.util.BinaryHandlerCurrency;
import one.microstream.persistence.binary.java.util.BinaryHandlerDate;
import one.microstream.persistence.binary.java.util.BinaryHandlerHashMap;
import one.microstream.persistence.binary.java.util.BinaryHandlerHashSet;
import one.microstream.persistence.binary.java.util.BinaryHandlerHashtable;
import one.microstream.persistence.binary.java.util.BinaryHandlerIdentityHashMap;
import one.microstream.persistence.binary.java.util.BinaryHandlerLinkedHashMap;
import one.microstream.persistence.binary.java.util.BinaryHandlerLinkedHashSet;
import one.microstream.persistence.binary.java.util.BinaryHandlerLinkedList;
import one.microstream.persistence.binary.java.util.BinaryHandlerLocale;
import one.microstream.persistence.binary.java.util.BinaryHandlerOptionalDouble;
import one.microstream.persistence.binary.java.util.BinaryHandlerOptionalInt;
import one.microstream.persistence.binary.java.util.BinaryHandlerOptionalLong;
import one.microstream.persistence.binary.java.util.BinaryHandlerPriorityQueue;
import one.microstream.persistence.binary.java.util.BinaryHandlerProperties;
import one.microstream.persistence.binary.java.util.BinaryHandlerStack;
import one.microstream.persistence.binary.java.util.BinaryHandlerTreeMap;
import one.microstream.persistence.binary.java.util.BinaryHandlerTreeSet;
import one.microstream.persistence.binary.java.util.BinaryHandlerVector;
import one.microstream.persistence.binary.java.util.BinaryHandlerWeakHashMap;
import one.microstream.persistence.binary.java.util.concurrent.BinaryHandlerConcurrentHashMap;
import one.microstream.persistence.binary.java.util.concurrent.BinaryHandlerConcurrentLinkedDeque;
import one.microstream.persistence.binary.java.util.concurrent.BinaryHandlerConcurrentLinkedQueue;
import one.microstream.persistence.binary.java.util.concurrent.BinaryHandlerConcurrentSkipListMap;
import one.microstream.persistence.binary.java.util.concurrent.BinaryHandlerConcurrentSkipListSet;
import one.microstream.persistence.binary.java.util.regex.BinaryHandlerPattern;
import one.microstream.persistence.binary.one.microstream.collections.BinaryHandlerBulkList;
import one.microstream.persistence.binary.one.microstream.collections.BinaryHandlerConstHashEnum;
import one.microstream.persistence.binary.one.microstream.collections.BinaryHandlerConstHashTable;
import one.microstream.persistence.binary.one.microstream.collections.BinaryHandlerConstList;
import one.microstream.persistence.binary.one.microstream.collections.BinaryHandlerEqBulkList;
import one.microstream.persistence.binary.one.microstream.collections.BinaryHandlerEqConstHashEnum;
import one.microstream.persistence.binary.one.microstream.collections.BinaryHandlerEqConstHashTable;
import one.microstream.persistence.binary.one.microstream.collections.BinaryHandlerEqHashEnum;
import one.microstream.persistence.binary.one.microstream.collections.BinaryHandlerEqHashTable;
import one.microstream.persistence.binary.one.microstream.collections.BinaryHandlerFixedList;
import one.microstream.persistence.binary.one.microstream.collections.BinaryHandlerHashEnum;
import one.microstream.persistence.binary.one.microstream.collections.BinaryHandlerHashTable;
import one.microstream.persistence.binary.one.microstream.collections.BinaryHandlerLimitList;
import one.microstream.persistence.binary.one.microstream.collections.BinaryHandlerSingleton;
import one.microstream.persistence.binary.one.microstream.reference.BinaryHandlerLazyDefault;
import one.microstream.persistence.binary.one.microstream.util.BinaryHandlerSubstituterDefault;
import one.microstream.persistence.binary.types.Binary;
import one.microstream.persistence.binary.types.BinaryFieldLengthResolver;
import one.microstream.persistence.binary.types.BinaryPersistenceFoundation;
import one.microstream.persistence.binary.types.BinaryTypeHandler;
import one.microstream.persistence.internal.PersistenceTypeDictionaryFileHandler;
import one.microstream.persistence.types.Persistence;
import one.microstream.persistence.types.PersistenceCustomTypeHandlerRegistry;
import one.microstream.persistence.types.PersistenceFunction;
import one.microstream.persistence.types.PersistenceSizedArrayLengthController;
import one.microstream.persistence.types.PersistenceTypeDictionary;
import one.microstream.persistence.types.PersistenceTypeDictionaryLoader;
import one.microstream.persistence.types.PersistenceTypeHandler;
import one.microstream.persistence.types.PersistenceTypeHandlerCreator;
import one.microstream.persistence.types.PersistenceTypeHandlerManager;
import one.microstream.persistence.types.PersistenceTypeIdLookup;
import one.microstream.reference.Referencing;
import one.microstream.reference.Swizzling;
import one.microstream.typing.XTypes;

public final class BinaryPersistence
extends Persistence {
    public static BinaryPersistenceFoundation<?> Foundation() {
        return BinaryPersistence.Foundation(null);
    }

    public static BinaryPersistenceFoundation<?> Foundation(InstanceDispatcherLogic dispatcher) {
        BinaryPersistenceFoundation foundation = (BinaryPersistenceFoundation)BinaryPersistenceFoundation.New().setInstanceDispatcher(dispatcher);
        return foundation;
    }

    public static final PersistenceCustomTypeHandlerRegistry<Binary> createDefaultCustomTypeHandlerRegistry(Referencing<PersistenceTypeHandlerManager<Binary>> typeHandlerManager, PersistenceSizedArrayLengthController controller, PersistenceTypeHandlerCreator<Binary> typeHandlerCreator, XGettingCollection<? extends PersistenceTypeHandler<Binary, ?>> customHandlers) {
        XGettingSequence<? extends PersistenceTypeHandler<Binary, ?>> nativeHandlersValueTypes = BinaryPersistence.createNativeHandlersValueTypes(typeHandlerManager, controller, typeHandlerCreator);
        XGettingSequence<? extends PersistenceTypeHandler<Binary, ?>> nativeHandlersReferencingTypes = BinaryPersistence.createNativeHandlersReferencingTypes(typeHandlerManager, controller, typeHandlerCreator);
        PersistenceCustomTypeHandlerRegistry.Default defaultCustomTypeHandlerRegistry = PersistenceCustomTypeHandlerRegistry.New().registerTypeHandlers(nativeHandlersValueTypes).registerTypeHandlers(nativeHandlersReferencingTypes).registerTypeHandlers(BinaryPersistence.defaultCustomHandlers(controller)).registerTypeHandlers(customHandlers);
        return defaultCustomTypeHandlerRegistry;
    }

    static final void initializeNativeTypeId(PersistenceTypeHandler<Binary, ?> typeHandler, PersistenceTypeIdLookup nativeTypeIdLookup) {
        long nativeTypeId = nativeTypeIdLookup.lookupTypeId(typeHandler.type());
        if (Swizzling.isNotFoundId((long)nativeTypeId)) {
            throw new BinaryPersistenceException("No native TypeId found for type " + typeHandler.type());
        }
        typeHandler.initialize(nativeTypeId);
    }

    public static final XGettingSequence<? extends PersistenceTypeHandler<Binary, ?>> createNativeHandlersValueTypes(Referencing<PersistenceTypeHandlerManager<Binary>> typeHandlerManager, PersistenceSizedArrayLengthController controller, PersistenceTypeHandlerCreator<Binary> typeHandlerCreator) {
        ConstList nativeHandlersValueTypes = ConstList.New((Object[])new BinaryTypeHandler.Abstract[]{BinaryHandlerPrimitive.New(Byte.TYPE), BinaryHandlerPrimitive.New(Boolean.TYPE), BinaryHandlerPrimitive.New(Short.TYPE), BinaryHandlerPrimitive.New(Character.TYPE), BinaryHandlerPrimitive.New(Integer.TYPE), BinaryHandlerPrimitive.New(Float.TYPE), BinaryHandlerPrimitive.New(Long.TYPE), BinaryHandlerPrimitive.New(Double.TYPE), BinaryHandlerClass.New(typeHandlerManager), BinaryHandlerByte.New(), BinaryHandlerBoolean.New(), BinaryHandlerShort.New(), BinaryHandlerCharacter.New(), BinaryHandlerInteger.New(), BinaryHandlerFloat.New(), BinaryHandlerLong.New(), BinaryHandlerDouble.New(), BinaryHandlerVoid.New(), BinaryHandlerObject.New(), BinaryHandlerString.New(), BinaryHandlerStringBuffer.New(), BinaryHandlerStringBuilder.New(), BinaryHandlerNativeArray_byte.New(), BinaryHandlerNativeArray_boolean.New(), BinaryHandlerNativeArray_short.New(), BinaryHandlerNativeArray_char.New(), BinaryHandlerNativeArray_int.New(), BinaryHandlerNativeArray_float.New(), BinaryHandlerNativeArray_long.New(), BinaryHandlerNativeArray_double.New(), BinaryHandlerBigInteger.New(), BinaryHandlerBigDecimal.New(), BinaryHandlerFile.New(), BinaryHandlerDate.New(), BinaryHandlerLocale.New(), BinaryHandlerCurrency.New(), BinaryHandlerPattern.New(), BinaryHandlerInetAddress.New(), BinaryHandlerInet4Address.New(), BinaryHandlerInet6Address.New(), BinaryHandlerPath.New(), BinaryHandlerInetSocketAddress.New(), BinaryHandlerURI.New(), BinaryHandlerURL.New(), BinaryHandlerZoneOffset.New(), BinaryHandlerSqlDate.New(), BinaryHandlerSqlTime.New(), BinaryHandlerSqlTimestamp.New(), BinaryHandlerOptionalInt.New(), BinaryHandlerOptionalLong.New(), BinaryHandlerOptionalDouble.New(), BinaryHandlerStatelessConstant.New(Collections.emptyNavigableSet()), BinaryHandlerStatelessConstant.New(Collections.emptyNavigableMap()), BinaryHandlerStatelessConstant.New(Collections.reverseOrder())});
        return nativeHandlersValueTypes;
    }

    public static final XGettingSequence<? extends PersistenceTypeHandler<Binary, ?>> createNativeHandlersReferencingTypes(Referencing<PersistenceTypeHandlerManager<Binary>> typeHandlerManager, PersistenceSizedArrayLengthController controller, PersistenceTypeHandlerCreator<Binary> typeHandlerCreator) {
        ConstList nativeHandlers = ConstList.New((Object[])new PersistenceTypeHandler[]{BinaryHandlerVector.New(), BinaryHandlerStack.New(), BinaryHandlerHashtable.New(), BinaryHandlerProperties.New(), BinaryHandlerArrayList.New(), BinaryHandlerHashSet.New(), BinaryHandlerHashMap.New(), BinaryHandlerWeakHashMap.New(), BinaryHandlerLinkedList.New(), BinaryHandlerTreeMap.New(), BinaryHandlerTreeSet.New(), BinaryHandlerIdentityHashMap.New(), BinaryHandlerLinkedHashMap.New(), BinaryHandlerLinkedHashSet.New(), BinaryHandlerPriorityQueue.New(), BinaryHandlerConcurrentHashMap.New(), BinaryHandlerConcurrentLinkedQueue.New(), BinaryHandlerCopyOnWriteArrayList.New(), BinaryHandlerCopyOnWriteArraySet.New(), BinaryHandlerSingletonStatelessEnum.New(Comparator.naturalOrder().getClass()), BinaryHandlerArrayDeque.New(), BinaryHandlerConcurrentSkipListMap.New(), BinaryHandlerConcurrentSkipListSet.New(), BinaryHandlerConcurrentLinkedDeque.New(), BinaryHandlerLazyDefault.New(), typeHandlerCreator.createTypeHandlerGeneric(Optional.class)});
        return nativeHandlers;
    }

    public static final XGettingSequence<? extends PersistenceTypeHandler<Binary, ?>> defaultCustomHandlers(PersistenceSizedArrayLengthController controller) {
        ConstList defaultHandlers = ConstList.New((Object[])new AbstractBinaryHandlerCustom[]{BinaryHandlerBulkList.New(controller), BinaryHandlerLimitList.New(controller), BinaryHandlerFixedList.New(), BinaryHandlerConstList.New(), BinaryHandlerEqBulkList.New(controller), BinaryHandlerHashEnum.New(), BinaryHandlerConstHashEnum.New(), BinaryHandlerEqHashEnum.New(), BinaryHandlerEqConstHashEnum.New(), BinaryHandlerHashTable.New(), BinaryHandlerConstHashTable.New(), BinaryHandlerEqHashTable.New(), BinaryHandlerEqConstHashTable.New(), BinaryHandlerSingleton.New(), BinaryHandlerSubstituterDefault.New()});
        return defaultHandlers;
    }

    public static final long resolveFieldBinaryLength(Class<?> fieldType) {
        return fieldType.isPrimitive() ? BinaryPersistence.resolvePrimitiveFieldBinaryLength(fieldType) : (long)Binary.objectIdByteLength();
    }

    public static final long resolvePrimitiveFieldBinaryLength(Class<?> primitiveType) {
        return XMemory.byteSizePrimitive(primitiveType);
    }

    public static final BinaryFieldLengthResolver createFieldLengthResolver() {
        return new BinaryFieldLengthResolver.Default();
    }

    public static PersistenceTypeDictionary provideTypeDictionaryFromFile(AFile dictionaryFile) {
        BinaryPersistenceFoundation f = (BinaryPersistenceFoundation)BinaryPersistenceFoundation.New().setTypeDictionaryLoader((PersistenceTypeDictionaryLoader)PersistenceTypeDictionaryFileHandler.New((AFile)dictionaryFile));
        return f.getTypeDictionaryProvider().provideTypeDictionary();
    }

    public static final int binaryValueSize(Class<?> type) {
        return type.isPrimitive() ? XMemory.byteSizePrimitive(type) : Binary.objectIdByteLength();
    }

    public static int[] calculateBinarySizes(XGettingSequence<Field> fields) {
        final int[] fieldOffsets = new int[XTypes.to_int((long)fields.size())];
        fields.iterateIndexed((IndexedAcceptor)new IndexedAcceptor<Field>(){

            public void accept(Field e, long index) {
                fieldOffsets[(int)index] = BinaryPersistence.binaryValueSize(e.getType());
            }
        });
        return fieldOffsets;
    }

    public static final void iterateInstanceReferences(PersistenceFunction iterator, Object instance, long[] referenceOffsets) {
        int i = 0;
        while (i < referenceOffsets.length) {
            if (referenceOffsets[i] != 0L) {
                iterator.apply(XMemory.getObject((Object)instance, (long)referenceOffsets[i]));
            }
            ++i;
        }
    }

    private BinaryPersistence() {
        throw new UnsupportedOperationException();
    }
}

