/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.binary.types;

import one.microstream.X;
import one.microstream.collections.XUtilsCollection;
import one.microstream.collections.types.XGettingMap;
import one.microstream.collections.types.XGettingSequence;
import one.microstream.persistence.binary.exceptions.BinaryPersistenceException;
import one.microstream.persistence.binary.types.Binary;
import one.microstream.persistence.binary.types.BinaryValueFunctions;
import one.microstream.persistence.binary.types.BinaryValueSetter;
import one.microstream.persistence.binary.types.BinaryValueTranslatorKeyBuilder;
import one.microstream.persistence.binary.types.BinaryValueTranslatorLookupProvider;
import one.microstream.persistence.binary.types.BinaryValueTranslators;
import one.microstream.persistence.types.PersistenceTypeDefinition;
import one.microstream.persistence.types.PersistenceTypeDefinitionMember;
import one.microstream.persistence.types.PersistenceTypeDescriptionMember;
import one.microstream.persistence.types.PersistenceTypeHandler;
import one.microstream.typing.TypeMappingLookup;

public interface BinaryValueTranslatorProvider {
    public BinaryValueSetter provideTargetValueTranslator(PersistenceTypeDefinition var1, PersistenceTypeDefinitionMember var2, PersistenceTypeHandler<Binary, ?> var3, PersistenceTypeDefinitionMember var4);

    public BinaryValueSetter provideBinaryValueTranslator(PersistenceTypeDefinition var1, PersistenceTypeDefinitionMember var2, PersistenceTypeHandler<Binary, ?> var3, PersistenceTypeDefinitionMember var4);

    public static BinaryValueTranslatorProvider New(XGettingMap<String, BinaryValueSetter> customTranslatorLookup, XGettingSequence<? extends BinaryValueTranslatorKeyBuilder> translatorKeyBuilders, BinaryValueTranslatorLookupProvider translatorLookupProvider, boolean switchByteOrder) {
        return new Default((XGettingMap<String, BinaryValueSetter>)((XGettingMap)X.mayNull(customTranslatorLookup)), BinaryValueTranslatorProvider.unwrapKeyBuilders(translatorKeyBuilders), (BinaryValueTranslatorLookupProvider)X.notNull((Object)translatorLookupProvider), switchByteOrder);
    }

    public static BinaryValueTranslatorKeyBuilder[] unwrapKeyBuilders(XGettingSequence<? extends BinaryValueTranslatorKeyBuilder> translatorKeyBuilders) {
        return translatorKeyBuilders == null || translatorKeyBuilders.isEmpty() ? null : (BinaryValueTranslatorKeyBuilder[])XUtilsCollection.toArray(translatorKeyBuilders, BinaryValueTranslatorKeyBuilder.class);
    }

    public static final class Default
    implements BinaryValueTranslatorProvider {
        private final XGettingMap<String, BinaryValueSetter> customTranslatorLookup;
        private final BinaryValueTranslatorKeyBuilder[] translatorKeyBuilders;
        private final BinaryValueTranslatorLookupProvider translatorLookupProvider;
        private final boolean switchByteOrder;
        private transient TypeMappingLookup<BinaryValueSetter> translatorLookup;

        Default(XGettingMap<String, BinaryValueSetter> customTranslatorLookup, BinaryValueTranslatorKeyBuilder[] translatorKeyBuilders, BinaryValueTranslatorLookupProvider translatorLookupProvider, boolean switchByteOrder) {
            this.customTranslatorLookup = customTranslatorLookup;
            this.translatorKeyBuilders = translatorKeyBuilders;
            this.translatorLookupProvider = translatorLookupProvider;
            this.switchByteOrder = switchByteOrder;
        }

        private TypeMappingLookup<BinaryValueSetter> translatorLookup() {
            if (this.translatorLookup == null) {
                this.translatorLookup = this.translatorLookupProvider.mapping(this.switchByteOrder);
            }
            return this.translatorLookup;
        }

        private BinaryValueSetter provideValueSkipper(PersistenceTypeDefinitionMember sourceMember) {
            if (sourceMember.isReference()) {
                return BinaryValueTranslators::skip_long;
            }
            return Default.resolvePrimitiveSkipper(sourceMember);
        }

        private static void validateIsPrimitiveType(PersistenceTypeDefinitionMember member) {
            Class memberType = member.type();
            if (memberType == null || !memberType.isPrimitive()) {
                throw new BinaryPersistenceException("Unhandled type \"" + Default.toTypedIdentifier((PersistenceTypeDescriptionMember)member) + ".");
            }
        }

        private static BinaryValueSetter resolvePrimitiveSkipper(PersistenceTypeDefinitionMember sourceMember) {
            Default.validateIsPrimitiveType(sourceMember);
            Class sourceType = sourceMember.type();
            return sourceType == Byte.TYPE ? BinaryValueTranslators::skip_byte : (sourceType == Boolean.TYPE ? BinaryValueTranslators::skip_boolean : (sourceType == Short.TYPE ? BinaryValueTranslators::skip_short : (sourceType == Character.TYPE ? BinaryValueTranslators::skip_char : (sourceType == Integer.TYPE ? BinaryValueTranslators::skip_int : (sourceType == Float.TYPE ? BinaryValueTranslators::skip_float : (sourceType == Long.TYPE ? BinaryValueTranslators::skip_long : (sourceType == Double.TYPE ? BinaryValueTranslators::skip_double : Default.throwUnhandledPrimitiveException((PersistenceTypeDescriptionMember)sourceMember))))))));
        }

        private static BinaryValueSetter throwUnhandledPrimitiveException(PersistenceTypeDescriptionMember sourceMember) {
            throw new BinaryPersistenceException("Unhandled primitive type \"" + Default.toTypedIdentifier(sourceMember) + ".");
        }

        private BinaryValueSetter provideValueTranslator(Class<?> sourceType, Class<?> targetType) {
            BinaryValueSetter translator = (BinaryValueSetter)this.translatorLookup().lookup(sourceType, targetType);
            if (translator != null) {
                return translator;
            }
            Default.validateIsReferenceType(sourceType);
            Default.validateIsReferenceType(targetType);
            Default.validateCompatibleTargetType(sourceType, targetType);
            return this.provideReferenceResolver();
        }

        private static void validateCompatibleTargetType(Class<?> sourceType, Class<?> targetType) {
            if (targetType.isAssignableFrom(sourceType)) {
                return;
            }
            throw new BinaryPersistenceException("Incompatible types: " + sourceType.getName() + " -> " + targetType.getName());
        }

        private BinaryValueSetter provideReferenceResolver(PersistenceTypeDescriptionMember sourceMember, PersistenceTypeDescriptionMember targetMember) {
            Default.validateIsReferenceType(sourceMember);
            Default.validateIsReferenceType(targetMember);
            return this.provideReferenceResolver();
        }

        private BinaryValueSetter provideReferenceResolver() {
            return BinaryValueFunctions.getObjectValueSetter(Object.class, this.switchByteOrder);
        }

        private static void validateIsReferenceType(PersistenceTypeDescriptionMember member) {
            if (member.isReference()) {
                return;
            }
            throw new BinaryPersistenceException("Non-reference type \"" + Default.toTypedIdentifier(member) + "\" cannot be handled generically.");
        }

        private static void validateIsReferenceType(Class<?> type) {
            if (!type.isPrimitive()) {
                return;
            }
            throw new BinaryPersistenceException("Unhandled primitive type: \"" + type.getName() + ".");
        }

        private static String toTypedIdentifier(PersistenceTypeDescriptionMember member) {
            return String.valueOf(member.typeName()) + "\" of " + PersistenceTypeDescriptionMember.class.getSimpleName() + " " + member.identifier();
        }

        private BinaryValueSetter lookupCustomValueTranslator(PersistenceTypeDefinition sourceLegacyType, PersistenceTypeDescriptionMember sourceMember, PersistenceTypeHandler<Binary, ?> targetCurrentType, PersistenceTypeDescriptionMember targetMember) {
            BinaryValueTranslatorKeyBuilder[] translatorKeyBuilders;
            if (this.translatorKeyBuilders == null || this.customTranslatorLookup == null) {
                return null;
            }
            XGettingMap<String, BinaryValueSetter> customTranslatorLookup = this.customTranslatorLookup;
            BinaryValueTranslatorKeyBuilder[] binaryValueTranslatorKeyBuilderArray = translatorKeyBuilders = this.translatorKeyBuilders;
            int n = translatorKeyBuilders.length;
            int n2 = 0;
            while (n2 < n) {
                BinaryValueTranslatorKeyBuilder keyBuilder = binaryValueTranslatorKeyBuilderArray[n2];
                String key = keyBuilder.buildTranslatorLookupKey(sourceLegacyType, sourceMember, targetCurrentType, targetMember);
                BinaryValueSetter customValueSetter = (BinaryValueSetter)customTranslatorLookup.get((Object)key);
                if (customValueSetter != null) {
                    return customValueSetter;
                }
                ++n2;
            }
            return null;
        }

        @Override
        public BinaryValueSetter provideTargetValueTranslator(PersistenceTypeDefinition sourceLegacyType, PersistenceTypeDefinitionMember sourceMember, PersistenceTypeHandler<Binary, ?> targetCurrentType, PersistenceTypeDefinitionMember targetMember) {
            if (targetMember == null) {
                return this.provideValueSkipper(sourceMember);
            }
            BinaryValueSetter customValueSetter = this.lookupCustomValueTranslator(sourceLegacyType, (PersistenceTypeDescriptionMember)sourceMember, targetCurrentType, (PersistenceTypeDescriptionMember)targetMember);
            if (customValueSetter != null) {
                return customValueSetter;
            }
            Class sourceType = sourceMember.type();
            Class targetType = targetMember.type();
            if (sourceType != null && targetType != null) {
                return this.provideValueTranslator(sourceType, targetType);
            }
            return this.provideReferenceResolver((PersistenceTypeDescriptionMember)sourceMember, (PersistenceTypeDescriptionMember)targetMember);
        }

        @Override
        public final BinaryValueSetter provideBinaryValueTranslator(PersistenceTypeDefinition sourceLegacyType, PersistenceTypeDefinitionMember sourceMember, PersistenceTypeHandler<Binary, ?> targetCurrentType, PersistenceTypeDefinitionMember targetMember) {
            if (sourceMember.isReference()) {
                return BinaryValueTranslators.provideReferenceValueBinaryTranslator((PersistenceTypeDescriptionMember)sourceMember, (PersistenceTypeDescriptionMember)targetMember);
            }
            Default.validateIsPrimitiveType(sourceMember);
            if (targetMember != null) {
                Default.validateIsPrimitiveType(targetMember);
            }
            return this.provideTargetValueTranslator(sourceLegacyType, sourceMember, targetCurrentType, targetMember);
        }
    }
}

