/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.binary.types;

import one.microstream.X;
import one.microstream.memory.XMemory;
import one.microstream.persistence.binary.exceptions.BinaryPersistenceException;
import one.microstream.persistence.binary.types.Binary;
import one.microstream.persistence.binary.types.BinaryValueSetter;
import one.microstream.persistence.types.PersistenceLoadHandler;
import one.microstream.persistence.types.PersistenceTypeDescriptionMember;
import one.microstream.reference.Lazy;
import one.microstream.reference.ObjectSwizzling;
import one.microstream.typing.TypeMapping;

public final class BinaryValueTranslators {
    public static BinaryValueSetter provideReferenceValueBinaryTranslator(PersistenceTypeDescriptionMember sourceMember, PersistenceTypeDescriptionMember targetMember) {
        if (targetMember == null) {
            return BinaryValueTranslators::skip_long;
        }
        if (!targetMember.isReference()) {
            BinaryValueTranslators.throwUnhandledTypeCompatibilityException(sourceMember.typeName(), targetMember.typeName());
        }
        return BinaryValueTranslators::copy_longTo_long;
    }

    private static void throwUnhandledTypeCompatibilityException(String sourceType, String targetType) {
        throw new BinaryPersistenceException("Cannot convert between primitive and reference values: " + sourceType + " <-> " + targetType + ".");
    }

    public static final TypeMapping<BinaryValueSetter> createDefaultValueTranslators(boolean switchByteOrder) {
        return switchByteOrder ? BinaryValueTranslators.createDefaultValueTranslatorsSwitchingByteOrder() : BinaryValueTranslators.createDefaultValueTranslatorsDirectByteOrder();
    }

    public static final TypeMapping<BinaryValueSetter> createDefaultValueTranslatorsDirectByteOrder() {
        TypeMapping mapping = TypeMapping.New();
        BinaryValueTranslators.registerPrimitivesToPrimitives((TypeMapping<BinaryValueSetter>)mapping);
        BinaryValueTranslators.registerPrimitivesToWrappers((TypeMapping<BinaryValueSetter>)mapping);
        BinaryValueTranslators.registerWrappersToPrimitives((TypeMapping<BinaryValueSetter>)mapping);
        BinaryValueTranslators.registerWrappersToWrappers((TypeMapping<BinaryValueSetter>)mapping);
        BinaryValueTranslators.registerCommonValueTypes((TypeMapping<BinaryValueSetter>)mapping);
        return mapping;
    }

    public static final TypeMapping<BinaryValueSetter> createDefaultValueTranslatorsSwitchingByteOrder() {
        TypeMapping mapping = TypeMapping.New();
        BinaryValueTranslators.registerPrimitivesToPrimitivesSwitchingByteOrder((TypeMapping<BinaryValueSetter>)mapping);
        BinaryValueTranslators.registerPrimitivesToWrappersSwitchingByteOrder((TypeMapping<BinaryValueSetter>)mapping);
        BinaryValueTranslators.registerWrappersToPrimitivesSwitchingByteOrder((TypeMapping<BinaryValueSetter>)mapping);
        BinaryValueTranslators.registerWrappersToWrappersSwitchingByteOrder((TypeMapping<BinaryValueSetter>)mapping);
        BinaryValueTranslators.registerCommonValueTypesSwitchingByteOrder((TypeMapping<BinaryValueSetter>)mapping);
        return mapping;
    }

    private static void registerPrimitivesToPrimitives(TypeMapping<BinaryValueSetter> mapping) {
        mapping.register(Byte.TYPE, Byte.TYPE, BinaryValueTranslators::copy_byteTo_byte).register(Byte.TYPE, Boolean.TYPE, BinaryValueTranslators::copy_byteTo_boolean).register(Byte.TYPE, Short.TYPE, BinaryValueTranslators::copy_byteTo_short).register(Byte.TYPE, Character.TYPE, BinaryValueTranslators::copy_byteTo_char).register(Byte.TYPE, Integer.TYPE, BinaryValueTranslators::copy_byteTo_int).register(Byte.TYPE, Float.TYPE, BinaryValueTranslators::copy_byteTo_float).register(Byte.TYPE, Long.TYPE, BinaryValueTranslators::copy_byteTo_long).register(Byte.TYPE, Double.TYPE, BinaryValueTranslators::copy_byteTo_double).register(Boolean.TYPE, Byte.TYPE, BinaryValueTranslators::copy_booleanTo_byte).register(Boolean.TYPE, Boolean.TYPE, BinaryValueTranslators::copy_booleanTo_boolean).register(Boolean.TYPE, Short.TYPE, BinaryValueTranslators::copy_booleanTo_short).register(Boolean.TYPE, Character.TYPE, BinaryValueTranslators::copy_booleanTo_char).register(Boolean.TYPE, Integer.TYPE, BinaryValueTranslators::copy_booleanTo_int).register(Boolean.TYPE, Float.TYPE, BinaryValueTranslators::copy_booleanTo_float).register(Boolean.TYPE, Long.TYPE, BinaryValueTranslators::copy_booleanTo_long).register(Boolean.TYPE, Double.TYPE, BinaryValueTranslators::copy_booleanTo_double).register(Short.TYPE, Byte.TYPE, BinaryValueTranslators::copy_shortTo_byte).register(Short.TYPE, Boolean.TYPE, BinaryValueTranslators::copy_shortTo_boolean).register(Short.TYPE, Short.TYPE, BinaryValueTranslators::copy_shortTo_short).register(Short.TYPE, Character.TYPE, BinaryValueTranslators::copy_shortTo_char).register(Short.TYPE, Integer.TYPE, BinaryValueTranslators::copy_shortTo_int).register(Short.TYPE, Float.TYPE, BinaryValueTranslators::copy_shortTo_float).register(Short.TYPE, Long.TYPE, BinaryValueTranslators::copy_shortTo_long).register(Short.TYPE, Double.TYPE, BinaryValueTranslators::copy_shortTo_double).register(Character.TYPE, Byte.TYPE, BinaryValueTranslators::copy_charTo_byte).register(Character.TYPE, Boolean.TYPE, BinaryValueTranslators::copy_charTo_boolean).register(Character.TYPE, Short.TYPE, BinaryValueTranslators::copy_charTo_short).register(Character.TYPE, Character.TYPE, BinaryValueTranslators::copy_charTo_char).register(Character.TYPE, Integer.TYPE, BinaryValueTranslators::copy_charTo_int).register(Character.TYPE, Float.TYPE, BinaryValueTranslators::copy_charTo_float).register(Character.TYPE, Long.TYPE, BinaryValueTranslators::copy_charTo_long).register(Character.TYPE, Double.TYPE, BinaryValueTranslators::copy_charTo_double).register(Integer.TYPE, Byte.TYPE, BinaryValueTranslators::copy_intTo_byte).register(Integer.TYPE, Boolean.TYPE, BinaryValueTranslators::copy_intTo_boolean).register(Integer.TYPE, Short.TYPE, BinaryValueTranslators::copy_intTo_short).register(Integer.TYPE, Character.TYPE, BinaryValueTranslators::copy_intTo_char).register(Integer.TYPE, Integer.TYPE, BinaryValueTranslators::copy_intTo_int).register(Integer.TYPE, Float.TYPE, BinaryValueTranslators::copy_intTo_float).register(Integer.TYPE, Long.TYPE, BinaryValueTranslators::copy_intTo_long).register(Integer.TYPE, Double.TYPE, BinaryValueTranslators::copy_intTo_double).register(Float.TYPE, Byte.TYPE, BinaryValueTranslators::copy_floatTo_byte).register(Float.TYPE, Boolean.TYPE, BinaryValueTranslators::copy_floatTo_boolean).register(Float.TYPE, Short.TYPE, BinaryValueTranslators::copy_floatTo_short).register(Float.TYPE, Character.TYPE, BinaryValueTranslators::copy_floatTo_char).register(Float.TYPE, Integer.TYPE, BinaryValueTranslators::copy_floatTo_int).register(Float.TYPE, Float.TYPE, BinaryValueTranslators::copy_floatTo_float).register(Float.TYPE, Long.TYPE, BinaryValueTranslators::copy_floatTo_long).register(Float.TYPE, Double.TYPE, BinaryValueTranslators::copy_floatTo_double).register(Long.TYPE, Byte.TYPE, BinaryValueTranslators::copy_longTo_byte).register(Long.TYPE, Boolean.TYPE, BinaryValueTranslators::copy_longTo_boolean).register(Long.TYPE, Short.TYPE, BinaryValueTranslators::copy_longTo_short).register(Long.TYPE, Character.TYPE, BinaryValueTranslators::copy_longTo_char).register(Long.TYPE, Integer.TYPE, BinaryValueTranslators::copy_longTo_int).register(Long.TYPE, Float.TYPE, BinaryValueTranslators::copy_longTo_float).register(Long.TYPE, Long.TYPE, BinaryValueTranslators::copy_longTo_long).register(Long.TYPE, Double.TYPE, BinaryValueTranslators::copy_longTo_double).register(Double.TYPE, Byte.TYPE, BinaryValueTranslators::copy_doubleTo_byte).register(Double.TYPE, Boolean.TYPE, BinaryValueTranslators::copy_doubleTo_boolean).register(Double.TYPE, Short.TYPE, BinaryValueTranslators::copy_doubleTo_short).register(Double.TYPE, Character.TYPE, BinaryValueTranslators::copy_doubleTo_char).register(Double.TYPE, Integer.TYPE, BinaryValueTranslators::copy_doubleTo_int).register(Double.TYPE, Float.TYPE, BinaryValueTranslators::copy_doubleTo_float).register(Double.TYPE, Long.TYPE, BinaryValueTranslators::copy_doubleTo_long).register(Double.TYPE, Double.TYPE, BinaryValueTranslators::copy_doubleTo_double);
    }

    private static void registerPrimitivesToWrappers(TypeMapping<BinaryValueSetter> mapping) {
        mapping.register(Byte.TYPE, Byte.class, BinaryValueTranslators::copy_byteAsByte).register(Boolean.TYPE, Boolean.class, BinaryValueTranslators::copy_booleanAsBoolean).register(Short.TYPE, Short.class, BinaryValueTranslators::copy_shortAsShort).register(Character.TYPE, Character.class, BinaryValueTranslators::copy_charAsCharacter).register(Integer.TYPE, Integer.class, BinaryValueTranslators::copy_intAsInteger).register(Float.TYPE, Float.class, BinaryValueTranslators::copy_floatAsFloat).register(Long.TYPE, Long.class, BinaryValueTranslators::copy_longAsLong).register(Double.TYPE, Double.class, BinaryValueTranslators::copy_doubleAsDouble);
    }

    private static void registerWrappersToPrimitives(TypeMapping<BinaryValueSetter> mapping) {
        mapping.register(Byte.class, Byte.TYPE, BinaryValueTranslators::copyByteTo_byte).register(Boolean.class, Boolean.TYPE, BinaryValueTranslators::copyBooleanTo_boolean).register(Short.class, Short.TYPE, BinaryValueTranslators::copyShortTo_short).register(Character.class, Character.TYPE, BinaryValueTranslators::copyCharacterTo_char).register(Integer.class, Integer.TYPE, BinaryValueTranslators::copyIntegerTo_int).register(Float.class, Float.TYPE, BinaryValueTranslators::copyFloatTo_float).register(Long.class, Long.TYPE, BinaryValueTranslators::copyLongTo_long).register(Double.class, Double.TYPE, BinaryValueTranslators::copyDoubleTo_double);
    }

    private static void registerWrappersToWrappers(TypeMapping<BinaryValueSetter> mapping) {
    }

    private static void registerCommonValueTypes(TypeMapping<BinaryValueSetter> mapping) {
    }

    private static int to_int(boolean value) {
        return value ? 1 : 0;
    }

    public static long skip_byte(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        return sourceAddress + (long)XMemory.byteSize_byte();
    }

    public static long skip_boolean(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        return sourceAddress + (long)XMemory.byteSize_boolean();
    }

    public static long skip_short(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        return sourceAddress + (long)XMemory.byteSize_short();
    }

    public static long skip_char(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        return sourceAddress + (long)XMemory.byteSize_char();
    }

    public static long skip_int(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        return sourceAddress + (long)XMemory.byteSize_int();
    }

    public static long skip_float(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        return sourceAddress + 4L;
    }

    public static long skip_long(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        return sourceAddress + (long)XMemory.byteSize_long();
    }

    public static long skip_double(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        return sourceAddress + (long)XMemory.byteSize_double();
    }

    public static long copy_byteTo_byte(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_byte((Object)target, (long)targetOffset, (byte)XMemory.get_byte((long)sourceAddress));
        return sourceAddress + (long)XMemory.byteSize_byte();
    }

    public static long copy_byteTo_boolean(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_boolean((Object)target, (long)targetOffset, (XMemory.get_byte((long)sourceAddress) != 0 ? 1 : 0) != 0);
        return sourceAddress + (long)XMemory.byteSize_byte();
    }

    public static long copy_byteTo_short(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_short((Object)target, (long)targetOffset, (short)XMemory.get_byte((long)sourceAddress));
        return sourceAddress + (long)XMemory.byteSize_byte();
    }

    public static long copy_byteTo_char(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_char((Object)target, (long)targetOffset, (char)((char)XMemory.get_byte((long)sourceAddress)));
        return sourceAddress + (long)XMemory.byteSize_byte();
    }

    public static long copy_byteTo_int(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_int((Object)target, (long)targetOffset, (int)XMemory.get_byte((long)sourceAddress));
        return sourceAddress + (long)XMemory.byteSize_byte();
    }

    public static long copy_byteTo_float(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_float((Object)target, (long)targetOffset, (float)XMemory.get_byte((long)sourceAddress));
        return sourceAddress + (long)XMemory.byteSize_byte();
    }

    public static long copy_byteTo_long(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_long((Object)target, (long)targetOffset, (long)XMemory.get_byte((long)sourceAddress));
        return sourceAddress + (long)XMemory.byteSize_byte();
    }

    public static long copy_byteTo_double(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_double((Object)target, (long)targetOffset, (double)XMemory.get_byte((long)sourceAddress));
        return sourceAddress + (long)XMemory.byteSize_byte();
    }

    public static long copy_booleanTo_byte(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_byte((Object)target, (long)targetOffset, (byte)((byte)BinaryValueTranslators.to_int(XMemory.get_boolean((long)sourceAddress))));
        return sourceAddress + (long)XMemory.byteSize_boolean();
    }

    public static long copy_booleanTo_boolean(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_boolean((Object)target, (long)targetOffset, (boolean)XMemory.get_boolean((long)sourceAddress));
        return sourceAddress + (long)XMemory.byteSize_boolean();
    }

    public static long copy_booleanTo_short(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_short((Object)target, (long)targetOffset, (short)((short)BinaryValueTranslators.to_int(XMemory.get_boolean((long)sourceAddress))));
        return sourceAddress + (long)XMemory.byteSize_boolean();
    }

    public static long copy_booleanTo_char(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_char((Object)target, (long)targetOffset, (char)((char)BinaryValueTranslators.to_int(XMemory.get_boolean((long)sourceAddress))));
        return sourceAddress + (long)XMemory.byteSize_boolean();
    }

    public static long copy_booleanTo_int(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_int((Object)target, (long)targetOffset, (int)BinaryValueTranslators.to_int(XMemory.get_boolean((long)sourceAddress)));
        return sourceAddress + (long)XMemory.byteSize_boolean();
    }

    public static long copy_booleanTo_float(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_float((Object)target, (long)targetOffset, (float)BinaryValueTranslators.to_int(XMemory.get_boolean((long)sourceAddress)));
        return sourceAddress + (long)XMemory.byteSize_boolean();
    }

    public static long copy_booleanTo_long(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_long((Object)target, (long)targetOffset, (long)BinaryValueTranslators.to_int(XMemory.get_boolean((long)sourceAddress)));
        return sourceAddress + (long)XMemory.byteSize_boolean();
    }

    public static long copy_booleanTo_double(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_double((Object)target, (long)targetOffset, (double)BinaryValueTranslators.to_int(XMemory.get_boolean((long)sourceAddress)));
        return sourceAddress + (long)XMemory.byteSize_boolean();
    }

    public static long copy_shortTo_byte(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_byte((Object)target, (long)targetOffset, (byte)((byte)XMemory.get_short((long)sourceAddress)));
        return sourceAddress + (long)XMemory.byteSize_short();
    }

    public static long copy_shortTo_boolean(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_boolean((Object)target, (long)targetOffset, (XMemory.get_short((long)sourceAddress) != 0 ? 1 : 0) != 0);
        return sourceAddress + (long)XMemory.byteSize_short();
    }

    public static long copy_shortTo_short(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_short((Object)target, (long)targetOffset, (short)XMemory.get_short((long)sourceAddress));
        return sourceAddress + (long)XMemory.byteSize_short();
    }

    public static long copy_shortTo_char(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_char((Object)target, (long)targetOffset, (char)((char)XMemory.get_short((long)sourceAddress)));
        return sourceAddress + (long)XMemory.byteSize_short();
    }

    public static long copy_shortTo_int(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_int((Object)target, (long)targetOffset, (int)XMemory.get_short((long)sourceAddress));
        return sourceAddress + (long)XMemory.byteSize_short();
    }

    public static long copy_shortTo_float(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_float((Object)target, (long)targetOffset, (float)XMemory.get_short((long)sourceAddress));
        return sourceAddress + (long)XMemory.byteSize_short();
    }

    public static long copy_shortTo_long(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_long((Object)target, (long)targetOffset, (long)XMemory.get_short((long)sourceAddress));
        return sourceAddress + (long)XMemory.byteSize_short();
    }

    public static long copy_shortTo_double(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_double((Object)target, (long)targetOffset, (double)XMemory.get_short((long)sourceAddress));
        return sourceAddress + (long)XMemory.byteSize_short();
    }

    public static long copy_charTo_byte(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_byte((Object)target, (long)targetOffset, (byte)((byte)XMemory.get_char((long)sourceAddress)));
        return sourceAddress + (long)XMemory.byteSize_char();
    }

    public static long copy_charTo_boolean(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_boolean((Object)target, (long)targetOffset, (XMemory.get_char((long)sourceAddress) != '\u0000' ? 1 : 0) != 0);
        return sourceAddress + (long)XMemory.byteSize_char();
    }

    public static long copy_charTo_short(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_short((Object)target, (long)targetOffset, (short)((short)XMemory.get_char((long)sourceAddress)));
        return sourceAddress + (long)XMemory.byteSize_char();
    }

    public static long copy_charTo_char(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_char((Object)target, (long)targetOffset, (char)XMemory.get_char((long)sourceAddress));
        return sourceAddress + (long)XMemory.byteSize_char();
    }

    public static long copy_charTo_int(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_int((Object)target, (long)targetOffset, (int)XMemory.get_char((long)sourceAddress));
        return sourceAddress + (long)XMemory.byteSize_char();
    }

    public static long copy_charTo_float(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_float((Object)target, (long)targetOffset, (float)XMemory.get_char((long)sourceAddress));
        return sourceAddress + (long)XMemory.byteSize_char();
    }

    public static long copy_charTo_long(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_long((Object)target, (long)targetOffset, (long)XMemory.get_char((long)sourceAddress));
        return sourceAddress + (long)XMemory.byteSize_char();
    }

    public static long copy_charTo_double(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_double((Object)target, (long)targetOffset, (double)XMemory.get_char((long)sourceAddress));
        return sourceAddress + (long)XMemory.byteSize_char();
    }

    public static long copy_intTo_byte(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_byte((Object)target, (long)targetOffset, (byte)((byte)XMemory.get_int((long)sourceAddress)));
        return sourceAddress + (long)XMemory.byteSize_int();
    }

    public static long copy_intTo_boolean(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_boolean((Object)target, (long)targetOffset, (XMemory.get_int((long)sourceAddress) != 0 ? 1 : 0) != 0);
        return sourceAddress + (long)XMemory.byteSize_int();
    }

    public static long copy_intTo_short(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_short((Object)target, (long)targetOffset, (short)((short)XMemory.get_int((long)sourceAddress)));
        return sourceAddress + (long)XMemory.byteSize_int();
    }

    public static long copy_intTo_char(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_char((Object)target, (long)targetOffset, (char)((char)XMemory.get_int((long)sourceAddress)));
        return sourceAddress + (long)XMemory.byteSize_int();
    }

    public static long copy_intTo_int(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_int((Object)target, (long)targetOffset, (int)XMemory.get_int((long)sourceAddress));
        return sourceAddress + (long)XMemory.byteSize_int();
    }

    public static long copy_intTo_float(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_float((Object)target, (long)targetOffset, (float)XMemory.get_int((long)sourceAddress));
        return sourceAddress + (long)XMemory.byteSize_int();
    }

    public static long copy_intTo_long(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_long((Object)target, (long)targetOffset, (long)XMemory.get_int((long)sourceAddress));
        return sourceAddress + (long)XMemory.byteSize_int();
    }

    public static long copy_intTo_double(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_double((Object)target, (long)targetOffset, (double)XMemory.get_int((long)sourceAddress));
        return sourceAddress + (long)XMemory.byteSize_int();
    }

    public static long copy_floatTo_byte(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_byte((Object)target, (long)targetOffset, (byte)((byte)XMemory.get_float((long)sourceAddress)));
        return sourceAddress + 4L;
    }

    public static long copy_floatTo_boolean(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_boolean((Object)target, (long)targetOffset, (0.0f != XMemory.get_float((long)sourceAddress) ? 1 : 0) != 0);
        return sourceAddress + 4L;
    }

    public static long copy_floatTo_short(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_short((Object)target, (long)targetOffset, (short)((short)XMemory.get_float((long)sourceAddress)));
        return sourceAddress + 4L;
    }

    public static long copy_floatTo_char(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_char((Object)target, (long)targetOffset, (char)((char)XMemory.get_float((long)sourceAddress)));
        return sourceAddress + 4L;
    }

    public static long copy_floatTo_int(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_int((Object)target, (long)targetOffset, (int)((int)XMemory.get_float((long)sourceAddress)));
        return sourceAddress + 4L;
    }

    public static long copy_floatTo_float(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_float((Object)target, (long)targetOffset, (float)XMemory.get_float((long)sourceAddress));
        return sourceAddress + 4L;
    }

    public static long copy_floatTo_long(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_long((Object)target, (long)targetOffset, (long)((long)XMemory.get_float((long)sourceAddress)));
        return sourceAddress + 4L;
    }

    public static long copy_floatTo_double(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_double((Object)target, (long)targetOffset, (double)XMemory.get_float((long)sourceAddress));
        return sourceAddress + 4L;
    }

    public static long copy_longTo_byte(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_byte((Object)target, (long)targetOffset, (byte)((byte)XMemory.get_long((long)sourceAddress)));
        return sourceAddress + (long)XMemory.byteSize_long();
    }

    public static long copy_longTo_boolean(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_boolean((Object)target, (long)targetOffset, (0L != XMemory.get_long((long)sourceAddress) ? 1 : 0) != 0);
        return sourceAddress + (long)XMemory.byteSize_long();
    }

    public static long copy_longTo_short(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_short((Object)target, (long)targetOffset, (short)((short)XMemory.get_long((long)sourceAddress)));
        return sourceAddress + (long)XMemory.byteSize_long();
    }

    public static long copy_longTo_char(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_char((Object)target, (long)targetOffset, (char)((char)XMemory.get_long((long)sourceAddress)));
        return sourceAddress + (long)XMemory.byteSize_long();
    }

    public static long copy_longTo_int(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_int((Object)target, (long)targetOffset, (int)((int)XMemory.get_long((long)sourceAddress)));
        return sourceAddress + (long)XMemory.byteSize_long();
    }

    public static long copy_longTo_float(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_float((Object)target, (long)targetOffset, (float)XMemory.get_long((long)sourceAddress));
        return sourceAddress + (long)XMemory.byteSize_long();
    }

    public static long copy_longTo_long(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_long((Object)target, (long)targetOffset, (long)XMemory.get_long((long)sourceAddress));
        return sourceAddress + (long)XMemory.byteSize_long();
    }

    public static long copy_longTo_double(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_double((Object)target, (long)targetOffset, (double)XMemory.get_long((long)sourceAddress));
        return sourceAddress + (long)XMemory.byteSize_long();
    }

    public static long copy_doubleTo_byte(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_byte((Object)target, (long)targetOffset, (byte)((byte)XMemory.get_double((long)sourceAddress)));
        return sourceAddress + (long)XMemory.byteSize_double();
    }

    public static long copy_doubleTo_boolean(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_boolean((Object)target, (long)targetOffset, (0.0 != XMemory.get_double((long)sourceAddress) ? 1 : 0) != 0);
        return sourceAddress + (long)XMemory.byteSize_double();
    }

    public static long copy_doubleTo_short(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_short((Object)target, (long)targetOffset, (short)((short)XMemory.get_double((long)sourceAddress)));
        return sourceAddress + (long)XMemory.byteSize_double();
    }

    public static long copy_doubleTo_char(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_char((Object)target, (long)targetOffset, (char)((char)XMemory.get_double((long)sourceAddress)));
        return sourceAddress + (long)XMemory.byteSize_double();
    }

    public static long copy_doubleTo_int(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_int((Object)target, (long)targetOffset, (int)((int)XMemory.get_double((long)sourceAddress)));
        return sourceAddress + (long)XMemory.byteSize_double();
    }

    public static long copy_doubleTo_float(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_float((Object)target, (long)targetOffset, (float)((float)XMemory.get_double((long)sourceAddress)));
        return sourceAddress + (long)XMemory.byteSize_double();
    }

    public static long copy_doubleTo_long(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_long((Object)target, (long)targetOffset, (long)((long)XMemory.get_double((long)sourceAddress)));
        return sourceAddress + (long)XMemory.byteSize_double();
    }

    public static long copy_doubleTo_double(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_double((Object)target, (long)targetOffset, (double)XMemory.get_double((long)sourceAddress));
        return sourceAddress + (long)XMemory.byteSize_double();
    }

    public static long copy_byteAsByte(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.setObject((Object)target, (long)targetOffset, (Object)XMemory.get_byte((long)sourceAddress));
        return sourceAddress + (long)XMemory.byteSize_byte();
    }

    public static long copy_booleanAsBoolean(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.setObject((Object)target, (long)targetOffset, (Object)XMemory.get_boolean((long)sourceAddress));
        return sourceAddress + (long)XMemory.byteSize_boolean();
    }

    public static long copy_shortAsShort(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.setObject((Object)target, (long)targetOffset, (Object)XMemory.get_short((long)sourceAddress));
        return sourceAddress + (long)XMemory.byteSize_short();
    }

    public static long copy_charAsCharacter(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.setObject((Object)target, (long)targetOffset, (Object)Character.valueOf(XMemory.get_char((long)sourceAddress)));
        return sourceAddress + (long)XMemory.byteSize_char();
    }

    public static long copy_intAsInteger(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.setObject((Object)target, (long)targetOffset, (Object)XMemory.get_int((long)sourceAddress));
        return sourceAddress + (long)XMemory.byteSize_int();
    }

    public static long copy_floatAsFloat(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.setObject((Object)target, (long)targetOffset, (Object)Float.valueOf(XMemory.get_float((long)sourceAddress)));
        return sourceAddress + (long)XMemory.byteSize_float();
    }

    public static long copy_longAsLong(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.setObject((Object)target, (long)targetOffset, (Object)XMemory.get_long((long)sourceAddress));
        return sourceAddress + (long)XMemory.byteSize_long();
    }

    public static long copy_doubleAsDouble(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.setObject((Object)target, (long)targetOffset, (Object)XMemory.get_double((long)sourceAddress));
        return sourceAddress + (long)XMemory.byteSize_double();
    }

    public static long copyByteTo_byte(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_byte((Object)target, (long)targetOffset, (byte)X.unbox((Byte)((Byte)handler.lookupObject(XMemory.get_long((long)sourceAddress)))));
        return sourceAddress + (long)Binary.objectIdByteLength();
    }

    public static long copyBooleanTo_boolean(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_boolean((Object)target, (long)targetOffset, (boolean)X.unbox((Boolean)((Boolean)handler.lookupObject(XMemory.get_long((long)sourceAddress)))));
        return sourceAddress + (long)Binary.objectIdByteLength();
    }

    public static long copyShortTo_short(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_short((Object)target, (long)targetOffset, (short)X.unbox((Short)((Short)handler.lookupObject(XMemory.get_long((long)sourceAddress)))));
        return sourceAddress + (long)Binary.objectIdByteLength();
    }

    public static long copyCharacterTo_char(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_char((Object)target, (long)targetOffset, (char)X.unbox((Character)((Character)handler.lookupObject(XMemory.get_long((long)sourceAddress)))));
        return sourceAddress + (long)Binary.objectIdByteLength();
    }

    public static long copyIntegerTo_int(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_int((Object)target, (long)targetOffset, (int)X.unbox((Integer)((Integer)handler.lookupObject(XMemory.get_long((long)sourceAddress)))));
        return sourceAddress + (long)Binary.objectIdByteLength();
    }

    public static long copyFloatTo_float(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_float((Object)target, (long)targetOffset, (float)X.unbox((Float)((Float)handler.lookupObject(XMemory.get_long((long)sourceAddress)))));
        return sourceAddress + (long)Binary.objectIdByteLength();
    }

    public static long copyLongTo_long(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_long((Object)target, (long)targetOffset, (long)X.unbox((Long)((Long)handler.lookupObject(XMemory.get_long((long)sourceAddress)))));
        return sourceAddress + (long)Binary.objectIdByteLength();
    }

    public static long copyDoubleTo_double(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_double((Object)target, (long)targetOffset, (double)X.unbox((Double)((Double)handler.lookupObject(XMemory.get_long((long)sourceAddress)))));
        return sourceAddress + (long)Binary.objectIdByteLength();
    }

    public static long removeLazyReference(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        throw new UnsupportedOperationException("Architecture does not support a new loading during loading.");
    }

    public static long wrapWithLazyReference(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        long objectId = XMemory.get_long((long)sourceAddress);
        Lazy wrappingLazyReference = Lazy.New((long)objectId, (ObjectSwizzling)handler.getObjectRetriever());
        XMemory.setObject((Object)target, (long)targetOffset, (Object)wrappingLazyReference);
        return sourceAddress + (long)Binary.objectIdByteLength();
    }

    private BinaryValueTranslators() {
        throw new UnsupportedOperationException();
    }

    private static void registerPrimitivesToPrimitivesSwitchingByteOrder(TypeMapping<BinaryValueSetter> mapping) {
        mapping.register(Byte.TYPE, Byte.TYPE, BinaryValueTranslators::copy_byteTo_byte).register(Byte.TYPE, Boolean.TYPE, BinaryValueTranslators::copy_byteTo_boolean).register(Byte.TYPE, Short.TYPE, BinaryValueTranslators::switchingCopy_byteTo_short).register(Byte.TYPE, Character.TYPE, BinaryValueTranslators::switchingCopy_byteTo_char).register(Byte.TYPE, Integer.TYPE, BinaryValueTranslators::switchingCopy_byteTo_int).register(Byte.TYPE, Float.TYPE, BinaryValueTranslators::switchingCopy_byteTo_float).register(Byte.TYPE, Long.TYPE, BinaryValueTranslators::switchingCopy_byteTo_long).register(Byte.TYPE, Double.TYPE, BinaryValueTranslators::switchingCopy_byteTo_double).register(Boolean.TYPE, Byte.TYPE, BinaryValueTranslators::copy_booleanTo_byte).register(Boolean.TYPE, Boolean.TYPE, BinaryValueTranslators::copy_booleanTo_boolean).register(Boolean.TYPE, Short.TYPE, BinaryValueTranslators::switchingCopy_booleanTo_short).register(Boolean.TYPE, Character.TYPE, BinaryValueTranslators::switchingCopy_booleanTo_char).register(Boolean.TYPE, Integer.TYPE, BinaryValueTranslators::switchingCopy_booleanTo_int).register(Boolean.TYPE, Float.TYPE, BinaryValueTranslators::switchingCopy_booleanTo_float).register(Boolean.TYPE, Long.TYPE, BinaryValueTranslators::switchingCopy_booleanTo_long).register(Boolean.TYPE, Double.TYPE, BinaryValueTranslators::switchingCopy_booleanTo_double).register(Short.TYPE, Byte.TYPE, BinaryValueTranslators::switchingCopy_shortTo_byte).register(Short.TYPE, Boolean.TYPE, BinaryValueTranslators::switchingCopy_shortTo_boolean).register(Short.TYPE, Short.TYPE, BinaryValueTranslators::copy_shortTo_short).register(Short.TYPE, Character.TYPE, BinaryValueTranslators::switchingCopy_shortTo_char).register(Short.TYPE, Integer.TYPE, BinaryValueTranslators::switchingCopy_shortTo_int).register(Short.TYPE, Float.TYPE, BinaryValueTranslators::switchingCopy_shortTo_float).register(Short.TYPE, Long.TYPE, BinaryValueTranslators::switchingCopy_shortTo_long).register(Short.TYPE, Double.TYPE, BinaryValueTranslators::switchingCopy_shortTo_double).register(Character.TYPE, Byte.TYPE, BinaryValueTranslators::switchingCopy_charTo_byte).register(Character.TYPE, Boolean.TYPE, BinaryValueTranslators::switchingCopy_charTo_boolean).register(Character.TYPE, Short.TYPE, BinaryValueTranslators::switchingCopy_charTo_short).register(Character.TYPE, Character.TYPE, BinaryValueTranslators::copy_charTo_char).register(Character.TYPE, Integer.TYPE, BinaryValueTranslators::switchingCopy_charTo_int).register(Character.TYPE, Float.TYPE, BinaryValueTranslators::switchingCopy_charTo_float).register(Character.TYPE, Long.TYPE, BinaryValueTranslators::switchingCopy_charTo_long).register(Character.TYPE, Double.TYPE, BinaryValueTranslators::switchingCopy_charTo_double).register(Integer.TYPE, Byte.TYPE, BinaryValueTranslators::switchingCopy_intTo_byte).register(Integer.TYPE, Boolean.TYPE, BinaryValueTranslators::switchingCopy_intTo_boolean).register(Integer.TYPE, Short.TYPE, BinaryValueTranslators::switchingCopy_intTo_short).register(Integer.TYPE, Character.TYPE, BinaryValueTranslators::switchingCopy_intTo_char).register(Integer.TYPE, Integer.TYPE, BinaryValueTranslators::copy_intTo_int).register(Integer.TYPE, Float.TYPE, BinaryValueTranslators::switchingCopy_intTo_float).register(Integer.TYPE, Long.TYPE, BinaryValueTranslators::switchingCopy_intTo_long).register(Integer.TYPE, Double.TYPE, BinaryValueTranslators::switchingCopy_intTo_double).register(Float.TYPE, Byte.TYPE, BinaryValueTranslators::switchingCopy_floatTo_byte).register(Float.TYPE, Boolean.TYPE, BinaryValueTranslators::switchingCopy_floatTo_boolean).register(Float.TYPE, Short.TYPE, BinaryValueTranslators::switchingCopy_floatTo_short).register(Float.TYPE, Character.TYPE, BinaryValueTranslators::switchingCopy_floatTo_char).register(Float.TYPE, Integer.TYPE, BinaryValueTranslators::switchingCopy_floatTo_int).register(Float.TYPE, Float.TYPE, BinaryValueTranslators::copy_floatTo_float).register(Float.TYPE, Long.TYPE, BinaryValueTranslators::switchingCopy_floatTo_long).register(Float.TYPE, Double.TYPE, BinaryValueTranslators::switchingCopy_floatTo_double).register(Long.TYPE, Byte.TYPE, BinaryValueTranslators::switchingCopy_longTo_byte).register(Long.TYPE, Boolean.TYPE, BinaryValueTranslators::switchingCopy_longTo_boolean).register(Long.TYPE, Short.TYPE, BinaryValueTranslators::switchingCopy_longTo_short).register(Long.TYPE, Character.TYPE, BinaryValueTranslators::switchingCopy_longTo_char).register(Long.TYPE, Integer.TYPE, BinaryValueTranslators::switchingCopy_longTo_int).register(Long.TYPE, Float.TYPE, BinaryValueTranslators::switchingCopy_longTo_float).register(Long.TYPE, Long.TYPE, BinaryValueTranslators::copy_longTo_long).register(Long.TYPE, Double.TYPE, BinaryValueTranslators::switchingCopy_longTo_double).register(Double.TYPE, Byte.TYPE, BinaryValueTranslators::switchingCopy_doubleTo_byte).register(Double.TYPE, Boolean.TYPE, BinaryValueTranslators::switchingCopy_doubleTo_boolean).register(Double.TYPE, Short.TYPE, BinaryValueTranslators::switchingCopy_doubleTo_short).register(Double.TYPE, Character.TYPE, BinaryValueTranslators::switchingCopy_doubleTo_char).register(Double.TYPE, Integer.TYPE, BinaryValueTranslators::switchingCopy_doubleTo_int).register(Double.TYPE, Float.TYPE, BinaryValueTranslators::switchingCopy_doubleTo_float).register(Double.TYPE, Long.TYPE, BinaryValueTranslators::switchingCopy_doubleTo_long).register(Double.TYPE, Double.TYPE, BinaryValueTranslators::copy_doubleTo_double);
    }

    private static void registerPrimitivesToWrappersSwitchingByteOrder(TypeMapping<BinaryValueSetter> mapping) {
    }

    private static void registerWrappersToPrimitivesSwitchingByteOrder(TypeMapping<BinaryValueSetter> mapping) {
    }

    private static void registerWrappersToWrappersSwitchingByteOrder(TypeMapping<BinaryValueSetter> mapping) {
    }

    private static void registerCommonValueTypesSwitchingByteOrder(TypeMapping<BinaryValueSetter> mapping) {
    }

    public static long switchingCopy_byteTo_short(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_short((Object)target, (long)targetOffset, (short)Short.reverseBytes(XMemory.get_byte((long)sourceAddress)));
        return sourceAddress + (long)XMemory.byteSize_byte();
    }

    public static long switchingCopy_byteTo_char(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_char((Object)target, (long)targetOffset, (char)Character.reverseBytes((char)XMemory.get_byte((long)sourceAddress)));
        return sourceAddress + (long)XMemory.byteSize_byte();
    }

    public static long switchingCopy_byteTo_int(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_int((Object)target, (long)targetOffset, (int)Integer.reverseBytes(XMemory.get_byte((long)sourceAddress)));
        return sourceAddress + (long)XMemory.byteSize_byte();
    }

    public static long switchingCopy_byteTo_float(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_int((Object)target, (long)targetOffset, (int)Integer.reverseBytes(Float.floatToRawIntBits(XMemory.get_byte((long)sourceAddress))));
        return sourceAddress + (long)XMemory.byteSize_byte();
    }

    public static long switchingCopy_byteTo_long(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_long((Object)target, (long)targetOffset, (long)Long.reverseBytes(XMemory.get_byte((long)sourceAddress)));
        return sourceAddress + (long)XMemory.byteSize_byte();
    }

    public static long switchingCopy_byteTo_double(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_long((Object)target, (long)targetOffset, (long)Long.reverseBytes(Double.doubleToRawLongBits(XMemory.get_byte((long)sourceAddress))));
        return sourceAddress + (long)XMemory.byteSize_byte();
    }

    public static long switchingCopy_booleanTo_short(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_short((Object)target, (long)targetOffset, (short)Short.reverseBytes((short)BinaryValueTranslators.to_int(XMemory.get_boolean((long)sourceAddress))));
        return sourceAddress + (long)XMemory.byteSize_boolean();
    }

    public static long switchingCopy_booleanTo_char(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_char((Object)target, (long)targetOffset, (char)Character.reverseBytes((char)BinaryValueTranslators.to_int(XMemory.get_boolean((long)sourceAddress))));
        return sourceAddress + (long)XMemory.byteSize_boolean();
    }

    public static long switchingCopy_booleanTo_int(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_int((Object)target, (long)targetOffset, (int)Integer.reverseBytes(BinaryValueTranslators.to_int(XMemory.get_boolean((long)sourceAddress))));
        return sourceAddress + (long)XMemory.byteSize_boolean();
    }

    public static long switchingCopy_booleanTo_float(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_int((Object)target, (long)targetOffset, (int)Integer.reverseBytes(Float.floatToRawIntBits(BinaryValueTranslators.to_int(XMemory.get_boolean((long)sourceAddress)))));
        return sourceAddress + (long)XMemory.byteSize_boolean();
    }

    public static long switchingCopy_booleanTo_long(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_long((Object)target, (long)targetOffset, (long)Long.reverseBytes(BinaryValueTranslators.to_int(XMemory.get_boolean((long)sourceAddress))));
        return sourceAddress + (long)XMemory.byteSize_boolean();
    }

    public static long switchingCopy_booleanTo_double(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_long((Object)target, (long)targetOffset, (long)Long.reverseBytes(Double.doubleToRawLongBits(BinaryValueTranslators.to_int(XMemory.get_boolean((long)sourceAddress)))));
        return sourceAddress + (long)XMemory.byteSize_boolean();
    }

    public static long switchingCopy_shortTo_byte(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_byte((Object)target, (long)targetOffset, (byte)((byte)Short.reverseBytes(XMemory.get_short((long)sourceAddress))));
        return sourceAddress + (long)XMemory.byteSize_short();
    }

    public static long switchingCopy_shortTo_boolean(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_boolean((Object)target, (long)targetOffset, (Short.reverseBytes(XMemory.get_short((long)sourceAddress)) != 0 ? 1 : 0) != 0);
        return sourceAddress + (long)XMemory.byteSize_short();
    }

    public static long switchingCopy_shortTo_char(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_char((Object)target, (long)targetOffset, (char)Character.reverseBytes((char)Short.reverseBytes(XMemory.get_short((long)sourceAddress))));
        return sourceAddress + (long)XMemory.byteSize_short();
    }

    public static long switchingCopy_shortTo_int(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_int((Object)target, (long)targetOffset, (int)Integer.reverseBytes(Short.reverseBytes(XMemory.get_short((long)sourceAddress))));
        return sourceAddress + (long)XMemory.byteSize_short();
    }

    public static long switchingCopy_shortTo_float(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_int((Object)target, (long)targetOffset, (int)Integer.reverseBytes(Float.floatToRawIntBits(Short.reverseBytes(XMemory.get_short((long)sourceAddress)))));
        return sourceAddress + (long)XMemory.byteSize_short();
    }

    public static long switchingCopy_shortTo_long(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_long((Object)target, (long)targetOffset, (long)Long.reverseBytes(Short.reverseBytes(XMemory.get_short((long)sourceAddress))));
        return sourceAddress + (long)XMemory.byteSize_short();
    }

    public static long switchingCopy_shortTo_double(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_long((Object)target, (long)targetOffset, (long)Long.reverseBytes(Double.doubleToRawLongBits(Short.reverseBytes(XMemory.get_short((long)sourceAddress)))));
        return sourceAddress + (long)XMemory.byteSize_short();
    }

    public static long switchingCopy_charTo_byte(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_byte((Object)target, (long)targetOffset, (byte)((byte)Character.reverseBytes(XMemory.get_char((long)sourceAddress))));
        return sourceAddress + (long)XMemory.byteSize_char();
    }

    public static long switchingCopy_charTo_boolean(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_boolean((Object)target, (long)targetOffset, (Character.reverseBytes(XMemory.get_char((long)sourceAddress)) != '\u0000' ? 1 : 0) != 0);
        return sourceAddress + (long)XMemory.byteSize_char();
    }

    public static long switchingCopy_charTo_short(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_short((Object)target, (long)targetOffset, (short)Short.reverseBytes((short)Character.reverseBytes(XMemory.get_char((long)sourceAddress))));
        return sourceAddress + (long)XMemory.byteSize_char();
    }

    public static long switchingCopy_charTo_int(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_int((Object)target, (long)targetOffset, (int)Integer.reverseBytes(Character.reverseBytes(XMemory.get_char((long)sourceAddress))));
        return sourceAddress + (long)XMemory.byteSize_char();
    }

    public static long switchingCopy_charTo_float(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_int((Object)target, (long)targetOffset, (int)Integer.reverseBytes(Float.floatToRawIntBits(Character.reverseBytes(XMemory.get_char((long)sourceAddress)))));
        return sourceAddress + (long)XMemory.byteSize_char();
    }

    public static long switchingCopy_charTo_long(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_long((Object)target, (long)targetOffset, (long)Long.reverseBytes(Character.reverseBytes(XMemory.get_char((long)sourceAddress))));
        return sourceAddress + (long)XMemory.byteSize_char();
    }

    public static long switchingCopy_charTo_double(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_long((Object)target, (long)targetOffset, (long)Long.reverseBytes(Double.doubleToRawLongBits(Character.reverseBytes(XMemory.get_char((long)sourceAddress)))));
        return sourceAddress + (long)XMemory.byteSize_char();
    }

    public static long switchingCopy_intTo_byte(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_byte((Object)target, (long)targetOffset, (byte)((byte)Integer.reverseBytes(XMemory.get_int((long)sourceAddress))));
        return sourceAddress + (long)XMemory.byteSize_int();
    }

    public static long switchingCopy_intTo_boolean(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_boolean((Object)target, (long)targetOffset, (Integer.reverseBytes(XMemory.get_int((long)sourceAddress)) != 0 ? 1 : 0) != 0);
        return sourceAddress + (long)XMemory.byteSize_int();
    }

    public static long switchingCopy_intTo_short(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_short((Object)target, (long)targetOffset, (short)Short.reverseBytes((short)Integer.reverseBytes(XMemory.get_int((long)sourceAddress))));
        return sourceAddress + (long)XMemory.byteSize_int();
    }

    public static long switchingCopy_intTo_char(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_char((Object)target, (long)targetOffset, (char)Character.reverseBytes((char)Integer.reverseBytes(XMemory.get_int((long)sourceAddress))));
        return sourceAddress + (long)XMemory.byteSize_int();
    }

    public static long switchingCopy_intTo_float(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_int((Object)target, (long)targetOffset, (int)Integer.reverseBytes(Float.floatToRawIntBits(Integer.reverseBytes(XMemory.get_int((long)sourceAddress)))));
        return sourceAddress + (long)XMemory.byteSize_int();
    }

    public static long switchingCopy_intTo_long(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_long((Object)target, (long)targetOffset, (long)Long.reverseBytes(Integer.reverseBytes(XMemory.get_int((long)sourceAddress))));
        return sourceAddress + (long)XMemory.byteSize_int();
    }

    public static long switchingCopy_intTo_double(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_long((Object)target, (long)targetOffset, (long)Long.reverseBytes(Double.doubleToRawLongBits(Integer.reverseBytes(XMemory.get_int((long)sourceAddress)))));
        return sourceAddress + (long)XMemory.byteSize_int();
    }

    public static long switchingCopy_floatTo_byte(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_byte((Object)target, (long)targetOffset, (byte)((byte)Float.intBitsToFloat(Integer.reverseBytes(XMemory.get_int((long)sourceAddress)))));
        return sourceAddress + 4L;
    }

    public static long switchingCopy_floatTo_boolean(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_boolean((Object)target, (long)targetOffset, (0.0f != Float.intBitsToFloat(Integer.reverseBytes(XMemory.get_int((long)sourceAddress))) ? 1 : 0) != 0);
        return sourceAddress + 4L;
    }

    public static long switchingCopy_floatTo_short(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_short((Object)target, (long)targetOffset, (short)Short.reverseBytes((short)Float.intBitsToFloat(Integer.reverseBytes(XMemory.get_int((long)sourceAddress)))));
        return sourceAddress + 4L;
    }

    public static long switchingCopy_floatTo_char(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_char((Object)target, (long)targetOffset, (char)Character.reverseBytes((char)Float.intBitsToFloat(Integer.reverseBytes(XMemory.get_int((long)sourceAddress)))));
        return sourceAddress + 4L;
    }

    public static long switchingCopy_floatTo_int(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_int((Object)target, (long)targetOffset, (int)Integer.reverseBytes((int)Float.intBitsToFloat(Integer.reverseBytes(XMemory.get_int((long)sourceAddress)))));
        return sourceAddress + 4L;
    }

    public static long switchingCopy_floatTo_long(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_long((Object)target, (long)targetOffset, (long)Long.reverseBytes((long)Float.intBitsToFloat(Integer.reverseBytes(XMemory.get_int((long)sourceAddress)))));
        return sourceAddress + 4L;
    }

    public static long switchingCopy_floatTo_double(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_long((Object)target, (long)targetOffset, (long)Long.reverseBytes(Double.doubleToRawLongBits(Float.intBitsToFloat(Integer.reverseBytes(XMemory.get_int((long)sourceAddress))))));
        return sourceAddress + 4L;
    }

    public static long switchingCopy_longTo_byte(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_byte((Object)target, (long)targetOffset, (byte)((byte)Long.reverseBytes(XMemory.get_long((long)sourceAddress))));
        return sourceAddress + (long)XMemory.byteSize_long();
    }

    public static long switchingCopy_longTo_boolean(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_boolean((Object)target, (long)targetOffset, (0L != Long.reverseBytes(XMemory.get_long((long)sourceAddress)) ? 1 : 0) != 0);
        return sourceAddress + (long)XMemory.byteSize_long();
    }

    public static long switchingCopy_longTo_short(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_short((Object)target, (long)targetOffset, (short)Short.reverseBytes((short)Long.reverseBytes(XMemory.get_long((long)sourceAddress))));
        return sourceAddress + (long)XMemory.byteSize_long();
    }

    public static long switchingCopy_longTo_char(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_char((Object)target, (long)targetOffset, (char)Character.reverseBytes((char)Long.reverseBytes(XMemory.get_long((long)sourceAddress))));
        return sourceAddress + (long)XMemory.byteSize_long();
    }

    public static long switchingCopy_longTo_int(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_int((Object)target, (long)targetOffset, (int)Integer.reverseBytes((int)Long.reverseBytes(XMemory.get_long((long)sourceAddress))));
        return sourceAddress + (long)XMemory.byteSize_long();
    }

    public static long switchingCopy_longTo_float(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_int((Object)target, (long)targetOffset, (int)Integer.reverseBytes(Float.floatToRawIntBits(Long.reverseBytes(XMemory.get_long((long)sourceAddress)))));
        return sourceAddress + (long)XMemory.byteSize_long();
    }

    public static long switchingCopy_longTo_double(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_long((Object)target, (long)targetOffset, (long)Long.reverseBytes(Double.doubleToRawLongBits(Long.reverseBytes(XMemory.get_long((long)sourceAddress)))));
        return sourceAddress + (long)XMemory.byteSize_long();
    }

    public static long switchingCopy_doubleTo_byte(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_byte((Object)target, (long)targetOffset, (byte)((byte)Double.longBitsToDouble(Long.reverseBytes(XMemory.get_long((long)sourceAddress)))));
        return sourceAddress + (long)XMemory.byteSize_double();
    }

    public static long switchingCopy_doubleTo_boolean(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_boolean((Object)target, (long)targetOffset, (0.0 != Double.longBitsToDouble(Long.reverseBytes(XMemory.get_long((long)sourceAddress))) ? 1 : 0) != 0);
        return sourceAddress + (long)XMemory.byteSize_double();
    }

    public static long switchingCopy_doubleTo_short(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_short((Object)target, (long)targetOffset, (short)Short.reverseBytes((short)Double.longBitsToDouble(Long.reverseBytes(XMemory.get_long((long)sourceAddress)))));
        return sourceAddress + (long)XMemory.byteSize_double();
    }

    public static long switchingCopy_doubleTo_char(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_char((Object)target, (long)targetOffset, (char)Character.reverseBytes((char)Double.longBitsToDouble(Long.reverseBytes(XMemory.get_long((long)sourceAddress)))));
        return sourceAddress + (long)XMemory.byteSize_double();
    }

    public static long switchingCopy_doubleTo_int(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_int((Object)target, (long)targetOffset, (int)Integer.reverseBytes((int)Double.longBitsToDouble(Long.reverseBytes(XMemory.get_long((long)sourceAddress)))));
        return sourceAddress + (long)XMemory.byteSize_double();
    }

    public static long switchingCopy_doubleTo_float(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_int((Object)target, (long)targetOffset, (int)Integer.reverseBytes(Float.floatToRawIntBits((float)Double.longBitsToDouble(Long.reverseBytes(XMemory.get_long((long)sourceAddress))))));
        return sourceAddress + (long)XMemory.byteSize_double();
    }

    public static long switchingCopy_doubleTo_long(long sourceAddress, Object target, long targetOffset, PersistenceLoadHandler handler) {
        XMemory.set_long((Object)target, (long)targetOffset, (long)Long.reverseBytes((long)Double.longBitsToDouble(Long.reverseBytes(XMemory.get_long((long)sourceAddress)))));
        return sourceAddress + (long)XMemory.byteSize_double();
    }
}

