/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.binary.internal;

import one.microstream.collections.types.XGettingSequence;
import one.microstream.persistence.binary.internal.AbstractBinaryHandlerCustomEnum;
import one.microstream.persistence.binary.internal.BinaryHandlerGenericEnum;
import one.microstream.persistence.binary.types.Binary;
import one.microstream.persistence.binary.types.BinaryPersistence;
import one.microstream.persistence.types.PersistenceLoadHandler;
import one.microstream.persistence.types.PersistenceReferenceLoader;
import one.microstream.persistence.types.PersistenceStoreHandler;
import one.microstream.persistence.types.PersistenceTypeDefinitionMember;
import one.microstream.persistence.types.PersistenceTypeDefinitionMemberEnumConstant;
import one.microstream.persistence.types.PersistenceTypeDefinitionMemberFieldGeneric;

public class BinaryHandlerCustomEnumTrivial<T extends Enum<T>>
extends AbstractBinaryHandlerCustomEnum<T> {
    private static final String JAVA_LANG_ENUM_FIELD_NAME_NAME = "name";
    private static final String JAVA_LANG_ENUM_FIELD_NAME_ORDINAL = "ordinal";
    private static final long BINARY_OFFSET_NAME = 0L;
    private static final long BINARY_OFFSET_ORDINAL = 0L + BinaryPersistence.resolveFieldBinaryLength(String.class);
    private static final long BINARY_LENGTH = BINARY_OFFSET_ORDINAL + BinaryPersistence.resolveFieldBinaryLength(Integer.TYPE);

    protected BinaryHandlerCustomEnumTrivial(Class<T> type) {
        this(type, BinaryHandlerCustomEnumTrivial.deriveTypeName(type));
    }

    protected BinaryHandlerCustomEnumTrivial(Class<T> type, String typeName) {
        super(type, typeName, (XGettingSequence<? extends PersistenceTypeDefinitionMemberEnumConstant>)BinaryHandlerGenericEnum.deriveEnumConstantMembers(type), (XGettingSequence<? extends PersistenceTypeDefinitionMember>)BinaryHandlerCustomEnumTrivial.CustomFields(new PersistenceTypeDefinitionMemberFieldGeneric[]{BinaryHandlerCustomEnumTrivial.CustomField(String.class, JAVA_LANG_ENUM_FIELD_NAME_NAME), BinaryHandlerCustomEnumTrivial.CustomField(Integer.TYPE, JAVA_LANG_ENUM_FIELD_NAME_ORDINAL)}));
    }

    protected static long getNameObjectId(Binary data) {
        return data.read_long(0L);
    }

    protected static int getOrdinalValue(Binary data) {
        return data.read_int(BINARY_OFFSET_ORDINAL);
    }

    @Override
    protected String getName(Binary data, PersistenceLoadHandler handler) {
        return (String)handler.lookupObject(BinaryHandlerCustomEnumTrivial.getNameObjectId(data));
    }

    @Override
    protected int getOrdinal(Binary data) {
        return BinaryHandlerCustomEnumTrivial.getOrdinalValue(data);
    }

    public boolean hasPersistedReferences() {
        return true;
    }

    public boolean hasVaryingPersistedLengthInstances() {
        return false;
    }

    @Override
    public void store(Binary data, T instance, long objectId, PersistenceStoreHandler<Binary> handler) {
        data.storeEntityHeader(BINARY_LENGTH, this.typeId(), objectId);
        data.store_long(0L, handler.apply((Object)((Enum)instance).name()));
        data.store_long(BINARY_OFFSET_ORDINAL, ((Enum)instance).ordinal());
    }

    public void iterateLoadableReferences(Binary data, PersistenceReferenceLoader iterator) {
        iterator.acceptObjectId(BinaryHandlerCustomEnumTrivial.getNameObjectId(data));
    }
}

