/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.binary.java.lang;

import one.microstream.collections.types.XGettingSequence;
import one.microstream.persistence.binary.internal.AbstractBinaryHandlerCustomValueFixedLength;
import one.microstream.persistence.binary.types.Binary;
import one.microstream.persistence.types.PersistenceLoadHandler;
import one.microstream.persistence.types.PersistenceStoreHandler;
import one.microstream.persistence.types.PersistenceTypeDefinitionMember;

public final class BinaryHandlerLong
extends AbstractBinaryHandlerCustomValueFixedLength<Long, Long> {
    public static BinaryHandlerLong New() {
        return new BinaryHandlerLong();
    }

    BinaryHandlerLong() {
        super(Long.class, (XGettingSequence<? extends PersistenceTypeDefinitionMember>)BinaryHandlerLong.defineValueType(Long.TYPE));
    }

    private static long instanceState(Long instance) {
        return instance;
    }

    private static long binaryState(Binary data) {
        return data.read_long(0L);
    }

    @Override
    public void store(Binary data, Long instance, long objectId, PersistenceStoreHandler<Binary> handler) {
        data.storeLong(this.typeId(), objectId, instance);
    }

    @Override
    public Long create(Binary data, PersistenceLoadHandler handler) {
        return data.buildLong();
    }

    @Override
    public Long getValidationStateFromInstance(Long instance) {
        return instance;
    }

    @Override
    public Long getValidationStateFromBinary(Binary data) {
        return BinaryHandlerLong.binaryState(data);
    }

    @Override
    public void validateState(Binary data, Long instance, PersistenceLoadHandler handler) {
        long binaryState;
        long instanceState = BinaryHandlerLong.instanceState(instance);
        if (instanceState == (binaryState = BinaryHandlerLong.binaryState(data))) {
            return;
        }
        this.throwInconsistentStateException(instance, instanceState, binaryState);
    }
}

