/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.binary.java.net;

import java.net.InetAddress;
import one.microstream.chars.XChars;
import one.microstream.collections.types.XGettingSequence;
import one.microstream.persistence.binary.exceptions.BinaryPersistenceException;
import one.microstream.persistence.binary.internal.AbstractBinaryHandlerCustomValueVariableLength;
import one.microstream.persistence.binary.types.Binary;
import one.microstream.persistence.types.PersistenceLoadHandler;
import one.microstream.persistence.types.PersistenceStoreHandler;
import one.microstream.persistence.types.PersistenceTypeDefinitionMemberFieldGeneric;

public abstract class AbstractBinaryHandlerInetAddress<A extends InetAddress>
extends AbstractBinaryHandlerCustomValueVariableLength<A, String> {
    static final int IPV4_BYTE_SIZE = 4;
    static final int IPV6_BYTE_SIZE = 16;
    static final int HEX_RADIX = 16;

    public static byte[] parseIpAddress(String ipAddress) {
        if (XChars.contains((String)ipAddress, (char)'.')) {
            if (!XChars.contains((String)ipAddress, (char)':')) {
                return AbstractBinaryHandlerInetAddress.parseIpV4Address(ipAddress);
            }
        } else if (XChars.contains((String)ipAddress, (char)':')) {
            return AbstractBinaryHandlerInetAddress.parseIpV6Address(ipAddress);
        }
        throw new BinaryPersistenceException("Unknown IP address pattern: \"" + ipAddress + '\"');
    }

    public static byte[] parseIpV4Address(String ipV4Address) {
        String[] parts = ipV4Address.split("\\.");
        try {
            if (parts.length != 4) {
                throw new IllegalArgumentException("An IPv4 address must be formed of 4 values separated by '.'.");
            }
            byte[] address = new byte[parts.length];
            int i = 0;
            while (i < parts.length) {
                address[i] = (byte)(Integer.parseInt(parts[i]) & 0xFF);
                ++i;
            }
            return address;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid IP V4 address: \"" + ipV4Address + '\"');
        }
    }

    public static byte[] parseIpV6Address(String ipV6Address) {
        String[] parts = ipV6Address.split("\\:");
        byte[] address = new byte[16];
        int i = 0;
        int a = 0;
        while (i < parts.length) {
            String p = parts[i];
            if (p.isEmpty()) {
                return AbstractBinaryHandlerInetAddress.parseRestOfIpV6AddressAfterOmittedZeroes(ipV6Address, parts, i + 1, address);
            }
            AbstractBinaryHandlerInetAddress.parsePart(p, address, a);
            a += 2;
            ++i;
        }
        return address;
    }

    private static void parsePart(String p, byte[] address, int a) {
        if (p.length() < 3) {
            address[a] = 0;
            address[a + 1] = (byte)(Integer.parseInt(p, 16) & 0xFF);
        } else {
            address[a] = (byte)(Integer.parseInt(p.substring(0, p.length() - 2), 16) & 0xFF);
            address[a + 1] = (byte)(Integer.parseInt(p.substring(p.length() - 2), 16) & 0xFF);
        }
    }

    private static byte[] parseRestOfIpV6AddressAfterOmittedZeroes(String ipV6Address, String[] parts, int partsIndex, byte[] address) {
        int a = 16 - (parts.length - partsIndex) * 2;
        int i = partsIndex;
        while (i < parts.length) {
            String p = parts[i];
            if (p.isEmpty()) {
                throw new IllegalArgumentException("Invalid IP V6 address: \"" + ipV6Address + '\"');
            }
            AbstractBinaryHandlerInetAddress.parsePart(p, address, a);
            a += 2;
            ++i;
        }
        return address;
    }

    AbstractBinaryHandlerInetAddress(Class<A> type) {
        super(type, (XGettingSequence<? extends PersistenceTypeDefinitionMemberFieldGeneric>)AbstractBinaryHandlerInetAddress.CustomFields(AbstractBinaryHandlerInetAddress.chars("address")));
    }

    private static String instanceState(InetAddress instance) {
        return instance.toString();
    }

    private static String binaryState(Binary data) {
        return data.buildString();
    }

    @Override
    public final void store(Binary data, A instance, long objectId, PersistenceStoreHandler<Binary> handler) {
        data.storeStringSingleValue(this.typeId(), objectId, AbstractBinaryHandlerInetAddress.instanceState(instance));
    }

    @Override
    public A create(Binary data, PersistenceLoadHandler handler) {
        String persistedString = AbstractBinaryHandlerInetAddress.binaryState(data);
        int slashIndex = persistedString.indexOf(47);
        String hostNamePart = slashIndex == 0 ? null : persistedString.substring(0, slashIndex);
        String addressPart = persistedString.substring(slashIndex + 1);
        return this.createInstance(hostNamePart, addressPart);
    }

    protected abstract A createInstance(String var1, String var2);

    @Override
    public String getValidationStateFromInstance(InetAddress instance) {
        return AbstractBinaryHandlerInetAddress.instanceState(instance);
    }

    @Override
    public String getValidationStateFromBinary(Binary data) {
        return AbstractBinaryHandlerInetAddress.binaryState(data);
    }
}

