/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.binary.internal;

import one.microstream.collections.BulkList;
import one.microstream.collections.ConstHashEnum;
import one.microstream.collections.types.XGettingCollection;
import one.microstream.collections.types.XGettingEnum;
import one.microstream.collections.types.XGettingSequence;
import one.microstream.persistence.binary.internal.AbstractBinaryHandlerCustom;
import one.microstream.persistence.binary.types.Binary;
import one.microstream.persistence.exceptions.PersistenceException;
import one.microstream.persistence.types.Persistence;
import one.microstream.persistence.types.PersistenceLoadHandler;
import one.microstream.persistence.types.PersistenceTypeDefinitionMember;
import one.microstream.persistence.types.PersistenceTypeDefinitionMemberEnumConstant;
import one.microstream.persistence.types.PersistenceTypeHandler;
import one.microstream.reflect.XReflect;

public abstract class AbstractBinaryHandlerCustomEnum<T extends Enum<T>>
extends AbstractBinaryHandlerCustom<T> {
    final ConstHashEnum<PersistenceTypeDefinitionMemberEnumConstant> constantMembers;
    final ConstHashEnum<PersistenceTypeDefinitionMember> allMembers;

    public static <T> Class<T> validateIsEnum(Class<T> type) {
        if (XReflect.isEnum(type)) {
            return type;
        }
        throw new IllegalArgumentException("Not an Enum type: " + type.getName());
    }

    protected AbstractBinaryHandlerCustomEnum(Class<T> type, XGettingSequence<? extends PersistenceTypeDefinitionMemberEnumConstant> constantMembers, XGettingSequence<? extends PersistenceTypeDefinitionMember> instanceMembers) {
        this(type, AbstractBinaryHandlerCustomEnum.deriveTypeName(type), constantMembers, instanceMembers);
    }

    protected AbstractBinaryHandlerCustomEnum(Class<T> type, String typeName, XGettingSequence<? extends PersistenceTypeDefinitionMemberEnumConstant> constantMembers, XGettingSequence<? extends PersistenceTypeDefinitionMember> instanceMembers) {
        super(AbstractBinaryHandlerCustomEnum.validateIsEnum(type), typeName, instanceMembers);
        this.constantMembers = ConstHashEnum.New(constantMembers);
        this.allMembers = ConstHashEnum.New((XGettingCollection)BulkList.New(constantMembers).addAll(instanceMembers));
    }

    public Object[] collectEnumConstants() {
        return Persistence.collectEnumConstants((PersistenceTypeHandler)this);
    }

    @Override
    public final XGettingEnum<? extends PersistenceTypeDefinitionMember> allMembers() {
        return this.allMembers;
    }

    protected abstract int getOrdinal(Binary var1);

    protected abstract String getName(Binary var1, PersistenceLoadHandler var2);

    @Override
    public T create(Binary data, PersistenceLoadHandler handler) {
        T[] jvmEnumConstants = XReflect.getDeclaredEnumClass((Class)this.type()).getEnumConstants();
        int persistentOrdinal = this.getOrdinal(data);
        Enum enumConstantinstance = (Enum)jvmEnumConstants[persistentOrdinal];
        return (T)enumConstantinstance;
    }

    protected void validate(Binary data, T instance, PersistenceLoadHandler handler) {
        int persistentOrdinal = this.getOrdinal(data);
        if (persistentOrdinal != ((Enum)instance).ordinal()) {
            throw new PersistenceException("Inconcistency for " + ((Enum)instance).getDeclaringClass().getName() + "." + ((Enum)instance).name());
        }
        String persistentName = this.getName(data, handler);
        if (!((Enum)instance).name().equals(persistentName)) {
            throw new PersistenceException("Enum constant inconsistency: in type " + this.type().getName() + " persisted instance with ordinal " + persistentOrdinal + ", name \"" + persistentName + "\" does not match JVM-created instance with ordinal " + ((Enum)instance).ordinal() + ", name \"" + ((Enum)instance).name() + "\"");
        }
    }

    public void updateState(Binary data, T instance, PersistenceLoadHandler handler) {
        this.validate(data, instance, handler);
    }
}

