/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.binary.internal;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.util.function.Predicate;
import one.microstream.collections.EqConstHashEnum;
import one.microstream.collections.EqHashEnum;
import one.microstream.collections.HashEnum;
import one.microstream.collections.types.XGettingCollection;
import one.microstream.collections.types.XGettingEnum;
import one.microstream.collections.types.XGettingSequence;
import one.microstream.collections.types.XImmutableEnum;
import one.microstream.persistence.binary.internal.AbstractBinaryHandlerReflective;
import one.microstream.persistence.binary.types.Binary;
import one.microstream.persistence.binary.types.BinaryValueFunctions;
import one.microstream.persistence.binary.types.BinaryValueSetter;
import one.microstream.persistence.exceptions.PersistenceException;
import one.microstream.persistence.types.Persistence;
import one.microstream.persistence.types.PersistenceEagerStoringFieldEvaluator;
import one.microstream.persistence.types.PersistenceFieldLengthResolver;
import one.microstream.persistence.types.PersistenceLoadHandler;
import one.microstream.persistence.types.PersistenceTypeDefinition;
import one.microstream.persistence.types.PersistenceTypeDefinitionMember;
import one.microstream.persistence.types.PersistenceTypeDefinitionMemberEnumConstant;
import one.microstream.persistence.types.PersistenceTypeDefinitionMemberFieldReflective;
import one.microstream.persistence.types.PersistenceTypeHandler;
import one.microstream.reflect.XReflect;
import one.microstream.typing.XTypes;

public final class BinaryHandlerGenericEnum<T extends Enum<T>>
extends AbstractBinaryHandlerReflective<T> {
    private final long binaryOffsetName;
    private final long binaryOffsetOrdinal;
    private XImmutableEnum<PersistenceTypeDefinitionMemberEnumConstant> enumConstants;
    private final XImmutableEnum<PersistenceTypeDefinitionMember> allMembers = this.deriveAllMembers((XGettingSequence<? extends PersistenceTypeDefinitionMember>)this.instanceMembers());

    public static boolean isJavaLangEnumMember(PersistenceTypeDefinitionMember member) {
        return member != null && Enum.class.getName().equals(member.runtimeQualifier());
    }

    public static boolean isJavaLangEnumName(PersistenceTypeDefinitionMember member) {
        return BinaryHandlerGenericEnum.isJavaLangEnumMember(member) && member.type() == String.class;
    }

    public static boolean isJavaLangEnumOrdinal(PersistenceTypeDefinitionMember member) {
        return BinaryHandlerGenericEnum.isJavaLangEnumMember(member) && member.type() == Integer.TYPE;
    }

    public static long calculateBinaryOffsetOrdinal(PersistenceTypeDefinition typeDefinition) {
        return BinaryHandlerGenericEnum.calculateBinaryOffset((XGettingCollection<? extends PersistenceTypeDefinitionMember>)typeDefinition.instanceMembers(), BinaryHandlerGenericEnum::isJavaLangEnumOrdinal);
    }

    public static long calculateBinaryOffsetName(PersistenceTypeDefinition typeDefinition) {
        return BinaryHandlerGenericEnum.calculateBinaryOffset((XGettingCollection<? extends PersistenceTypeDefinitionMember>)typeDefinition.instanceMembers(), BinaryHandlerGenericEnum::isJavaLangEnumName);
    }

    public static long calculateBinaryOffset(XGettingCollection<? extends PersistenceTypeDefinitionMember> fields, Predicate<? super PersistenceTypeDefinitionMember> fieldSelector) {
        long binaryOffset = 0L;
        for (PersistenceTypeDefinitionMember f : fields) {
            if (fieldSelector.test((PersistenceTypeDefinitionMember)f)) {
                return binaryOffset;
            }
            binaryOffset += BinaryHandlerGenericEnum.equal(f.persistentMinimumLength(), f.persistentMaximumLength());
        }
        throw new PersistenceException("Member not found in member list.");
    }

    public static XImmutableEnum<PersistenceTypeDefinitionMemberEnumConstant> deriveEnumConstantMembers(Class<?> enumType) {
        XReflect.validateIsEnum(enumType);
        HashEnum enumConstants = HashEnum.New();
        ?[] enumConstantsArray = enumType.getEnumConstants();
        if (enumConstantsArray != null) {
            for (Object enumInstance : enumConstantsArray) {
                enumConstants.add((Object)PersistenceTypeDefinitionMemberEnumConstant.New((String)((Enum)enumInstance).name()));
            }
        }
        return enumConstants.immure();
    }

    public static <T extends Enum<T>> BinaryHandlerGenericEnum<T> New(Class<T> type, String typeName, XGettingEnum<Field> persistableFields, XGettingEnum<Field> persisterFields, PersistenceFieldLengthResolver lengthResolver, PersistenceEagerStoringFieldEvaluator eagerStoringFieldEvaluator, boolean switchByteOrder) {
        return new BinaryHandlerGenericEnum<T>(type, typeName, persistableFields, persisterFields, lengthResolver, eagerStoringFieldEvaluator, switchByteOrder);
    }

    protected BinaryHandlerGenericEnum(Class<T> type, String typeName, XGettingEnum<Field> persistableFields, XGettingEnum<Field> persisterFields, PersistenceFieldLengthResolver lengthResolver, PersistenceEagerStoringFieldEvaluator eagerStoringFieldEvaluator, boolean switchByteOrder) {
        super(type, typeName, persistableFields, persisterFields, lengthResolver, eagerStoringFieldEvaluator, switchByteOrder);
        this.binaryOffsetName = BinaryHandlerGenericEnum.calculateBinaryOffsetName((PersistenceTypeDefinition)this);
        this.binaryOffsetOrdinal = BinaryHandlerGenericEnum.calculateBinaryOffsetOrdinal((PersistenceTypeDefinition)this);
    }

    @Override
    protected BinaryValueSetter deriveSetter(PersistenceTypeDefinitionMemberFieldReflective member) {
        return this.isUnsettableField(member) ? BinaryValueFunctions.getObjectValueSettingSkipper(member.type()) : BinaryValueFunctions.getObjectValueSetter(member.type(), this.isSwitchedByteOrder());
    }

    @Override
    protected EqConstHashEnum<PersistenceTypeDefinitionMember> deriveAllMembers(XGettingSequence<? extends PersistenceTypeDefinitionMember> instanceMembers) {
        EqHashEnum allMembers = BinaryHandlerGenericEnum.MemberEnum().addAll(this.enumConstants()).addAll(instanceMembers);
        return allMembers.immure();
    }

    public XImmutableEnum<PersistenceTypeDefinitionMemberEnumConstant> enumConstants() {
        if (this.enumConstants == null) {
            this.enumConstants = BinaryHandlerGenericEnum.deriveEnumConstantMembers(this.type());
        }
        return this.enumConstants;
    }

    protected final boolean isUnsettableField(PersistenceTypeDefinitionMemberFieldReflective m) {
        return this.isJavaLangEnumField(m) || this.isFinalPrimitiveField(m) || this.isFinalValueTypeField(m);
    }

    protected final boolean isJavaLangEnumField(PersistenceTypeDefinitionMemberFieldReflective m) {
        if (m.declaringClass() != Enum.class) {
            return false;
        }
        if (BinaryHandlerGenericEnum.isJavaLangEnumName((PersistenceTypeDefinitionMember)m) || BinaryHandlerGenericEnum.isJavaLangEnumOrdinal((PersistenceTypeDefinitionMember)m)) {
            return true;
        }
        throw new PersistenceException("Unknown " + Enum.class.getName() + " field: " + m.name());
    }

    protected final boolean isFinalPrimitiveField(PersistenceTypeDefinitionMemberFieldReflective m) {
        return XReflect.isFinal((Member)m.field()) && m.field().getType().isPrimitive();
    }

    protected final boolean isFinalValueTypeField(PersistenceTypeDefinitionMemberFieldReflective m) {
        return XReflect.isFinal((Member)m.field()) && XTypes.isValueType(m.field().getType());
    }

    @Override
    public final XGettingEnum<? extends PersistenceTypeDefinitionMember> allMembers() {
        return this.allMembers;
    }

    public Object[] collectEnumConstants() {
        return Persistence.collectEnumConstants((PersistenceTypeHandler)this);
    }

    @Override
    public final T create(Binary data, PersistenceLoadHandler handler) {
        return (T)((Enum)XReflect.resolveEnumConstantInstanceTyped((Class)this.type(), (int)this.getPersistedEnumOrdinal(data)));
    }

    public int getPersistedEnumOrdinal(Binary data) {
        return data.read_int(this.binaryOffsetOrdinal);
    }

    public String getName(Binary data, PersistenceLoadHandler handler) {
        return (String)handler.lookupObject(data.read_long(this.binaryOffsetName));
    }

    private void validate(Binary data, T instance, PersistenceLoadHandler handler) {
        int persistentOrdinal = this.getPersistedEnumOrdinal(data);
        if (persistentOrdinal != ((Enum)instance).ordinal()) {
            throw new PersistenceException("Inconcistency for " + ((Enum)instance).getDeclaringClass().getName() + "." + ((Enum)instance).name());
        }
        String persistentName = this.getName(data, handler);
        if (!((Enum)instance).name().equals(persistentName)) {
            throw new PersistenceException("Enum constant inconsistency: in type " + this.type().getName() + " persisted instance with ordinal " + persistentOrdinal + ", name \"" + persistentName + "\" does not match JVM-created instance with ordinal " + ((Enum)instance).ordinal() + ", name \"" + ((Enum)instance).name() + "\"");
        }
    }

    @Override
    public void updateState(Binary data, T instance, PersistenceLoadHandler handler) {
        this.validate(data, instance, handler);
        super.updateState(data, instance, handler);
    }
}

