/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.binary.one.microstream.collections.lazy;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import one.microstream.collections.lazy.LazyArrayList;
import one.microstream.collections.lazy.LazySegment;
import one.microstream.collections.lazy.LazySegmentUnloader;
import one.microstream.collections.types.XGettingSequence;
import one.microstream.memory.XMemory;
import one.microstream.persistence.binary.internal.AbstractBinaryHandlerCustomCollection;
import one.microstream.persistence.binary.types.Binary;
import one.microstream.persistence.types.PersistenceFunction;
import one.microstream.persistence.types.PersistenceLoadHandler;
import one.microstream.persistence.types.PersistenceReferenceLoader;
import one.microstream.persistence.types.PersistenceStoreHandler;
import one.microstream.persistence.types.PersistenceTypeDefinitionMemberFieldGeneric;
import one.microstream.persistence.types.PersistenceTypeDescriptionMemberFieldGeneric;
import one.microstream.reference.ControlledLazyReference;
import one.microstream.reflect.XReflect;

public final class BinaryHandlerLazyArrayList
extends AbstractBinaryHandlerCustomCollection<LazyArrayList<?>> {
    static final long BINARY_OFFSET_MAXSEGMENTSIZE = 0L;
    static final long BINARY_OFFSET_SIZE = 4L;
    static final long BINARY_OFFSET_UNLOADER = 8L;
    static final long BINARY_OFFSET_SEGMENTS = 8L + Binary.referenceBinaryLength(1L);
    private static final long OFFSET_MaxSegmentSize = BinaryHandlerLazyArrayList.getFieldOffset(LazyArrayList.class, "maxSegmentSize");
    private static final long OFFSET_ArrayList_size = BinaryHandlerLazyArrayList.getFieldOffset(LazyArrayList.class, "size");
    private static final long OFFSET_ArrayList_unloader = BinaryHandlerLazyArrayList.getFieldOffset(LazyArrayList.class, "unloader");
    private static final long OFFSET_Segment_offset = BinaryHandlerLazyArrayList.getFieldOffset(LazyArrayList.Segment.class, "offset");
    private static final long OFFSET_Segment_size = BinaryHandlerLazyArrayList.getFieldOffset(LazyArrayList.Segment.class, "segmentSize");
    private static final Method METHOD_Segment_getData = BinaryHandlerLazyArrayList.getDeclaredMethod(LazyArrayList.Segment.class, "getLazyData", new Class[0]);
    private static final Method METHOD_Segment_getLazy = BinaryHandlerLazyArrayList.getDeclaredMethod(LazyArrayList.Segment.class, "getLazy", new Class[0]);
    private static final Method METHOD_Segement_cleanDirtyFlag = BinaryHandlerLazyArrayList.getDeclaredMethod(LazyArrayList.Segment.class, "cleanModified", new Class[0]);
    private static final Method METHOD_LazyArrayList_addSegment = BinaryHandlerLazyArrayList.getDeclaredMethod(LazyArrayList.class, "addSegment", Integer.TYPE, Integer.TYPE, Object.class);

    private static Class<LazyArrayList<?>> handledType() {
        return LazyArrayList.class;
    }

    public static BinaryHandlerLazyArrayList New() {
        return new BinaryHandlerLazyArrayList();
    }

    public BinaryHandlerLazyArrayList() {
        super(BinaryHandlerLazyArrayList.handledType(), (XGettingSequence<? extends PersistenceTypeDefinitionMemberFieldGeneric>)BinaryHandlerLazyArrayList.CustomFields(new PersistenceTypeDefinitionMemberFieldGeneric[]{BinaryHandlerLazyArrayList.CustomField(Integer.TYPE, "maxSegmentSize"), BinaryHandlerLazyArrayList.CustomField(Integer.TYPE, "size"), BinaryHandlerLazyArrayList.CustomField(LazySegmentUnloader.class, "unloader"), BinaryHandlerLazyArrayList.Complex("segments", new PersistenceTypeDescriptionMemberFieldGeneric[]{BinaryHandlerLazyArrayList.CustomField(Integer.TYPE, "offset"), BinaryHandlerLazyArrayList.CustomField(Integer.TYPE, "size"), BinaryHandlerLazyArrayList.CustomField(ControlledLazyReference.class, "data")})}));
    }

    @Override
    public void store(Binary data, LazyArrayList<?> instance, long objectId, PersistenceStoreHandler<Binary> handler) {
        long fieldsLength = 8L + Binary.referenceBinaryLength(1L);
        long segmentLength = 8L + Binary.referenceBinaryLength(1L);
        long segmentListContentLength = segmentLength * instance.getSegmentCount();
        long segmentListTotalLength = Binary.toBinaryListTotalByteLength(segmentListContentLength);
        long totalLength = fieldsLength + segmentListTotalLength;
        data.storeEntityHeader(totalLength, this.typeId(), objectId);
        data.store_int(0L, instance.getMaxSegmentSize());
        data.store_int(4L, instance.size());
        data.store_long(8L, handler.apply(XMemory.getObject(instance, (long)OFFSET_ArrayList_unloader)));
        data.storeListHeader(BINARY_OFFSET_SEGMENTS, segmentListContentLength, instance.getSegmentCount());
        long elementsDataOffset = Binary.toBinaryListElementsOffset(BINARY_OFFSET_SEGMENTS);
        for (LazySegment segment : instance.segments()) {
            data.store_int(elementsDataOffset, XMemory.get_int((Object)segment, (long)OFFSET_Segment_offset));
            data.store_int(elementsDataOffset += 4L, XMemory.get_int((Object)segment, (long)OFFSET_Segment_size));
            data.store_long(elementsDataOffset += 4L, handler.apply(XReflect.invoke((Method)METHOD_Segment_getLazy, (Object)segment, (Object[])new Object[0])));
            elementsDataOffset += Binary.referenceBinaryLength(1L);
            if (!segment.isLoaded() || !segment.isModified()) continue;
            handler.applyEager(XReflect.invoke((Method)METHOD_Segment_getData, (Object)segment, (Object[])new Object[0]));
            XReflect.invoke((Method)METHOD_Segement_cleanDirtyFlag, (Object)segment, (Object[])new Object[0]);
        }
    }

    @Override
    public LazyArrayList<?> create(Binary data, PersistenceLoadHandler handler) {
        return new LazyArrayList();
    }

    public void updateState(Binary data, LazyArrayList<?> instance, PersistenceLoadHandler handler) {
        int maxSegmentSize = data.read_int(0L);
        XMemory.set_int(instance, (long)OFFSET_MaxSegmentSize, (int)maxSegmentSize);
        int size = data.read_int(4L);
        XMemory.set_int(instance, (long)OFFSET_ArrayList_size, (int)size);
        long unloderId = data.read_long(8L);
        Object unloader = handler.lookupObject(unloderId);
        XMemory.setObject(instance, (long)OFFSET_ArrayList_unloader, (Object)unloader);
        int segmentCount = (int)data.getBinaryListElementCountValidating(BINARY_OFFSET_SEGMENTS, 16L);
        long elementsDataOffset = Binary.toBinaryListElementsOffset(BINARY_OFFSET_SEGMENTS);
        for (int i = 0; i < segmentCount; ++i) {
            int segmentOffset = data.read_int(elementsDataOffset);
            int segmentSize = data.read_int(elementsDataOffset += 4L);
            long refId = data.read_long(elementsDataOffset += 4L);
            elementsDataOffset += Binary.referenceBinaryLength(1L);
            Object ref = handler.lookupObject(refId);
            XReflect.invoke((Method)METHOD_LazyArrayList_addSegment, instance, (Object[])new Object[]{segmentOffset, segmentSize, ref});
        }
    }

    @Override
    public void iterateInstanceReferences(LazyArrayList<?> instance, PersistenceFunction iterator) {
        super.iterateInstanceReferences(instance, iterator);
    }

    public void iterateLoadableReferences(Binary data, PersistenceReferenceLoader iterator) {
        Binary.iterateListStructureCompositeElements(data, BINARY_OFFSET_SEGMENTS, 8, 1, 0, iterator);
        iterator.acceptObjectId(data.read_long(8L));
    }

    private static final long getFieldOffset(Class<?> type, String declaredFieldName) {
        return XMemory.objectFieldOffset((Field)XReflect.getAnyField(type, (String)declaredFieldName));
    }

    private static final Method getDeclaredMethod(Class<?> c, String name, Class<?> ... parameterTypes) {
        return XReflect.setAccessible((Method)XReflect.getDeclaredMethod(c, (String)name, (Class[])parameterTypes));
    }
}

