/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.binary.one.microstream.collections.lazy;

import one.microstream.X;
import one.microstream.collections.lazy.LazyHashMap;
import one.microstream.collections.types.XGettingSequence;
import one.microstream.persistence.binary.internal.AbstractBinaryHandlerCustomIterable;
import one.microstream.persistence.binary.types.Binary;
import one.microstream.persistence.types.PersistenceLoadHandler;
import one.microstream.persistence.types.PersistenceReferenceLoader;
import one.microstream.persistence.types.PersistenceStoreHandler;
import one.microstream.persistence.types.PersistenceTypeDefinitionMemberFieldGeneric;
import one.microstream.persistence.types.PersistenceTypeDescriptionMemberFieldGeneric;

public final class BinaryHandlerLazyHashMapSegmentEntryList
extends AbstractBinaryHandlerCustomIterable<LazyHashMap.LazyHashMapSegmentEntryList<?, ?>> {
    static final long ENTRY_LENGHT = Binary.referenceBinaryLength(2L) + 4L;
    static final long BINARY_OFFSET_ELEMENTS = 0L;

    private static Class<LazyHashMap.LazyHashMapSegmentEntryList<?, ?>> handledType() {
        return LazyHashMap.LazyHashMapSegmentEntryList.class;
    }

    public static BinaryHandlerLazyHashMapSegmentEntryList New() {
        return new BinaryHandlerLazyHashMapSegmentEntryList();
    }

    public BinaryHandlerLazyHashMapSegmentEntryList() {
        super(BinaryHandlerLazyHashMapSegmentEntryList.handledType(), (XGettingSequence<? extends PersistenceTypeDefinitionMemberFieldGeneric>)BinaryHandlerLazyHashMapSegmentEntryList.CustomFields(new PersistenceTypeDefinitionMemberFieldGeneric[]{BinaryHandlerLazyHashMapSegmentEntryList.Complex("segments", new PersistenceTypeDescriptionMemberFieldGeneric[]{BinaryHandlerLazyHashMapSegmentEntryList.CustomField(Integer.TYPE, "hash"), BinaryHandlerLazyHashMapSegmentEntryList.CustomField(Object.class, "key"), BinaryHandlerLazyHashMapSegmentEntryList.CustomField(Object.class, "value")})}));
    }

    public void iterateLoadableReferences(Binary data, PersistenceReferenceLoader iterator) {
        Binary.iterateListStructureCompositeElements(data, 0L, 4, 2, 0, iterator);
    }

    @Override
    public void complete(Binary data, LazyHashMap.LazyHashMapSegmentEntryList<?, ?> instance, PersistenceLoadHandler handler) {
        int elementCount = this.getElementCount(data);
        long offset = Binary.toBinaryListElementsOffset(0L);
        for (int i = 0; i < elementCount; ++i) {
            int hash = data.read_int(offset);
            long keyId = data.read_long(offset += 4L);
            long valueId = data.read_long(offset += Binary.referenceBinaryLength(1L));
            offset += Binary.referenceBinaryLength(1L);
            Object key = handler.lookupObject(keyId);
            Object value = handler.lookupObject(valueId);
            instance.addEntry(hash, key, value);
        }
    }

    public void updateState(Binary data, LazyHashMap.LazyHashMapSegmentEntryList<?, ?> instance, PersistenceLoadHandler handler) {
    }

    @Override
    public void store(Binary data, LazyHashMap.LazyHashMapSegmentEntryList<?, ?> instance, long objectId, PersistenceStoreHandler<Binary> handler) {
        long elementsBinaryRange = (long)instance.size() * ENTRY_LENGHT;
        long elementsCount = instance.size();
        data.storeEntityHeader(0L + Binary.toBinaryListTotalByteLength(ENTRY_LENGHT * elementsCount), this.typeId(), objectId);
        data.storeListHeader(0L, elementsBinaryRange, elementsCount);
        long referenceLength = Binary.referenceBinaryLength(1L);
        long offset = Binary.toBinaryListElementsOffset(0L);
        for (LazyHashMap.Entry entry : instance) {
            data.store_int(offset, entry.getHash());
            data.store_long(offset += 4L, handler.apply(entry.getKey()));
            data.store_long(offset += referenceLength, handler.apply(entry.getValue()));
            offset += referenceLength;
        }
    }

    @Override
    public LazyHashMap.LazyHashMapSegmentEntryList<?, ?> create(Binary data, PersistenceLoadHandler handler) {
        int elementCount = this.getElementCount(data);
        return new LazyHashMap.LazyHashMapSegmentEntryList(elementCount);
    }

    private int getElementCount(Binary data) {
        return X.checkArrayRange((long)data.getBinaryListElementCountValidating(0L, ENTRY_LENGHT));
    }
}

