/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.binary.types;

import one.microstream.chars.XChars;
import one.microstream.math.XMath;
import one.microstream.persistence.binary.exceptions.BinaryPersistenceException;
import one.microstream.persistence.binary.internal.AbstractBinaryHandlerCustom;
import one.microstream.persistence.binary.types.Binary;
import one.microstream.persistence.types.PersistenceFunction;
import one.microstream.persistence.types.PersistenceLoadHandler;
import one.microstream.persistence.types.PersistenceReferenceLoader;
import one.microstream.persistence.types.PersistenceStoreHandler;
import one.microstream.persistence.types.PersistenceTypeDefinitionMember;
import one.microstream.persistence.types.PersistenceTypeDefinitionMemberCreator;
import one.microstream.persistence.types.PersistenceTypeDefinitionMemberFieldGeneric;
import one.microstream.persistence.types.PersistenceTypeDefinitionMemberFieldGenericSimple;
import one.microstream.persistence.types.PersistenceTypeDescriptionMemberAppender;
import one.microstream.reflect.Getter;
import one.microstream.reflect.Getter_boolean;
import one.microstream.reflect.Getter_byte;
import one.microstream.reflect.Getter_char;
import one.microstream.reflect.Getter_double;
import one.microstream.reflect.Getter_float;
import one.microstream.reflect.Getter_int;
import one.microstream.reflect.Getter_long;
import one.microstream.reflect.Getter_short;
import one.microstream.reflect.Setter;
import one.microstream.reflect.Setter_boolean;
import one.microstream.reflect.Setter_byte;
import one.microstream.reflect.Setter_char;
import one.microstream.reflect.Setter_double;
import one.microstream.reflect.Setter_float;
import one.microstream.reflect.Setter_int;
import one.microstream.reflect.Setter_long;
import one.microstream.reflect.Setter_short;

public interface BinaryField<T>
extends PersistenceTypeDefinitionMemberFieldGeneric {
    public Class<?> type();

    public String name();

    default public BinaryField<T> copyForName(String name) {
        return this.copyForName(this.qualifier(), name);
    }

    public BinaryField<T> copyForName(String var1, String var2);

    public void storeFromInstance(T var1, Binary var2, PersistenceStoreHandler<Binary> var3);

    public void setToInstance(T var1, Binary var2, PersistenceLoadHandler var3);

    public void validateState(T var1, Binary var2, PersistenceLoadHandler var3);

    public boolean canSet();

    default public <F extends PersistenceFunction> F iterateReferences(Object instance, F iterator) {
        return iterator;
    }

    default public <L extends PersistenceReferenceLoader> L iterateLoadableReferences(Binary data, L loader) {
        return loader;
    }

    public long calculateBinaryLength(T var1);

    default public byte read_byte(Binary data) {
        throw new UnsupportedOperationException();
    }

    default public boolean read_boolean(Binary data) {
        throw new UnsupportedOperationException();
    }

    default public short read_short(Binary data) {
        throw new UnsupportedOperationException();
    }

    default public char read_char(Binary data) {
        throw new UnsupportedOperationException();
    }

    default public int read_int(Binary data) {
        throw new UnsupportedOperationException();
    }

    default public float read_float(Binary data) {
        throw new UnsupportedOperationException();
    }

    default public long read_long(Binary data) {
        throw new UnsupportedOperationException();
    }

    default public double read_double(Binary data) {
        throw new UnsupportedOperationException();
    }

    default public Object readReference(Binary data, PersistenceLoadHandler handler) {
        throw new UnsupportedOperationException();
    }

    public static final class DefaultReference<T, R>
    extends Abstract<T> {
        private final Class<R> type;
        private final Getter<T, R> getter;
        private final Setter<T, R> setter;

        DefaultReference(Class<R> referenceType, String name, Getter<T, R> getter, Setter<T, R> setter) {
            super(referenceType, name);
            this.type = referenceType;
            this.getter = getter;
            this.setter = setter;
        }

        DefaultReference(Class<R> type, PersistenceTypeDefinitionMemberFieldGeneric actual, long offset, Getter<T, R> getter, Setter<T, R> setter) {
            super(actual, offset);
            this.type = type;
            this.getter = getter;
            this.setter = setter;
        }

        @Override
        public final long calculateBinaryLength(T instance) {
            return Binary.objectIdByteLength();
        }

        @Override
        public final BinaryField<T> copyForName(String qualifier, String name) {
            PersistenceTypeDefinitionMemberFieldGeneric memberCopy = this.actual().copyForName(qualifier, name);
            return new DefaultReference<T, R>(this.type, memberCopy, this.binaryOffset(), this.getter, this.setter);
        }

        @Override
        public final void storeFromInstance(T instance, Binary data, PersistenceStoreHandler<Binary> handler) {
            Object reference = this.getter.get(instance);
            long objectId = handler.apply(reference);
            data.store_long(this.binaryOffset(), objectId);
        }

        @Override
        public final R readReference(Binary data, PersistenceLoadHandler handler) {
            long objectId = data.read_long(this.binaryOffset());
            R reference = this.type.cast(handler.lookupObject(objectId));
            return reference;
        }

        @Override
        public final boolean canSet() {
            return this.setter != null;
        }

        @Override
        public final void setToInstance(T instance, Binary data, PersistenceLoadHandler handler) {
            R reference = this.readReference(data, handler);
            this.setter.set(instance, reference);
        }

        @Override
        public final <F extends PersistenceFunction> F iterateReferences(Object instance, F iterator) {
            Object reference = this.getter.get(instance);
            iterator.apply(reference);
            return iterator;
        }

        @Override
        public final <L extends PersistenceReferenceLoader> L iterateLoadableReferences(Binary data, L loader) {
            long objectId = data.read_long(this.binaryOffset());
            loader.acceptObjectId(objectId);
            return loader;
        }

        @Override
        public final void validateState(T instance, Binary data, PersistenceLoadHandler handler) {
            Object instanceValue = this.getter.get(instance);
            R persistedValue = this.readReference(data, handler);
            if (persistedValue == instanceValue) {
                return;
            }
            this.throwValidationException(XChars.systemString((Object)instanceValue), XChars.systemString(persistedValue));
        }
    }

    public static final class Default_double<T>
    extends Abstract<T> {
        private final Getter_double<T> getter;
        private final Setter_double<T> setter;

        Default_double(String name, Getter_double<T> getter, Setter_double<T> setter) {
            super(Double.TYPE, name);
            this.getter = getter;
            this.setter = setter;
        }

        Default_double(PersistenceTypeDefinitionMemberFieldGeneric actual, long offset, Getter_double<T> getter, Setter_double<T> setter) {
            super(actual, offset);
            this.getter = getter;
            this.setter = setter;
        }

        @Override
        public final long calculateBinaryLength(T instance) {
            return 8L;
        }

        @Override
        public final BinaryField<T> copyForName(String qualifier, String name) {
            PersistenceTypeDefinitionMemberFieldGeneric memberCopy = this.actual().copyForName(qualifier, name);
            return new Default_double<T>(memberCopy, this.binaryOffset(), this.getter, this.setter);
        }

        @Override
        public final void storeFromInstance(T instance, Binary data, PersistenceStoreHandler<Binary> handler) {
            double value = this.getter.get_double(instance);
            data.store_double(this.binaryOffset(), value);
        }

        @Override
        public final double read_double(Binary data) {
            return data.read_double(this.binaryOffset());
        }

        @Override
        public final boolean canSet() {
            return this.setter != null;
        }

        @Override
        public final void setToInstance(T instance, Binary data, PersistenceLoadHandler handler) {
            double value = this.read_double(data);
            this.setter.set_double(instance, value);
        }

        @Override
        public final void validateState(T instance, Binary data, PersistenceLoadHandler handler) {
            double instanceValue = this.getter.get_double(instance);
            double persistedValue = this.read_double(data);
            if (persistedValue == instanceValue) {
                return;
            }
            this.throwValidationException(String.valueOf(instanceValue), String.valueOf(persistedValue));
        }
    }

    public static final class Default_long<T>
    extends Abstract<T> {
        private final Getter_long<T> getter;
        private final Setter_long<T> setter;

        Default_long(String name, Getter_long<T> getter, Setter_long<T> setter) {
            super(Long.TYPE, name);
            this.getter = getter;
            this.setter = setter;
        }

        Default_long(PersistenceTypeDefinitionMemberFieldGeneric actual, long offset, Getter_long<T> getter, Setter_long<T> setter) {
            super(actual, offset);
            this.getter = getter;
            this.setter = setter;
        }

        @Override
        public final long calculateBinaryLength(T instance) {
            return 8L;
        }

        @Override
        public final BinaryField<T> copyForName(String qualifier, String name) {
            PersistenceTypeDefinitionMemberFieldGeneric memberCopy = this.actual().copyForName(qualifier, name);
            return new Default_long<T>(memberCopy, this.binaryOffset(), this.getter, this.setter);
        }

        @Override
        public final void storeFromInstance(T instance, Binary data, PersistenceStoreHandler<Binary> handler) {
            long value = this.getter.get_long(instance);
            data.store_long(this.binaryOffset(), value);
        }

        @Override
        public final long read_long(Binary data) {
            return data.read_long(this.binaryOffset());
        }

        @Override
        public final boolean canSet() {
            return this.setter != null;
        }

        @Override
        public final void setToInstance(T instance, Binary data, PersistenceLoadHandler handler) {
            long value = this.read_long(data);
            this.setter.set_long(instance, value);
        }

        @Override
        public final void validateState(T instance, Binary data, PersistenceLoadHandler handler) {
            long instanceValue = this.getter.get_long(instance);
            long persistedValue = this.read_long(data);
            if (persistedValue == instanceValue) {
                return;
            }
            this.throwValidationException(String.valueOf(instanceValue), String.valueOf(persistedValue));
        }
    }

    public static final class Default_float<T>
    extends Abstract<T> {
        private final Getter_float<T> getter;
        private final Setter_float<T> setter;

        Default_float(String name, Getter_float<T> getter, Setter_float<T> setter) {
            super(Float.TYPE, name);
            this.getter = getter;
            this.setter = setter;
        }

        Default_float(PersistenceTypeDefinitionMemberFieldGeneric actual, long offset, Getter_float<T> getter, Setter_float<T> setter) {
            super(actual, offset);
            this.getter = getter;
            this.setter = setter;
        }

        @Override
        public final long calculateBinaryLength(T instance) {
            return 4L;
        }

        @Override
        public final BinaryField<T> copyForName(String qualifier, String name) {
            PersistenceTypeDefinitionMemberFieldGeneric memberCopy = this.actual().copyForName(qualifier, name);
            return new Default_float<T>(memberCopy, this.binaryOffset(), this.getter, this.setter);
        }

        @Override
        public final void storeFromInstance(T instance, Binary data, PersistenceStoreHandler<Binary> handler) {
            float value = this.getter.get_float(instance);
            data.store_float(this.binaryOffset(), value);
        }

        @Override
        public final float read_float(Binary data) {
            return data.read_float(this.binaryOffset());
        }

        @Override
        public final boolean canSet() {
            return this.setter != null;
        }

        @Override
        public final void setToInstance(T instance, Binary data, PersistenceLoadHandler handler) {
            float value = this.read_float(data);
            this.setter.set_float(instance, value);
        }

        @Override
        public final void validateState(T instance, Binary data, PersistenceLoadHandler handler) {
            float instanceValue = this.getter.get_float(instance);
            float persistedValue = this.read_float(data);
            if (persistedValue == instanceValue) {
                return;
            }
            this.throwValidationException(String.valueOf(instanceValue), String.valueOf(persistedValue));
        }
    }

    public static final class Default_int<T>
    extends Abstract<T> {
        private final Getter_int<T> getter;
        private final Setter_int<T> setter;

        Default_int(String name, Getter_int<T> getter, Setter_int<T> setter) {
            super(Integer.TYPE, name);
            this.getter = getter;
            this.setter = setter;
        }

        Default_int(PersistenceTypeDefinitionMemberFieldGeneric actual, long offset, Getter_int<T> getter, Setter_int<T> setter) {
            super(actual, offset);
            this.getter = getter;
            this.setter = setter;
        }

        @Override
        public final long calculateBinaryLength(T instance) {
            return 4L;
        }

        @Override
        public final BinaryField<T> copyForName(String qualifier, String name) {
            PersistenceTypeDefinitionMemberFieldGeneric memberCopy = this.actual().copyForName(qualifier, name);
            return new Default_int<T>(memberCopy, this.binaryOffset(), this.getter, this.setter);
        }

        @Override
        public final void storeFromInstance(T instance, Binary data, PersistenceStoreHandler<Binary> handler) {
            int value = this.getter.get_int(instance);
            data.store_int(this.binaryOffset(), value);
        }

        @Override
        public final int read_int(Binary data) {
            return data.read_int(this.binaryOffset());
        }

        @Override
        public final boolean canSet() {
            return this.setter != null;
        }

        @Override
        public final void setToInstance(T instance, Binary data, PersistenceLoadHandler handler) {
            int value = this.read_int(data);
            this.setter.set_int(instance, value);
        }

        @Override
        public final void validateState(T instance, Binary data, PersistenceLoadHandler handler) {
            int instanceValue = this.getter.get_int(instance);
            int persistedValue = this.read_int(data);
            if (persistedValue == instanceValue) {
                return;
            }
            this.throwValidationException(String.valueOf(instanceValue), String.valueOf(persistedValue));
        }
    }

    public static final class Default_char<T>
    extends Abstract<T> {
        private final Getter_char<T> getter;
        private final Setter_char<T> setter;

        Default_char(String name, Getter_char<T> getter, Setter_char<T> setter) {
            super(Character.TYPE, name);
            this.getter = getter;
            this.setter = setter;
        }

        Default_char(PersistenceTypeDefinitionMemberFieldGeneric actual, long offset, Getter_char<T> getter, Setter_char<T> setter) {
            super(actual, offset);
            this.getter = getter;
            this.setter = setter;
        }

        @Override
        public final long calculateBinaryLength(T instance) {
            return 2L;
        }

        @Override
        public final BinaryField<T> copyForName(String qualifier, String name) {
            PersistenceTypeDefinitionMemberFieldGeneric memberCopy = this.actual().copyForName(qualifier, name);
            return new Default_char<T>(memberCopy, this.binaryOffset(), this.getter, this.setter);
        }

        @Override
        public final void storeFromInstance(T instance, Binary data, PersistenceStoreHandler<Binary> handler) {
            char value = this.getter.get_char(instance);
            data.store_char(this.binaryOffset(), value);
        }

        @Override
        public final char read_char(Binary data) {
            return data.read_char(this.binaryOffset());
        }

        @Override
        public final boolean canSet() {
            return this.setter != null;
        }

        @Override
        public final void setToInstance(T instance, Binary data, PersistenceLoadHandler handler) {
            char value = this.read_char(data);
            this.setter.set_char(instance, value);
        }

        @Override
        public final void validateState(T instance, Binary data, PersistenceLoadHandler handler) {
            char instanceValue = this.getter.get_char(instance);
            char persistedValue = this.read_char(data);
            if (persistedValue == instanceValue) {
                return;
            }
            this.throwValidationException(String.valueOf(instanceValue), String.valueOf(persistedValue));
        }
    }

    public static final class Default_short<T>
    extends Abstract<T> {
        private final Getter_short<T> getter;
        private final Setter_short<T> setter;

        Default_short(String name, Getter_short<T> getter, Setter_short<T> setter) {
            super(Short.TYPE, name);
            this.getter = getter;
            this.setter = setter;
        }

        Default_short(PersistenceTypeDefinitionMemberFieldGeneric actual, long offset, Getter_short<T> getter, Setter_short<T> setter) {
            super(actual, offset);
            this.getter = getter;
            this.setter = setter;
        }

        @Override
        public final long calculateBinaryLength(T instance) {
            return 2L;
        }

        @Override
        public final BinaryField<T> copyForName(String qualifier, String name) {
            PersistenceTypeDefinitionMemberFieldGeneric memberCopy = this.actual().copyForName(qualifier, name);
            return new Default_short<T>(memberCopy, this.binaryOffset(), this.getter, this.setter);
        }

        @Override
        public final void storeFromInstance(T instance, Binary data, PersistenceStoreHandler<Binary> handler) {
            short value = this.getter.get_short(instance);
            data.store_short(this.binaryOffset(), value);
        }

        @Override
        public final short read_short(Binary data) {
            return data.read_short(this.binaryOffset());
        }

        @Override
        public final boolean canSet() {
            return this.setter != null;
        }

        @Override
        public final void setToInstance(T instance, Binary data, PersistenceLoadHandler handler) {
            short value = this.read_short(data);
            this.setter.set_short(instance, value);
        }

        @Override
        public final void validateState(T instance, Binary data, PersistenceLoadHandler handler) {
            short instanceValue = this.getter.get_short(instance);
            short persistedValue = this.read_short(data);
            if (persistedValue == instanceValue) {
                return;
            }
            this.throwValidationException(String.valueOf(instanceValue), String.valueOf(persistedValue));
        }
    }

    public static final class Default_boolean<T>
    extends Abstract<T> {
        private final Getter_boolean<T> getter;
        private final Setter_boolean<T> setter;

        Default_boolean(String name, Getter_boolean<T> getter, Setter_boolean<T> setter) {
            super(Boolean.TYPE, name);
            this.getter = getter;
            this.setter = setter;
        }

        Default_boolean(PersistenceTypeDefinitionMemberFieldGeneric actual, long offset, Getter_boolean<T> getter, Setter_boolean<T> setter) {
            super(actual, offset);
            this.getter = getter;
            this.setter = setter;
        }

        @Override
        public final long calculateBinaryLength(T instance) {
            return 1L;
        }

        @Override
        public final BinaryField<T> copyForName(String qualifier, String name) {
            PersistenceTypeDefinitionMemberFieldGeneric memberCopy = this.actual().copyForName(qualifier, name);
            return new Default_boolean<T>(memberCopy, this.binaryOffset(), this.getter, this.setter);
        }

        @Override
        public final void storeFromInstance(T instance, Binary data, PersistenceStoreHandler<Binary> handler) {
            boolean value = this.getter.get_boolean(instance);
            data.store_boolean(this.binaryOffset(), value);
        }

        @Override
        public final boolean read_boolean(Binary data) {
            return data.read_boolean(this.binaryOffset());
        }

        @Override
        public final boolean canSet() {
            return this.setter != null;
        }

        @Override
        public final void setToInstance(T instance, Binary data, PersistenceLoadHandler handler) {
            boolean value = this.read_boolean(data);
            this.setter.set_boolean(instance, value);
        }

        @Override
        public final void validateState(T instance, Binary data, PersistenceLoadHandler handler) {
            boolean instanceValue = this.getter.get_boolean(instance);
            boolean persistedValue = this.read_boolean(data);
            if (persistedValue == instanceValue) {
                return;
            }
            this.throwValidationException(String.valueOf(instanceValue), String.valueOf(persistedValue));
        }
    }

    public static final class Default_byte<T>
    extends Abstract<T> {
        private final Getter_byte<T> getter;
        private final Setter_byte<T> setter;

        Default_byte(String name, Getter_byte<T> getter, Setter_byte<T> setter) {
            super(Byte.TYPE, name);
            this.getter = getter;
            this.setter = setter;
        }

        Default_byte(PersistenceTypeDefinitionMemberFieldGeneric actual, long offset, Getter_byte<T> getter, Setter_byte<T> setter) {
            super(actual, offset);
            this.getter = getter;
            this.setter = setter;
        }

        @Override
        public final long calculateBinaryLength(T instance) {
            return 1L;
        }

        @Override
        public final BinaryField<T> copyForName(String qualifier, String name) {
            PersistenceTypeDefinitionMemberFieldGeneric memberCopy = this.actual().copyForName(qualifier, name);
            return new Default_byte<T>(memberCopy, this.binaryOffset(), this.getter, this.setter);
        }

        @Override
        public final void storeFromInstance(T instance, Binary data, PersistenceStoreHandler<Binary> handler) {
            byte value = this.getter.get_byte(instance);
            data.store_byte(this.binaryOffset(), value);
        }

        @Override
        public final byte read_byte(Binary data) {
            return data.read_byte(this.binaryOffset());
        }

        @Override
        public final boolean canSet() {
            return this.setter != null;
        }

        @Override
        public final void setToInstance(T instance, Binary data, PersistenceLoadHandler handler) {
            byte value = this.read_byte(data);
            this.setter.set_byte(instance, value);
        }

        @Override
        public final void validateState(T instance, Binary data, PersistenceLoadHandler handler) {
            byte instanceValue = this.getter.get_byte(instance);
            byte persistedValue = this.read_byte(data);
            if (persistedValue == instanceValue) {
                return;
            }
            this.throwValidationException(String.valueOf(instanceValue), String.valueOf(persistedValue));
        }
    }

    public static abstract class Abstract<T>
    implements Initializable<T> {
        static final String NAME_UNINITIALIZED = "[Uninitialized " + BinaryField.class.getSimpleName() + "]";
        private PersistenceTypeDefinitionMemberFieldGeneric actual;
        private long offset;

        static PersistenceTypeDefinitionMemberFieldGeneric defineField(Class<?> type, String name) {
            PersistenceTypeDefinitionMemberFieldGenericSimple field = AbstractBinaryHandlerCustom.CustomField(type, name);
            return field;
        }

        protected Abstract(Class<?> type) {
            this(type, Defaults.defaultUninitializedName());
        }

        protected Abstract(Class<?> type, String name) {
            this(Abstract.defineField(type, name), Defaults.defaultUninitializedOffset());
        }

        protected Abstract(PersistenceTypeDefinitionMemberFieldGeneric actual, long offset) {
            this.actual = actual;
            this.offset = offset;
        }

        @Override
        public final long initializeOffset(long offset) {
            if (this.offset >= 0L) {
                if (this.offset == offset) {
                    return offset;
                }
                throw new BinaryPersistenceException("Offset already assigned: " + this.offset + ". Passed: " + offset);
            }
            this.offset = XMath.notNegative((long)offset);
            return this.offset;
        }

        public final long binaryOffset() {
            return this.offset;
        }

        protected final PersistenceTypeDefinitionMemberFieldGeneric actual() {
            return this.actual;
        }

        @Override
        public final String initializeIdentifier(String qualifier, String name) {
            String currentName = this.actual.name();
            if (!currentName.equals(Defaults.defaultUninitializedName())) {
                if (currentName.equals(name)) {
                    return currentName;
                }
                throw new BinaryPersistenceException("Name already initialized: current name \"" + currentName + "\" != \"" + name + "\"");
            }
            this.actual = this.actual.copyForName(name);
            return this.actual.name();
        }

        @Override
        public final Class<?> type() {
            return this.actual.type();
        }

        public final String typeName() {
            return this.actual.typeName();
        }

        public final String qualifier() {
            return this.actual.qualifier();
        }

        @Override
        public final String name() {
            return this.actual.name();
        }

        public final String identifier() {
            return this.actual.identifier();
        }

        public final void assembleTypeDescription(PersistenceTypeDescriptionMemberAppender assembler) {
            this.actual.assembleTypeDescription(assembler);
        }

        public final boolean isReference() {
            return this.actual.isReference();
        }

        public final boolean isPrimitive() {
            return this.actual.isPrimitive();
        }

        public final boolean isPrimitiveDefinition() {
            return this.actual.isPrimitiveDefinition();
        }

        public final boolean isEnumConstant() {
            return this.actual.isEnumConstant();
        }

        public final boolean hasReferences() {
            return this.actual.hasReferences();
        }

        public final long persistentMinimumLength() {
            return this.actual.persistentMinimumLength();
        }

        public final long persistentMaximumLength() {
            return this.actual.persistentMaximumLength();
        }

        public final boolean isValidPersistentLength(long persistentLength) {
            return this.actual.isValidPersistentLength(persistentLength);
        }

        public final void validatePersistentLength(long persistentLength) {
            this.actual.validatePersistentLength(persistentLength);
        }

        public final PersistenceTypeDefinitionMember createDefinitionMember(PersistenceTypeDefinitionMemberCreator creator) {
            return this.actual.createDefinitionMember(creator);
        }

        protected void throwValidationException(String instanceValue, String persistedValue) {
            throw new BinaryPersistenceException("Invalid value change for field " + this.identifier() + ": instance value " + instanceValue + " != persisted value " + persistedValue + ".");
        }
    }

    public static interface Defaults {
        public static String defaultUninitializedName() {
            return Abstract.NAME_UNINITIALIZED;
        }

        public static long defaultUninitializedOffset() {
            return -1L;
        }
    }

    public static interface Initializable<T>
    extends BinaryField<T> {
        public long initializeOffset(long var1);

        public String initializeIdentifier(String var1, String var2);

        default public String initializeIdentifierOptional(String qualifier, String name) {
            String currentName = this.name();
            if (!Defaults.defaultUninitializedName().equals(currentName)) {
                return currentName;
            }
            return this.initializeIdentifier(qualifier, name);
        }
    }
}

