/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.binary.types;

import java.util.function.Consumer;
import one.microstream.collections.BulkList;
import one.microstream.collections.XArrays;
import one.microstream.collections.types.XGettingSequence;
import one.microstream.memory.XMemory;
import one.microstream.persistence.binary.exceptions.BinaryPersistenceException;
import one.microstream.persistence.binary.types.Binary;
import one.microstream.persistence.types.PersistenceObjectIdAcceptor;
import one.microstream.persistence.types.PersistenceTypeDescriptionMember;
import one.microstream.persistence.types.PersistenceTypeDescriptionMemberFieldGenericComplex;
import one.microstream.persistence.types.PersistenceTypeDescriptionMemberFieldGenericVariableLength;
import one.microstream.reflect.XReflect;

@FunctionalInterface
public interface BinaryReferenceTraverser {
    public long apply(long var1, PersistenceObjectIdAcceptor var3);

    default public int coveredConstantByteCount() {
        return 0;
    }

    default public boolean hasReferences() {
        return false;
    }

    default public boolean isVariableLength() {
        return false;
    }

    public static long iterateReferences(long address, BinaryReferenceTraverser[] traversers, PersistenceObjectIdAcceptor acceptor) {
        long a = address;
        for (int i = 0; i < traversers.length; ++i) {
            a = traversers[i].apply(a, acceptor);
        }
        return a;
    }

    public static void iterateReferenceRange(long address, long referenceRange, PersistenceObjectIdAcceptor iterator) {
        long addressBound = address + referenceRange;
        for (long a = address; a < addressBound; a += (long)Static.REFERENCE_LENGTH) {
            iterator.acceptObjectId(XMemory.get_long((long)a));
        }
    }

    public static void iterateReferenceRangeReversed(long address, long referenceRange, PersistenceObjectIdAcceptor iterator) {
        long addressBound = address + referenceRange;
        for (long a = address; a < addressBound; a += (long)Static.REFERENCE_LENGTH) {
            iterator.acceptObjectId(Long.reverseBytes(XMemory.get_long((long)a)));
        }
    }

    public static BinaryReferenceTraverser[] none() {
        return Static.EMPTY;
    }

    public static boolean hasReferences(BinaryReferenceTraverser[] traversers) {
        for (BinaryReferenceTraverser traverser : traversers) {
            if (!traverser.hasReferences()) continue;
            return true;
        }
        return false;
    }

    public static final class InlinedComplexType
    implements BinaryReferenceTraverser {
        final BinaryReferenceTraverser[] traversers;
        final boolean switchByteOrder;

        InlinedComplexType(BinaryReferenceTraverser[] traversers, boolean switchByteOrder) {
            this.traversers = traversers;
            this.switchByteOrder = switchByteOrder;
        }

        @Override
        public final long apply(long address, PersistenceObjectIdAcceptor acceptor) {
            long elementCountRawValue = XMemory.get_long((long)Binary.toBinaryListElementCountOffset(address));
            long elementCount = this.switchByteOrder ? Long.reverseBytes(elementCountRawValue) : elementCountRawValue;
            long a = Binary.toBinaryListElementsOffset(address);
            for (long i = 0L; i < elementCount; ++i) {
                a = BinaryReferenceTraverser.iterateReferences(a, this.traversers, acceptor);
            }
            return a;
        }

        @Override
        public final int coveredConstantByteCount() {
            return 0;
        }

        @Override
        public final boolean hasReferences() {
            return true;
        }

        @Override
        public final boolean isVariableLength() {
            return true;
        }
    }

    public static final class SkippingRangeTraverser
    implements BinaryReferenceTraverser {
        private final int skipLength;

        SkippingRangeTraverser(int skipLength) {
            this.skipLength = skipLength;
        }

        @Override
        public final long apply(long address, PersistenceObjectIdAcceptor acceptor) {
            return address + (long)this.skipLength;
        }

        @Override
        public int coveredConstantByteCount() {
            return this.skipLength;
        }

        @Override
        public boolean hasReferences() {
            return false;
        }

        @Override
        public boolean isVariableLength() {
            return false;
        }
    }

    public static final class ReferenceRangeTraverserReversed
    implements BinaryReferenceTraverser {
        private final int referenceRange;

        ReferenceRangeTraverserReversed(int referenceRange) {
            this.referenceRange = referenceRange;
        }

        @Override
        public final long apply(long address, PersistenceObjectIdAcceptor acceptor) {
            long addressBound = address + (long)this.referenceRange;
            for (long a = address; a < addressBound; a += (long)Static.REFERENCE_LENGTH) {
                acceptor.acceptObjectId(Long.reverseBytes(XMemory.get_long((long)a)));
            }
            return addressBound;
        }

        @Override
        public int coveredConstantByteCount() {
            return this.referenceRange;
        }

        @Override
        public boolean hasReferences() {
            return true;
        }

        @Override
        public boolean isVariableLength() {
            return false;
        }
    }

    public static final class ReferenceRangeTraverser
    implements BinaryReferenceTraverser {
        private final int referenceRange;

        ReferenceRangeTraverser(int referenceRange) {
            this.referenceRange = referenceRange;
        }

        @Override
        public final long apply(long address, PersistenceObjectIdAcceptor acceptor) {
            long addressBound = address + (long)this.referenceRange;
            for (long a = address; a < addressBound; a += (long)Static.REFERENCE_LENGTH) {
                acceptor.acceptObjectId(XMemory.get_long((long)a));
            }
            return addressBound;
        }

        @Override
        public int coveredConstantByteCount() {
            return this.referenceRange;
        }

        @Override
        public boolean hasReferences() {
            return true;
        }

        @Override
        public boolean isVariableLength() {
            return false;
        }
    }

    public static final class Analyzer
    implements Consumer<PersistenceTypeDescriptionMember> {
        final BulkList<BinaryReferenceTraverser> traversers = BulkList.New((long)16L);
        final boolean switchByteOrder;
        int skipLength;
        int referenceCount;

        public Analyzer(boolean switchByteOrder) {
            this.switchByteOrder = switchByteOrder;
        }

        private void finishSkipRange() {
            if (this.skipLength != 0) {
                this.traversers.add((Object)Static.skippingTraverser(this.skipLength));
                this.skipLength = 0;
            }
        }

        private void finishReferenceRange() {
            if (this.referenceCount != 0) {
                this.traversers.add((Object)Static.referenceRangeTraverser(this.referenceCount, this.switchByteOrder));
                this.referenceCount = 0;
            }
        }

        @Override
        public void accept(PersistenceTypeDescriptionMember member) {
            if (member.isVariableLength()) {
                if (!(member instanceof PersistenceTypeDescriptionMemberFieldGenericVariableLength)) {
                    throw new BinaryPersistenceException("Unhandled " + PersistenceTypeDescriptionMember.class.getSimpleName() + " type: " + member);
                }
                this.finishSkipRange();
                this.finishReferenceRange();
                if (member instanceof PersistenceTypeDescriptionMemberFieldGenericComplex) {
                    this.traversers.add((Object)Static.deriveComplexVariableLengthTraversers((PersistenceTypeDescriptionMemberFieldGenericComplex)member, this.switchByteOrder));
                } else {
                    if (member.hasReferences()) {
                        throw new BinaryPersistenceException("Invalid referential " + PersistenceTypeDescriptionMember.class.getSimpleName() + ": " + member);
                    }
                    this.traversers.add((Object)Static.variableLengthSkipper(this.switchByteOrder));
                }
            } else if (member.isReference()) {
                this.finishSkipRange();
                ++this.referenceCount;
            } else {
                this.finishReferenceRange();
                this.skipLength = (int)((long)this.skipLength + member.persistentMinimumLength());
            }
        }

        final BinaryReferenceTraverser[] yield() {
            this.finishSkipRange();
            this.finishReferenceRange();
            return (BinaryReferenceTraverser[])this.traversers.toArray(BinaryReferenceTraverser.class);
        }
    }

    public static final class Static {
        static final int C1 = 1;
        static final int C2 = 2;
        static final int C3 = 3;
        static final int C4 = 4;
        static final int C5 = 5;
        static final int C6 = 6;
        static final int C7 = 7;
        static final int C8 = 8;
        static final int REFERENCE_LENGTH = Binary.objectIdByteLength();
        static final int REFERENCE_LENGTH_2 = REFERENCE_LENGTH * 2;
        static final int REFERENCE_LENGTH_3 = REFERENCE_LENGTH * 3;
        static final int REFERENCE_LENGTH_4 = REFERENCE_LENGTH * 4;
        static final int REFERENCE_LENGTH_5 = REFERENCE_LENGTH * 5;
        static final int REFERENCE_LENGTH_6 = REFERENCE_LENGTH * 6;
        static final int REFERENCE_LENGTH_7 = REFERENCE_LENGTH * 7;
        static final int REFERENCE_LENGTH_8 = REFERENCE_LENGTH * 8;
        static final BinaryReferenceTraverser[] EMPTY = new BinaryReferenceTraverser[0];
        static final BinaryReferenceTraverser SKIP_1 = new BinaryReferenceTraverser(){

            @Override
            public final long apply(long address, PersistenceObjectIdAcceptor acceptor) {
                return address + 1L;
            }

            @Override
            public int coveredConstantByteCount() {
                return 1;
            }
        };
        static final BinaryReferenceTraverser SKIP_2 = new BinaryReferenceTraverser(){

            @Override
            public final long apply(long address, PersistenceObjectIdAcceptor acceptor) {
                return address + 2L;
            }

            @Override
            public int coveredConstantByteCount() {
                return 2;
            }
        };
        static final BinaryReferenceTraverser SKIP_3 = new BinaryReferenceTraverser(){

            @Override
            public final long apply(long address, PersistenceObjectIdAcceptor acceptor) {
                return address + 3L;
            }

            @Override
            public int coveredConstantByteCount() {
                return 3;
            }
        };
        static final BinaryReferenceTraverser SKIP_4 = new BinaryReferenceTraverser(){

            @Override
            public final long apply(long address, PersistenceObjectIdAcceptor acceptor) {
                return address + 4L;
            }

            @Override
            public int coveredConstantByteCount() {
                return 4;
            }
        };
        static final BinaryReferenceTraverser SKIP_5 = new BinaryReferenceTraverser(){

            @Override
            public final long apply(long address, PersistenceObjectIdAcceptor acceptor) {
                return address + 5L;
            }

            @Override
            public int coveredConstantByteCount() {
                return 5;
            }
        };
        static final BinaryReferenceTraverser SKIP_6 = new BinaryReferenceTraverser(){

            @Override
            public final long apply(long address, PersistenceObjectIdAcceptor acceptor) {
                return address + 6L;
            }

            @Override
            public int coveredConstantByteCount() {
                return 6;
            }
        };
        static final BinaryReferenceTraverser SKIP_7 = new BinaryReferenceTraverser(){

            @Override
            public final long apply(long address, PersistenceObjectIdAcceptor acceptor) {
                return address + 7L;
            }

            @Override
            public int coveredConstantByteCount() {
                return 7;
            }
        };
        static final BinaryReferenceTraverser SKIP_8 = new BinaryReferenceTraverser(){

            @Override
            public final long apply(long address, PersistenceObjectIdAcceptor acceptor) {
                return address + 8L;
            }

            @Override
            public int coveredConstantByteCount() {
                return 8;
            }
        };
        static final BinaryReferenceTraverser SKIP_VARIABLE_LENGTH = new BinaryReferenceTraverser(){

            @Override
            public final long apply(long address, PersistenceObjectIdAcceptor acceptor) {
                return address + XMemory.get_long((long)address);
            }
        };
        static final BinaryReferenceTraverser SKIP_VARIABLE_LENGTH_REVERSED = new BinaryReferenceTraverser(){

            @Override
            public final long apply(long address, PersistenceObjectIdAcceptor acceptor) {
                return address + Long.reverseBytes(XMemory.get_long((long)address));
            }
        };
        static final BinaryReferenceTraverser REFERENCE_1 = new BinaryReferenceTraverser(){

            @Override
            public final long apply(long address, PersistenceObjectIdAcceptor acceptor) {
                acceptor.acceptObjectId(XMemory.get_long((long)address));
                return address + (long)REFERENCE_LENGTH;
            }

            @Override
            public int coveredConstantByteCount() {
                return REFERENCE_LENGTH;
            }

            @Override
            public boolean hasReferences() {
                return true;
            }
        };
        static final BinaryReferenceTraverser REFERENCE_2 = new BinaryReferenceTraverser(){

            @Override
            public final long apply(long address, PersistenceObjectIdAcceptor acceptor) {
                acceptor.acceptObjectId(XMemory.get_long((long)address));
                acceptor.acceptObjectId(XMemory.get_long((long)(address + (long)REFERENCE_LENGTH)));
                return address + (long)REFERENCE_LENGTH_2;
            }

            @Override
            public int coveredConstantByteCount() {
                return REFERENCE_LENGTH_2;
            }

            @Override
            public boolean hasReferences() {
                return true;
            }
        };
        static final BinaryReferenceTraverser REFERENCE_3 = new BinaryReferenceTraverser(){

            @Override
            public final long apply(long address, PersistenceObjectIdAcceptor acceptor) {
                acceptor.acceptObjectId(XMemory.get_long((long)address));
                acceptor.acceptObjectId(XMemory.get_long((long)(address + (long)REFERENCE_LENGTH)));
                acceptor.acceptObjectId(XMemory.get_long((long)(address + (long)REFERENCE_LENGTH_2)));
                return address + (long)REFERENCE_LENGTH_3;
            }

            @Override
            public int coveredConstantByteCount() {
                return REFERENCE_LENGTH_3;
            }

            @Override
            public boolean hasReferences() {
                return true;
            }
        };
        static final BinaryReferenceTraverser REFERENCE_4 = new BinaryReferenceTraverser(){

            @Override
            public final long apply(long address, PersistenceObjectIdAcceptor acceptor) {
                long bound = address + (long)REFERENCE_LENGTH_4;
                for (long a = address; a < bound; a += (long)REFERENCE_LENGTH) {
                    acceptor.acceptObjectId(XMemory.get_long((long)a));
                }
                return bound;
            }

            @Override
            public int coveredConstantByteCount() {
                return REFERENCE_LENGTH_4;
            }

            @Override
            public boolean hasReferences() {
                return true;
            }
        };
        static final BinaryReferenceTraverser REFERENCE_5 = new BinaryReferenceTraverser(){

            @Override
            public final long apply(long address, PersistenceObjectIdAcceptor acceptor) {
                long bound = address + (long)REFERENCE_LENGTH_5;
                for (long a = address; a < bound; a += (long)REFERENCE_LENGTH) {
                    acceptor.acceptObjectId(XMemory.get_long((long)a));
                }
                return bound;
            }

            @Override
            public int coveredConstantByteCount() {
                return REFERENCE_LENGTH_5;
            }

            @Override
            public boolean hasReferences() {
                return true;
            }
        };
        static final BinaryReferenceTraverser REFERENCE_6 = new BinaryReferenceTraverser(){

            @Override
            public final long apply(long address, PersistenceObjectIdAcceptor acceptor) {
                long bound = address + (long)REFERENCE_LENGTH_6;
                for (long a = address; a < bound; a += (long)REFERENCE_LENGTH) {
                    acceptor.acceptObjectId(XMemory.get_long((long)a));
                }
                return bound;
            }

            @Override
            public int coveredConstantByteCount() {
                return REFERENCE_LENGTH_6;
            }

            @Override
            public boolean hasReferences() {
                return true;
            }
        };
        static final BinaryReferenceTraverser REFERENCE_7 = new BinaryReferenceTraverser(){

            @Override
            public final long apply(long address, PersistenceObjectIdAcceptor acceptor) {
                long bound = address + (long)REFERENCE_LENGTH_7;
                for (long a = address; a < bound; a += (long)REFERENCE_LENGTH) {
                    acceptor.acceptObjectId(XMemory.get_long((long)a));
                }
                return bound;
            }

            @Override
            public int coveredConstantByteCount() {
                return REFERENCE_LENGTH_7;
            }

            @Override
            public boolean hasReferences() {
                return true;
            }
        };
        static final BinaryReferenceTraverser REFERENCE_8 = new BinaryReferenceTraverser(){

            @Override
            public final long apply(long address, PersistenceObjectIdAcceptor acceptor) {
                long bound = address + (long)REFERENCE_LENGTH_8;
                for (long a = address; a < bound; a += (long)REFERENCE_LENGTH) {
                    acceptor.acceptObjectId(XMemory.get_long((long)a));
                }
                return bound;
            }

            @Override
            public int coveredConstantByteCount() {
                return REFERENCE_LENGTH_8;
            }

            @Override
            public boolean hasReferences() {
                return true;
            }
        };
        static final BinaryReferenceTraverser REFERENCE_VARIABLE_LENGTH_START_BOUND_BASED = new BinaryReferenceTraverser(){

            @Override
            public final long apply(long address, PersistenceObjectIdAcceptor acceptor) {
                long bound = address + XMemory.get_long((long)Binary.toBinaryListByteLengthOffset(address));
                for (long a = Binary.toBinaryListElementsOffset(address); a < bound; a += (long)REFERENCE_LENGTH) {
                    acceptor.acceptObjectId(XMemory.get_long((long)a));
                }
                return bound;
            }

            @Override
            public boolean isVariableLength() {
                return true;
            }

            @Override
            public boolean hasReferences() {
                return true;
            }
        };
        static final BinaryReferenceTraverser REFERENCE_1_REVERSED = new BinaryReferenceTraverser(){

            @Override
            public final long apply(long address, PersistenceObjectIdAcceptor acceptor) {
                acceptor.acceptObjectId(Long.reverseBytes(XMemory.get_long((long)address)));
                return address + (long)REFERENCE_LENGTH;
            }

            @Override
            public int coveredConstantByteCount() {
                return REFERENCE_LENGTH;
            }

            @Override
            public boolean hasReferences() {
                return true;
            }
        };
        static final BinaryReferenceTraverser REFERENCE_2_REVERSED = new BinaryReferenceTraverser(){

            @Override
            public final long apply(long address, PersistenceObjectIdAcceptor acceptor) {
                acceptor.acceptObjectId(Long.reverseBytes(XMemory.get_long((long)address)));
                acceptor.acceptObjectId(Long.reverseBytes(XMemory.get_long((long)(address + (long)REFERENCE_LENGTH))));
                return address + (long)REFERENCE_LENGTH_2;
            }

            @Override
            public int coveredConstantByteCount() {
                return REFERENCE_LENGTH_2;
            }

            @Override
            public boolean hasReferences() {
                return true;
            }
        };
        static final BinaryReferenceTraverser REFERENCE_3_REVERSED = new BinaryReferenceTraverser(){

            @Override
            public final long apply(long address, PersistenceObjectIdAcceptor acceptor) {
                acceptor.acceptObjectId(Long.reverseBytes(XMemory.get_long((long)address)));
                acceptor.acceptObjectId(Long.reverseBytes(XMemory.get_long((long)(address + (long)REFERENCE_LENGTH))));
                acceptor.acceptObjectId(Long.reverseBytes(XMemory.get_long((long)(address + (long)REFERENCE_LENGTH_2))));
                return address + (long)REFERENCE_LENGTH_3;
            }

            @Override
            public int coveredConstantByteCount() {
                return REFERENCE_LENGTH_3;
            }

            @Override
            public boolean hasReferences() {
                return true;
            }
        };
        static final BinaryReferenceTraverser REFERENCE_4_REVERSED = new BinaryReferenceTraverser(){

            @Override
            public final long apply(long address, PersistenceObjectIdAcceptor acceptor) {
                long bound = address + (long)REFERENCE_LENGTH_4;
                for (long a = address; a < bound; a += (long)REFERENCE_LENGTH) {
                    acceptor.acceptObjectId(Long.reverseBytes(XMemory.get_long((long)a)));
                }
                return bound;
            }

            @Override
            public int coveredConstantByteCount() {
                return REFERENCE_LENGTH_4;
            }

            @Override
            public boolean hasReferences() {
                return true;
            }
        };
        static final BinaryReferenceTraverser REFERENCE_5_REVERSED = new BinaryReferenceTraverser(){

            @Override
            public final long apply(long address, PersistenceObjectIdAcceptor acceptor) {
                long bound = address + (long)REFERENCE_LENGTH_5;
                for (long a = address; a < bound; a += (long)REFERENCE_LENGTH) {
                    acceptor.acceptObjectId(Long.reverseBytes(XMemory.get_long((long)a)));
                }
                return bound;
            }

            @Override
            public int coveredConstantByteCount() {
                return REFERENCE_LENGTH_5;
            }

            @Override
            public boolean hasReferences() {
                return true;
            }
        };
        static final BinaryReferenceTraverser REFERENCE_6_REVERSED = new BinaryReferenceTraverser(){

            @Override
            public final long apply(long address, PersistenceObjectIdAcceptor acceptor) {
                long bound = address + (long)REFERENCE_LENGTH_6;
                for (long a = address; a < bound; a += (long)REFERENCE_LENGTH) {
                    acceptor.acceptObjectId(Long.reverseBytes(XMemory.get_long((long)a)));
                }
                return bound;
            }

            @Override
            public int coveredConstantByteCount() {
                return REFERENCE_LENGTH_6;
            }

            @Override
            public boolean hasReferences() {
                return true;
            }
        };
        static final BinaryReferenceTraverser REFERENCE_7_REVERSED = new BinaryReferenceTraverser(){

            @Override
            public final long apply(long address, PersistenceObjectIdAcceptor acceptor) {
                long bound = address + (long)REFERENCE_LENGTH_7;
                for (long a = address; a < bound; a += (long)REFERENCE_LENGTH) {
                    acceptor.acceptObjectId(Long.reverseBytes(XMemory.get_long((long)a)));
                }
                return bound;
            }

            @Override
            public int coveredConstantByteCount() {
                return REFERENCE_LENGTH_7;
            }

            @Override
            public boolean hasReferences() {
                return true;
            }
        };
        static final BinaryReferenceTraverser REFERENCE_8_REVERSED = new BinaryReferenceTraverser(){

            @Override
            public final long apply(long address, PersistenceObjectIdAcceptor acceptor) {
                long bound = address + (long)REFERENCE_LENGTH_8;
                for (long a = address; a < bound; a += (long)REFERENCE_LENGTH) {
                    acceptor.acceptObjectId(Long.reverseBytes(XMemory.get_long((long)a)));
                }
                return bound;
            }

            @Override
            public int coveredConstantByteCount() {
                return REFERENCE_LENGTH_8;
            }

            @Override
            public boolean hasReferences() {
                return true;
            }
        };
        static final BinaryReferenceTraverser REFERENCE_VARIABLE_LENGTH_START_BOUND_BASED_REVERSED = new BinaryReferenceTraverser(){

            @Override
            public final long apply(long address, PersistenceObjectIdAcceptor iterator) {
                long bound = address + Long.reverseBytes(XMemory.get_long((long)Binary.toBinaryListByteLengthOffset(address)));
                for (long a = Binary.toBinaryListElementsOffset(address); a < bound; a += (long)REFERENCE_LENGTH) {
                    iterator.acceptObjectId(Long.reverseBytes(XMemory.get_long((long)a)));
                }
                return bound;
            }

            @Override
            public boolean isVariableLength() {
                return true;
            }

            @Override
            public boolean hasReferences() {
                return true;
            }
        };

        static final BinaryReferenceTraverser variableLengthSkipper(boolean switchByteOrder) {
            return switchByteOrder ? SKIP_VARIABLE_LENGTH_REVERSED : SKIP_VARIABLE_LENGTH;
        }

        static final BinaryReferenceTraverser skippingTraverser(int length) {
            switch (length) {
                case 1: {
                    return SKIP_1;
                }
                case 2: {
                    return SKIP_2;
                }
                case 3: {
                    return SKIP_3;
                }
                case 4: {
                    return SKIP_4;
                }
                case 5: {
                    return SKIP_5;
                }
                case 6: {
                    return SKIP_6;
                }
                case 7: {
                    return SKIP_7;
                }
                case 8: {
                    return SKIP_8;
                }
            }
            return new SkippingRangeTraverser(length);
        }

        static final BinaryReferenceTraverser referenceRangeTraverser(int referenceCount, boolean switchByteOrder) {
            if (switchByteOrder) {
                return Static.referenceRangeTraverserReversed(referenceCount);
            }
            switch (referenceCount) {
                case 1: {
                    return REFERENCE_1;
                }
                case 2: {
                    return REFERENCE_2;
                }
                case 3: {
                    return REFERENCE_3;
                }
                case 4: {
                    return REFERENCE_4;
                }
                case 5: {
                    return REFERENCE_5;
                }
                case 6: {
                    return REFERENCE_6;
                }
                case 7: {
                    return REFERENCE_7;
                }
                case 8: {
                    return REFERENCE_8;
                }
            }
            return new ReferenceRangeTraverser(referenceCount * REFERENCE_LENGTH);
        }

        static final BinaryReferenceTraverser referenceRangeTraverserReversed(int referenceCount) {
            switch (referenceCount) {
                case 1: {
                    return REFERENCE_1_REVERSED;
                }
                case 2: {
                    return REFERENCE_2_REVERSED;
                }
                case 3: {
                    return REFERENCE_3_REVERSED;
                }
                case 4: {
                    return REFERENCE_4_REVERSED;
                }
                case 5: {
                    return REFERENCE_5_REVERSED;
                }
                case 6: {
                    return REFERENCE_6_REVERSED;
                }
                case 7: {
                    return REFERENCE_7_REVERSED;
                }
                case 8: {
                    return REFERENCE_8_REVERSED;
                }
            }
            return new ReferenceRangeTraverserReversed(referenceCount * REFERENCE_LENGTH);
        }

        static final int primitiveByteLength(String typeName) {
            Class primitiveType = XReflect.tryResolvePrimitiveType((String)typeName);
            return primitiveType == null ? 0 : XMemory.byteSizePrimitive((Class)primitiveType);
        }

        public static final BinaryReferenceTraverser[] deriveReferenceTraversers(XGettingSequence<? extends PersistenceTypeDescriptionMember> members, boolean switchByteOrder) {
            return ((Analyzer)members.iterate((Consumer)new Analyzer(switchByteOrder))).yield();
        }

        public static final BinaryReferenceTraverser deriveComplexVariableLengthTraversers(PersistenceTypeDescriptionMemberFieldGenericComplex member, boolean switchByteOrder) {
            BinaryReferenceTraverser[] traversers = Static.deriveReferenceTraversers((XGettingSequence<? extends PersistenceTypeDescriptionMember>)member.members(), switchByteOrder);
            if (traversers.length == 1 && traversers[0].hasReferences() && traversers[0].coveredConstantByteCount() > 0) {
                return switchByteOrder ? REFERENCE_VARIABLE_LENGTH_START_BOUND_BASED_REVERSED : REFERENCE_VARIABLE_LENGTH_START_BOUND_BASED;
            }
            if (!BinaryReferenceTraverser.hasReferences(traversers)) {
                return Static.variableLengthSkipper(switchByteOrder);
            }
            return new InlinedComplexType(traversers, switchByteOrder);
        }

        public static int calculateSimpleReferenceCount(BinaryReferenceTraverser[] traversers) {
            if (traversers.length == 0 || !traversers[0].hasReferences() || traversers[0].coveredConstantByteCount() == 0) {
                return 0;
            }
            for (int i = 1; i < traversers.length; ++i) {
                if (!traversers[i].hasReferences()) continue;
                return 0;
            }
            return traversers[0].coveredConstantByteCount() / REFERENCE_LENGTH;
        }

        public static BinaryReferenceTraverser[] cropToReferences(BinaryReferenceTraverser[] traversers) {
            int i = traversers.length;
            while (--i >= 0 && !traversers[i].hasReferences()) {
            }
            if (i + 1 == traversers.length) {
                return traversers;
            }
            if (i < 0) {
                return EMPTY;
            }
            return (BinaryReferenceTraverser[])XArrays.subArray((Object[])traversers, (int)0, (int)(i + 1));
        }
    }
}

