/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.binary.types;

import one.microstream.collections.XArrays;
import one.microstream.functional._longProcedure;
import one.microstream.persistence.types.PersistenceIdSet;

public interface LoadItemsChain {
    public boolean containsLoadItem(long var1);

    public void addLoadItem(long var1);

    public boolean isEmpty();

    public PersistenceIdSet[] getObjectIdSets();

    public void clear();

    public static final class ChannelHashing
    extends Abstract {
        private final int hashRange;
        private final Entry[] hashChainHeads;
        private final Entry[] hashChainTails;

        public ChannelHashing(int channelCount) {
            this.hashRange = channelCount - 1;
            this.hashChainHeads = new Entry[channelCount];
            Object[] hashChainHeads = this.hashChainHeads;
            for (int i = 0; i < hashChainHeads.length; ++i) {
                hashChainHeads[i] = new Entry(0L);
            }
            this.hashChainTails = (Entry[])XArrays.copy((Object[])hashChainHeads);
        }

        @Override
        public PersistenceIdSet[] getObjectIdSets() {
            Entry[] hashChainHeads = this.hashChainHeads;
            PersistenceIdSet[] idSets = new PersistenceIdSet[hashChainHeads.length];
            for (int i = 0; i < hashChainHeads.length; ++i) {
                idSets[i] = new ChainItemObjectIdSet(hashChainHeads[i].next);
            }
            return idSets;
        }

        @Override
        protected void clearChain() {
            Entry[] hashChainHeads = this.hashChainHeads;
            Entry[] hashChainTails = this.hashChainTails;
            for (int i = 0; i < hashChainHeads.length; ++i) {
                hashChainTails[i] = hashChainHeads[i];
                hashChainHeads[i].next = null;
            }
        }

        @Override
        protected Entry enqueueEntry(long objectId, Entry link) {
            Entry entry = new Entry(objectId);
            new Entry(objectId).link = link;
            this.hashChainTails[(int)((long)this.hashRange & objectId)] = this.hashChainTails[(int)((long)this.hashRange & objectId)].next = entry;
            return this.hashChainTails[(int)((long)this.hashRange & objectId)].next;
        }

        public static final class ChainItemObjectIdSet
        implements PersistenceIdSet {
            private final Entry first;

            public ChainItemObjectIdSet(Entry first) {
                this.first = first;
            }

            public boolean isEmpty() {
                return this.first == null;
            }

            public long size() {
                int size = 0;
                Entry e = this.first;
                while (e != null) {
                    ++size;
                    e = e.next;
                }
                return size;
            }

            public void iterate(_longProcedure iterator) {
                Entry e = this.first;
                while (e != null) {
                    iterator.accept(e.objectId);
                    e = e.next;
                }
            }
        }
    }

    public static final class Simple
    extends Abstract
    implements PersistenceIdSet {
        private final Entry chainHead;
        private Entry chainTail;

        public Simple() {
            this.chainTail = this.chainHead = new Entry(0L);
        }

        @Override
        protected final void clearChain() {
            this.chainTail = this.chainHead;
            this.chainHead.next = null;
        }

        @Override
        protected final Entry enqueueEntry(long objectId, Entry link) {
            this.chainTail = this.chainTail.next = new Entry(objectId);
            this.chainTail.next.link = link;
            return this.chainTail.next.link;
        }

        @Override
        public final PersistenceIdSet[] getObjectIdSets() {
            return new PersistenceIdSet[]{this};
        }

        public void iterate(_longProcedure iterator) {
            Entry entry = this.chainHead.next;
            while (entry != null) {
                iterator.accept(entry.objectId);
                entry = entry.next;
            }
        }
    }

    public static abstract class Abstract
    implements LoadItemsChain {
        private static final int INITIAL_HASH_SLOTS_LENGTH = 256;
        private Entry[] hashSlots = new Entry[256];
        private int hashRange = this.hashSlots.length - 1;
        private int size;

        private void rebuildLoadOidSet() {
            int newModulo = (this.hashSlots.length << 1) - 1;
            Entry[] newSlots = new Entry[newModulo + 1];
            for (Entry entry : this.hashSlots) {
                while (entry != null) {
                    Entry next = entry.link;
                    entry.link = newSlots[(int)(entry.objectId & (long)newModulo)];
                    newSlots[(int)(entry.objectId & (long)newModulo)] = entry;
                    entry = next;
                }
            }
            this.hashSlots = newSlots;
            this.hashRange = newModulo;
        }

        protected abstract void clearChain();

        @Override
        public final void clear() {
            this.clearChain();
            Entry[] slots = this.hashSlots;
            for (int i = 0; i < slots.length; ++i) {
                slots[i] = null;
            }
            this.size = 0;
        }

        protected abstract Entry enqueueEntry(long var1, Entry var3);

        private void internalPutNewLoadItem(long objectId) {
            this.hashSlots[(int)(objectId & (long)this.hashRange)] = this.enqueueEntry(objectId, this.hashSlots[(int)(objectId & (long)this.hashRange)]);
            if (++this.size >= this.hashRange) {
                this.rebuildLoadOidSet();
            }
        }

        @Override
        public final void addLoadItem(long objectId) {
            Entry entry = this.hashSlots[(int)(objectId & (long)this.hashRange)];
            while (entry != null) {
                if (entry.objectId == objectId) {
                    return;
                }
                entry = entry.link;
            }
            this.internalPutNewLoadItem(objectId);
        }

        @Override
        public final boolean containsLoadItem(long objectId) {
            Entry entry = this.hashSlots[(int)(objectId & (long)this.hashRange)];
            while (entry != null) {
                if (entry.objectId == objectId) {
                    return true;
                }
                entry = entry.link;
            }
            return false;
        }

        @Override
        public final boolean isEmpty() {
            return this.size == 0;
        }

        public final long size() {
            return this.size;
        }
    }

    public static final class Entry {
        final long objectId;
        Entry next;
        Entry link;

        Entry(long objectId) {
            this.objectId = objectId;
            this.link = null;
            this.next = null;
        }
    }
}

