/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.binary.util;

import java.io.Closeable;
import one.microstream.X;
import one.microstream.collections.types.XGettingCollection;
import one.microstream.collections.types.XReference;
import one.microstream.persistence.binary.types.Binary;
import one.microstream.persistence.binary.util.Serializer;
import one.microstream.persistence.binary.util.SerializerFoundation;
import one.microstream.persistence.exceptions.PersistenceExceptionTransfer;
import one.microstream.persistence.types.PersistenceManager;
import one.microstream.reference.Reference;

public interface ObjectCopier
extends Closeable {
    public <T> T copy(T var1);

    @Override
    public void close();

    public static ObjectCopier New() {
        return new Default(SerializerFoundation.New());
    }

    public static ObjectCopier New(SerializerFoundation<?> foundation) {
        return new Default((SerializerFoundation)X.notNull(foundation));
    }

    public static class Default
    implements ObjectCopier {
        private final SerializerFoundation<?> foundation;
        private PersistenceManager<Binary> persistenceManager;

        Default(SerializerFoundation<?> foundation) {
            this.foundation = foundation;
        }

        @Override
        public synchronized <T> T copy(T source) {
            this.lazyInit();
            this.persistenceManager.store(source);
            return (T)this.persistenceManager.get();
        }

        @Override
        public synchronized void close() {
            if (this.persistenceManager != null) {
                this.persistenceManager.objectRegistry().clearAll();
                this.persistenceManager.close();
                this.persistenceManager = null;
            }
        }

        private void lazyInit() {
            if (this.persistenceManager == null) {
                XReference buffer = X.Reference(null);
                Serializer.Source source = () -> Default.lambda$lazyInit$0((Reference)buffer);
                Serializer.Target target = arg_0 -> Default.lambda$lazyInit$1((Reference)buffer, arg_0);
                this.persistenceManager = ((SerializerFoundation)((SerializerFoundation)this.foundation.setPersistenceSource(source)).setPersistenceTarget(target)).createPersistenceManager();
            } else {
                this.persistenceManager.objectRegistry().truncateAll();
            }
        }

        private static /* synthetic */ void lambda$lazyInit$1(Reference buffer, Binary data) throws PersistenceExceptionTransfer {
            buffer.set((Object)data);
        }

        private static /* synthetic */ XGettingCollection lambda$lazyInit$0(Reference buffer) throws PersistenceExceptionTransfer {
            return X.Constant((Object)((Binary)buffer.get()));
        }
    }
}

