/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.binary.util;

import java.nio.ByteBuffer;
import java.util.function.Function;
import one.microstream.X;
import one.microstream.collections.HashTable;
import one.microstream.collections.types.XGettingCollection;
import one.microstream.hashing.XHashing;
import one.microstream.memory.XMemory;
import one.microstream.persistence.binary.types.Binary;
import one.microstream.persistence.binary.types.BinaryStorer;
import one.microstream.persistence.binary.types.ChunksBuffer;
import one.microstream.persistence.binary.types.ChunksBufferByteReversing;
import one.microstream.persistence.binary.types.ChunksWrapper;
import one.microstream.persistence.binary.util.SerializerFoundation;
import one.microstream.persistence.exceptions.PersistenceExceptionTransfer;
import one.microstream.persistence.types.PersistenceIdSet;
import one.microstream.persistence.types.PersistenceManager;
import one.microstream.persistence.types.PersistenceObjectIdRequestor;
import one.microstream.persistence.types.PersistenceObjectManager;
import one.microstream.persistence.types.PersistenceSource;
import one.microstream.persistence.types.PersistenceStoreHandler;
import one.microstream.persistence.types.PersistenceStorer;
import one.microstream.persistence.types.PersistenceTarget;
import one.microstream.persistence.types.PersistenceTypeHandler;
import one.microstream.persistence.types.PersistenceTypeHandlerManager;
import one.microstream.persistence.types.Storer;
import one.microstream.reference.Lazy;
import one.microstream.reference.ObjectSwizzling;
import one.microstream.reference.Swizzling;
import one.microstream.util.BufferSizeProviderIncremental;

public interface Serializer<M>
extends AutoCloseable {
    public M serialize(Object var1);

    public <T> T deserialize(M var1);

    public static Serializer<Binary> Binary() {
        return Serializer.Binary(SerializerFoundation.New());
    }

    public static Serializer<Binary> Binary(SerializerFoundation<?> foundation) {
        return Serializer.New(foundation, Function.identity(), Function.identity());
    }

    public static Serializer<byte[]> Bytes() {
        return Serializer.Bytes(SerializerFoundation.New());
    }

    public static Serializer<byte[]> Bytes(SerializerFoundation<?> foundation) {
        return Serializer.New(foundation, Static::toBytes, Static::toBinary);
    }

    public static <M> Serializer<M> New(Function<Binary, M> toMedium, Function<M, Binary> toBinary) {
        return Serializer.New(SerializerFoundation.New(), toMedium, toBinary);
    }

    public static <M> Serializer<M> New(SerializerFoundation<?> foundation, Function<Binary, M> toMedium, Function<M, Binary> toBinary) {
        return new Default((SerializerFoundation)X.notNull(foundation), (Function)X.notNull(toMedium), (Function)X.notNull(toBinary));
    }

    public static class Default<M>
    implements Serializer<M> {
        private final SerializerFoundation<?> foundation;
        private final Function<Binary, M> toMedium;
        private final Function<M, Binary> toBinary;
        private PersistenceManager<Binary> persistenceManager;
        private Storer storer;
        private Binary input;
        private Binary output;

        Default(SerializerFoundation<?> foundation, Function<Binary, M> toMedium, Function<M, Binary> toBinary) {
            this.foundation = foundation;
            this.toMedium = toMedium;
            this.toBinary = toBinary;
            this.lazyInit();
        }

        @Override
        public synchronized M serialize(Object object) {
            this.storer.store(object);
            this.storer.commit();
            return this.toMedium.apply(this.output);
        }

        @Override
        public synchronized <T> T deserialize(M data) {
            this.input = this.toBinary.apply(data);
            return (T)this.persistenceManager.get();
        }

        @Override
        public synchronized void close() {
            if (this.persistenceManager != null) {
                this.persistenceManager.objectRegistry().truncateAll();
                this.persistenceManager.close();
                this.persistenceManager = null;
                this.input = null;
                this.output = null;
            }
        }

        private void lazyInit() {
            if (this.persistenceManager == null) {
                Source source = () -> X.Constant((Object)this.input);
                Target target = data -> {
                    this.output = data;
                };
                this.persistenceManager = ((SerializerFoundation)((SerializerFoundation)this.foundation.setPersistenceSource(source)).setPersistenceTarget(target)).createPersistenceManager();
                this.storer = this.persistenceManager.createStorer((PersistenceStorer.Creator)new SerializerStorer.Creator(this.foundation.isByteOrderMismatch()));
            } else {
                this.persistenceManager.objectRegistry().truncateAll();
            }
        }

        static class SerializerStorer
        implements BinaryStorer,
        PersistenceStoreHandler<Binary>,
        PersistenceObjectIdRequestor<Binary> {
            private final boolean switchByteOrder;
            private final PersistenceObjectManager<Binary> objectManager;
            private final ObjectSwizzling objectRetriever;
            private final PersistenceTypeHandlerManager<Binary> typeManager;
            private final PersistenceTarget<Binary> target;
            private final BufferSizeProviderIncremental bufferSizeProvider;
            private ChunksBuffer[] chunks;
            final Item head = new Item(null, 0L, null, null);
            private Item tail;
            private HashTable<Object, Item> hashSlots;

            protected static int defaultSlotSize() {
                return 1024;
            }

            public SerializerStorer(PersistenceObjectManager<Binary> objectManager, ObjectSwizzling objectRetriever, PersistenceTypeHandlerManager<Binary> typeManager, PersistenceTarget<Binary> target, BufferSizeProviderIncremental bufferSizeProvider, boolean switchByteOrder) {
                this.objectManager = (PersistenceObjectManager)X.notNull(objectManager);
                this.objectRetriever = (ObjectSwizzling)X.notNull((Object)objectRetriever);
                this.typeManager = (PersistenceTypeHandlerManager)X.notNull(typeManager);
                this.target = (PersistenceTarget)X.notNull(target);
                this.bufferSizeProvider = (BufferSizeProviderIncremental)X.notNull((Object)bufferSizeProvider);
                this.switchByteOrder = switchByteOrder;
                this.defaultInitialize();
            }

            public final ObjectSwizzling getObjectRetriever() {
                return this.objectRetriever;
            }

            @Override
            public final long maximumCapacity() {
                return Long.MAX_VALUE;
            }

            @Override
            public final long currentCapacity() {
                return this.hashSlots.size();
            }

            public final long size() {
                return this.hashSlots.size();
            }

            @Override
            public PersistenceStorer reinitialize() {
                this.defaultInitialize();
                return this;
            }

            @Override
            public PersistenceStorer reinitialize(long initialCapacity) {
                this.internalInitialize(XHashing.padHashLength((long)initialCapacity));
                return this;
            }

            public void clear() {
                this.reinitialize();
            }

            private void defaultInitialize() {
                this.internalInitialize(SerializerStorer.defaultSlotSize());
            }

            protected void internalInitialize(int hashLength) {
                this.hashSlots = HashTable.NewCustom((int)hashLength);
                this.tail = this.head;
                this.head.next = null;
                this.chunks = new ChunksBuffer[1];
                ChunksBuffer[] chunks = this.chunks;
                chunks[0] = this.switchByteOrder ? ChunksBufferByteReversing.New(chunks, this.bufferSizeProvider) : ChunksBuffer.New(chunks, this.bufferSizeProvider);
            }

            @Override
            public PersistenceStorer ensureCapacity(long desiredCapacity) {
                return this;
            }

            public <T> long apply(T instance) {
                return this.applyEager(instance);
            }

            public <T> long apply(T instance, PersistenceTypeHandler<Binary, T> localTypeHandler) {
                return this.applyEager(instance, localTypeHandler);
            }

            public final <T> long applyEager(T instance) {
                if (instance == null) {
                    return Swizzling.nullId();
                }
                long objectIdLocal = this.lookupOid(instance);
                if (Swizzling.isFoundId((long)objectIdLocal)) {
                    return objectIdLocal;
                }
                return this.registerGuaranteed(instance);
            }

            public <T> long applyEager(T instance, PersistenceTypeHandler<Binary, T> localTypeHandler) {
                if (instance == null) {
                    return Swizzling.nullId();
                }
                long objectIdLocal = this.lookupOid(instance);
                if (Swizzling.isFoundId((long)objectIdLocal)) {
                    return objectIdLocal;
                }
                return this.objectManager.ensureObjectIdGuaranteedRegister(instance, (PersistenceObjectIdRequestor)this, localTypeHandler);
            }

            protected void checkSerializationSupport(Object instance) {
                if (instance instanceof Lazy) {
                    throw new UnsupportedOperationException("Lazy references cannot be serialized");
                }
            }

            protected final long storeGraph(Object root) {
                long rootOid = this.registerGuaranteed(X.notNull((Object)root));
                Item item = this.tail;
                while (item != null) {
                    item.typeHandler.store((Object)this.chunks[0], item.instance, item.oid, (PersistenceStoreHandler)this);
                    item = item.next;
                }
                return rootOid;
            }

            public final long store(Object root) {
                return this.storeGraph(root);
            }

            public final long[] storeAll(Object ... instances) {
                long[] oids = new long[instances.length];
                for (int i = 0; i < instances.length; ++i) {
                    oids[i] = this.storeGraph(instances[i]);
                }
                return oids;
            }

            public void storeAll(Iterable<?> instances) {
                for (Object instance : instances) {
                    this.storeGraph(instance);
                }
            }

            public final Object commit() {
                if (!this.isEmpty()) {
                    this.target.validateIsStoringEnabled();
                    this.target.write((Object)this.chunks[0].complete());
                }
                this.clear();
                return null;
            }

            public final long lookupOid(Object object) {
                Item item = (Item)this.hashSlots.get(object);
                if (item != null) {
                    return item.oid;
                }
                return Swizzling.notFoundId();
            }

            public final <T> void registerGuaranteed(long objectId, T instance, PersistenceTypeHandler<Binary, T> optionalHandler) {
                this.checkSerializationSupport(instance);
                PersistenceTypeHandler typeHandler = optionalHandler != null ? optionalHandler : this.typeManager.ensureTypeHandler(instance);
                this.tail = this.tail.next = this.registerObjectId(instance, typeHandler, objectId);
            }

            public <T> void registerLazyOptional(long objectId, T instance, PersistenceTypeHandler<Binary, T> optionalHandler) {
            }

            public <T> void registerEagerOptional(long objectId, T instance, PersistenceTypeHandler<Binary, T> optionalHandler) {
                this.registerGuaranteed(objectId, instance, optionalHandler);
            }

            protected final long registerGuaranteed(Object instance) {
                return this.objectManager.ensureObjectIdGuaranteedRegister(instance, (PersistenceObjectIdRequestor)this, null);
            }

            public final boolean skipMapped(Object instance, long objectId) {
                return this.internalSkip(instance, objectId);
            }

            public final boolean skip(Object instance) {
                long foundObjectId = this.objectManager.lookupObjectId(instance);
                if (Swizzling.isNotFoundId((long)foundObjectId)) {
                    return this.skipNulled(instance);
                }
                return this.internalSkip(instance, foundObjectId);
            }

            public final boolean skipNulled(Object instance) {
                return this.internalSkip(instance, Swizzling.nullId());
            }

            final boolean internalSkip(Object instance, long objectId) {
                if (Swizzling.isNotFoundId((long)this.lookupOid(instance))) {
                    this.registerObjectId(instance, null, objectId);
                    return true;
                }
                return false;
            }

            public final <T> Item registerObjectId(T instance, PersistenceTypeHandler<Binary, ? super T> typeHandler, long objectId) {
                Item item = new Item(instance, objectId, typeHandler, null);
                this.hashSlots.put(instance, (Object)item);
                return item;
            }

            static final class Item {
                final PersistenceTypeHandler<Binary, Object> typeHandler;
                final Object instance;
                final long oid;
                Item link;
                Item next;

                Item(Object instance, long oid, PersistenceTypeHandler<Binary, Object> typeHandler, Item link) {
                    this.instance = instance;
                    this.oid = oid;
                    this.typeHandler = typeHandler;
                    this.link = link;
                }
            }

            static class Creator
            implements PersistenceStorer.Creator<Binary> {
                private final boolean switchByteOrder;

                Creator(boolean switchByteOrder) {
                    this.switchByteOrder = switchByteOrder;
                }

                public PersistenceStorer createLazyStorer(PersistenceTypeHandlerManager<Binary> typeManager, PersistenceObjectManager<Binary> objectManager, ObjectSwizzling objectRetriever, PersistenceTarget<Binary> target, BufferSizeProviderIncremental bufferSizeProvider) {
                    return this.createEagerStorer(typeManager, objectManager, objectRetriever, target, bufferSizeProvider);
                }

                public PersistenceStorer createEagerStorer(PersistenceTypeHandlerManager<Binary> typeManager, PersistenceObjectManager<Binary> objectManager, ObjectSwizzling objectRetriever, PersistenceTarget<Binary> target, BufferSizeProviderIncremental bufferSizeProvider) {
                    SerializerStorer storer = new SerializerStorer(objectManager, objectRetriever, typeManager, target, bufferSizeProvider, this.switchByteOrder);
                    return storer;
                }
            }
        }
    }

    public static interface Target
    extends PersistenceTarget<Binary> {
        default public boolean isWritable() {
            return true;
        }
    }

    public static interface Source
    extends PersistenceSource<Binary> {
        default public XGettingCollection<? extends Binary> readByObjectIds(PersistenceIdSet[] oids) throws PersistenceExceptionTransfer {
            return null;
        }
    }

    public static final class Static {
        public static byte[] toBytes(Binary binary) {
            return XMemory.toArray((ByteBuffer[])binary.buffers());
        }

        public static Binary toBinary(byte[] bytes) {
            ByteBuffer buffer = XMemory.allocateDirectNative((int)bytes.length);
            buffer.put(bytes);
            buffer.flip();
            return ChunksWrapper.New(buffer);
        }

        private Static() {
            throw new UnsupportedOperationException();
        }
    }
}

