/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.binary.util;

import one.microstream.collections.HashEnum;
import one.microstream.collections.types.XEnum;
import one.microstream.persistence.binary.types.Binary;
import one.microstream.persistence.binary.types.BinaryLoader;
import one.microstream.persistence.binary.types.BinaryPersistenceFoundation;
import one.microstream.persistence.binary.types.BinaryStorer;
import one.microstream.persistence.binary.util.SerializerTypeInfoStrategyCreator;
import one.microstream.persistence.types.PersistenceContextDispatcher;
import one.microstream.persistence.types.PersistenceLoader;
import one.microstream.persistence.types.PersistenceManager;
import one.microstream.persistence.types.PersistenceObjectIdProvider;
import one.microstream.persistence.types.PersistenceRootsProvider;
import one.microstream.persistence.types.PersistenceStorer;
import one.microstream.persistence.types.PersistenceTypeDictionaryCreator;
import one.microstream.persistence.types.PersistenceTypeDictionaryManager;
import one.microstream.persistence.types.PersistenceTypeHandlerManager;
import one.microstream.persistence.types.PersistenceTypeIdProvider;

public interface SerializerFoundation<F extends SerializerFoundation<?>>
extends BinaryPersistenceFoundation<F> {
    @Override
    public SerializerFoundation<F> Clone();

    public SerializerTypeInfoStrategyCreator getSerializerTypeInfoStrategyCreator();

    public F setSerializerTypeInfoStrategyCreator(SerializerTypeInfoStrategyCreator var1);

    public XEnum<Class<?>> getEntityTypes();

    public F setEntityTypes(XEnum<Class<?>> var1);

    public boolean registerEntityType(Class<?> var1);

    public F registerEntityTypes(Class<?> ... var1);

    public F registerEntityTypes(Iterable<Class<?>> var1);

    public static SerializerFoundation<?> New() {
        return new Default();
    }

    public static class Default<F extends Default<?>>
    extends BinaryPersistenceFoundation.Default<F>
    implements SerializerFoundation<F> {
        private XEnum<Class<?>> entityTypes;
        private SerializerTypeInfoStrategyCreator serializerTypeInfoStrategyCreator;

        Default() {
        }

        @Override
        public SerializerTypeInfoStrategyCreator getSerializerTypeInfoStrategyCreator() {
            if (this.serializerTypeInfoStrategyCreator == null) {
                this.serializerTypeInfoStrategyCreator = this.ensureSerializerTypeInfoStrategyCreator();
            }
            return this.serializerTypeInfoStrategyCreator;
        }

        @Override
        public F setSerializerTypeInfoStrategyCreator(SerializerTypeInfoStrategyCreator serializerTypeInfoStrategyCreator) {
            this.serializerTypeInfoStrategyCreator = serializerTypeInfoStrategyCreator;
            return (F)((Default)this.$());
        }

        @Override
        public XEnum<Class<?>> getEntityTypes() {
            if (this.entityTypes == null) {
                this.entityTypes = this.ensureEntityTypes();
            }
            return this.entityTypes;
        }

        @Override
        public F setEntityTypes(XEnum<Class<?>> entityTypes) {
            this.entityTypes = entityTypes;
            return (F)((Default)this.$());
        }

        @Override
        public boolean registerEntityType(Class<?> entityType) {
            return this.getEntityTypes().add(entityType);
        }

        @Override
        public F registerEntityTypes(Class<?> ... entityTypes) {
            this.getEntityTypes().addAll((Object[])entityTypes);
            return (F)((Default)this.$());
        }

        @Override
        public F registerEntityTypes(Iterable<Class<?>> entityTypes) {
            XEnum<Class<?>> registeredEntityTypes = this.getEntityTypes();
            for (Class<?> entityType : entityTypes) {
                registeredEntityTypes.add(entityType);
            }
            return (F)((Default)this.$());
        }

        public F setObjectIdProvider(PersistenceObjectIdProvider oidProvider) {
            throw new UnsupportedOperationException();
        }

        public F setTypeIdProvider(PersistenceTypeIdProvider tidProvider) {
            throw new UnsupportedOperationException();
        }

        public F setContextDispatcher(PersistenceContextDispatcher<Binary> contextDispatcher) {
            throw new UnsupportedOperationException();
        }

        public F setRootsProvider(PersistenceRootsProvider<Binary> rootsProvider) {
            throw new UnsupportedOperationException();
        }

        public F setStorerCreationObserver(PersistenceStorer.CreationObserver liveStorerRegistry) {
            throw new UnsupportedOperationException();
        }

        public F setStorerCreator(PersistenceStorer.Creator<Binary> storerCreator) {
            throw new UnsupportedOperationException();
        }

        public F setBuilderCreator(PersistenceLoader.Creator<Binary> builderCreator) {
            throw new UnsupportedOperationException();
        }

        public F setTypeDictionaryManager(PersistenceTypeDictionaryManager typeDictionaryManager) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Default<F> Clone() {
            return new Default<F>();
        }

        @Override
        public PersistenceManager<Binary> createPersistenceManager() {
            PersistenceTypeHandlerManager typeHandlerManager = this.getTypeHandlerManager();
            typeHandlerManager.initialize();
            this.getEntityTypes().forEach(arg_0 -> ((PersistenceTypeHandlerManager)typeHandlerManager).ensureTypeHandler(arg_0));
            return super.createPersistenceManager();
        }

        protected XEnum<Class<?>> ensureEntityTypes() {
            return HashEnum.New();
        }

        protected SerializerTypeInfoStrategyCreator ensureSerializerTypeInfoStrategyCreator() {
            return new SerializerTypeInfoStrategyCreator.TypeDictionary(false);
        }

        protected PersistenceObjectIdProvider ensureObjectIdProvider() {
            return PersistenceObjectIdProvider.Transient();
        }

        protected PersistenceTypeIdProvider ensureTypeIdProvider() {
            return PersistenceTypeIdProvider.Transient();
        }

        protected PersistenceContextDispatcher<Binary> ensureContextDispatcher() {
            return PersistenceContextDispatcher.LocalObjectRegistration();
        }

        @Override
        protected PersistenceRootsProvider<Binary> ensureRootsProviderInternal() {
            return PersistenceRootsProvider.Empty();
        }

        protected PersistenceStorer.CreationObserver ensureStorerCreationObserver() {
            return PersistenceStorer.CreationObserver::noOp;
        }

        @Override
        protected BinaryStorer.Creator ensureStorerCreator() {
            return BinaryStorer.Creator(() -> 1, this.isByteOrderMismatch());
        }

        @Override
        protected BinaryLoader.Creator ensureBuilderCreator() {
            return BinaryLoader.CreatorSimple(this.isByteOrderMismatch());
        }

        protected PersistenceTypeDictionaryManager ensureTypeDictionaryManager() {
            PersistenceTypeDictionaryManager newTypeDictionaryManager = PersistenceTypeDictionaryManager.Transient((PersistenceTypeDictionaryCreator)this.getTypeDictionaryCreator());
            return newTypeDictionaryManager;
        }
    }
}

