/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.binary.util;

import one.microstream.persistence.binary.types.Binary;
import one.microstream.persistence.binary.util.SerializerTypeInfoStrategy;
import one.microstream.persistence.types.PersistenceManager;

public interface SerializerTypeInfoStrategyCreator {
    public SerializerTypeInfoStrategy create(PersistenceManager<Binary> var1);

    public static class TypeDictionary
    implements SerializerTypeInfoStrategyCreator {
        private final boolean includeTypeInfoOnce;

        public TypeDictionary(boolean includeTypeInfoOnce) {
            this.includeTypeInfoOnce = includeTypeInfoOnce;
        }

        @Override
        public SerializerTypeInfoStrategy create(PersistenceManager<Binary> persistenceManager) {
            return new SerializerTypeInfoStrategy.TypeDictionary(persistenceManager, this.includeTypeInfoOnce);
        }
    }

    public static class Diff
    implements SerializerTypeInfoStrategyCreator {
        private final boolean includeTypeInfoOnce;

        public Diff(boolean includeTypeInfoOnce) {
            this.includeTypeInfoOnce = includeTypeInfoOnce;
        }

        @Override
        public SerializerTypeInfoStrategy create(PersistenceManager<Binary> persistenceManager) {
            return new SerializerTypeInfoStrategy.Diff(persistenceManager, this.includeTypeInfoOnce);
        }
    }

    public static class IncrementalDiff
    implements SerializerTypeInfoStrategyCreator {
        private final boolean includeTypeInfoOnce;

        public IncrementalDiff(boolean includeTypeInfoOnce) {
            this.includeTypeInfoOnce = includeTypeInfoOnce;
        }

        @Override
        public SerializerTypeInfoStrategy create(PersistenceManager<Binary> persistenceManager) {
            return new SerializerTypeInfoStrategy.IncrementalDiff(persistenceManager, this.includeTypeInfoOnce);
        }
    }
}

