/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.binary.util;

import one.microstream.collections.BulkList;
import one.microstream.collections.EqHashEnum;
import one.microstream.collections.types.XAddingSequence;
import one.microstream.collections.types.XGettingEnum;
import one.microstream.collections.types.XGettingSequence;
import one.microstream.collections.types.XGettingTable;
import one.microstream.hashing.HashEqualator;
import one.microstream.persistence.types.PersistenceTypeDefinition;
import one.microstream.persistence.types.PersistenceTypeDefinitionCreator;
import one.microstream.persistence.types.PersistenceTypeDefinitionMemberCreator;
import one.microstream.persistence.types.PersistenceTypeDescription;
import one.microstream.persistence.types.PersistenceTypeDescriptionMember;
import one.microstream.persistence.types.PersistenceTypeDescriptionResolver;
import one.microstream.persistence.types.PersistenceTypeDescriptionResolverProvider;
import one.microstream.persistence.types.PersistenceTypeDictionaryBuilder;
import one.microstream.persistence.types.PersistenceTypeDictionaryParser;

public interface TypeDefinitionBuilder {
    public XGettingSequence<PersistenceTypeDefinition> buildTypeDefinitions(String var1);

    public static class Default
    implements TypeDefinitionBuilder {
        private final PersistenceTypeDictionaryParser typeDictionaryParser;
        private final PersistenceTypeDefinitionCreator typeDefinitionCreator;
        private final PersistenceTypeDescriptionResolverProvider typeDescriptionResolverProvider;

        public Default(PersistenceTypeDictionaryParser typeDictionaryParser, PersistenceTypeDefinitionCreator typeDefinitionCreator, PersistenceTypeDescriptionResolverProvider typeDescriptionResolverProvider) {
            this.typeDictionaryParser = typeDictionaryParser;
            this.typeDefinitionCreator = typeDefinitionCreator;
            this.typeDescriptionResolverProvider = typeDescriptionResolverProvider;
        }

        @Override
        public XGettingSequence<PersistenceTypeDefinition> buildTypeDefinitions(String typeEntry) {
            PersistenceTypeDescriptionResolver typeResolver = this.typeDescriptionResolverProvider.provideTypeDescriptionResolver();
            XGettingSequence entries = this.typeDictionaryParser.parseTypeDictionaryEntries(typeEntry);
            XGettingTable uniqueTypeIdEntries = PersistenceTypeDictionaryBuilder.ensureUniqueTypeIds((XGettingSequence)entries);
            PersistenceTypeDefinitionMemberCreator.Default memberCreator = PersistenceTypeDefinitionMemberCreator.New((XGettingSequence)uniqueTypeIdEntries.values(), (PersistenceTypeDescriptionResolver)typeResolver);
            BulkList typeDefs = BulkList.New((long)uniqueTypeIdEntries.size());
            for (PersistenceTypeDescription e : uniqueTypeIdEntries.values()) {
                EqHashEnum allMembers = EqHashEnum.New((HashEqualator)PersistenceTypeDescriptionMember.identityHashEqualator());
                EqHashEnum instanceMembers = EqHashEnum.New((HashEqualator)PersistenceTypeDescriptionMember.identityHashEqualator());
                PersistenceTypeDictionaryBuilder.buildDefinitionMembers((PersistenceTypeDefinitionMemberCreator)memberCreator, (PersistenceTypeDescription)e, (XAddingSequence)allMembers, (XAddingSequence)instanceMembers);
                String runtimeTypeName = typeResolver.resolveRuntimeTypeName(e);
                Class type = runtimeTypeName == null ? null : typeResolver.tryResolveType(runtimeTypeName);
                PersistenceTypeDefinition typeDef = this.typeDefinitionCreator.createTypeDefinition(e.typeId(), e.typeName(), runtimeTypeName, type, (XGettingEnum)allMembers, (XGettingEnum)instanceMembers);
                typeDefs.add((Object)typeDef);
            }
            return typeDefs;
        }
    }
}

