/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.binary.util;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Function;
import one.microstream.X;
import one.microstream.collections.types.XGettingSequence;
import one.microstream.memory.XMemory;
import one.microstream.persistence.binary.types.Binary;
import one.microstream.persistence.binary.types.ChunksWrapper;
import one.microstream.persistence.binary.util.Serializer;
import one.microstream.persistence.binary.util.SerializerFoundation;
import one.microstream.persistence.binary.util.SerializerTypeInfo;
import one.microstream.persistence.binary.util.SerializerTypeInfoStrategy;
import one.microstream.persistence.binary.util.TypeDefinitionBuilder;
import one.microstream.persistence.binary.util.TypeDefinitionImporter;
import one.microstream.persistence.types.PersistenceManager;
import one.microstream.persistence.types.PersistenceStorer;
import one.microstream.persistence.types.PersistenceTypeDefinition;
import one.microstream.persistence.types.PersistenceTypeHandlerEnsurer;
import one.microstream.persistence.types.PersistenceTypeHandlerManager;
import one.microstream.persistence.types.Storer;
import one.microstream.util.logging.Logging;
import org.slf4j.Logger;

public interface TypedSerializer<M>
extends Serializer<M> {
    public static Serializer<Binary> Binary() {
        return TypedSerializer.Binary(SerializerFoundation.New());
    }

    public static Serializer<Binary> Binary(SerializerFoundation<?> foundation) {
        return TypedSerializer.New(foundation, Function.identity(), Function.identity());
    }

    public static Serializer<byte[]> Bytes() {
        return TypedSerializer.Bytes(SerializerFoundation.New());
    }

    public static Serializer<byte[]> Bytes(SerializerFoundation<?> foundation) {
        return TypedSerializer.New(foundation, Static::toBytes, Static::toBinary);
    }

    public static <M> Serializer<M> New(Function<Binary, M> toMedium, Function<M, Binary> toBinary) {
        return TypedSerializer.New(SerializerFoundation.New(), toMedium, toBinary);
    }

    public static <M> Serializer<M> New(SerializerFoundation<?> foundation, Function<Binary, M> toMedium, Function<M, Binary> toBinary) {
        return new Default((SerializerFoundation)X.notNull(foundation), (Function)X.notNull(toMedium), (Function)X.notNull(toBinary));
    }

    public static class Default<M>
    implements TypedSerializer<M> {
        private static final Logger logger = Logging.getLogger(Serializer.class);
        private final SerializerFoundation<?> foundation;
        private final Function<Binary, M> toMedium;
        private final Function<M, Binary> toBinary;
        private PersistenceManager<Binary> persistenceManager;
        private Storer storer;
        private Binary input;
        private Binary output;
        private TypeDefinitionBuilder typeDefintionBuilder;
        private TypeDefinitionImporter typeDefinitionImporter;
        private SerializerTypeInfoStrategy typeInfoStrategy;
        private TypeInfoCache typeInfoCache;
        private long lastTypeInfoImportTimeStamp;

        Default(SerializerFoundation<?> foundation, Function<Binary, M> toMedium, Function<M, Binary> toBinary) {
            this.foundation = foundation;
            this.toMedium = toMedium;
            this.toBinary = toBinary;
            this.initialize();
        }

        @Override
        public synchronized M serialize(Object object) {
            this.storer.store(object);
            this.storer.commit();
            ByteBuffer[] dataBuffers = this.output.buffers();
            ByteBuffer[] typeInfoBuffers = this.updateTypeInfo();
            ByteBuffer headerBuffer = XMemory.allocateDirectNative((int)(XMemory.byteSize_byte() + XMemory.byteSize_int() + XMemory.byteSize_long()));
            headerBuffer.put((byte)(XMemory.nativeByteOrder() != ByteOrder.LITTLE_ENDIAN ? 1 : 0));
            headerBuffer.putInt(typeInfoBuffers.length);
            headerBuffer.putLong(this.typeInfoCache.getLastTypeInfoTimeStamp());
            headerBuffer.rewind();
            ByteBuffer[] buffers = new ByteBuffer[1 + dataBuffers.length + typeInfoBuffers.length];
            buffers[0] = headerBuffer;
            System.arraycopy(typeInfoBuffers, 0, buffers, 1, typeInfoBuffers.length);
            System.arraycopy(dataBuffers, 0, buffers, 1 + typeInfoBuffers.length, dataBuffers.length);
            if (this.typeInfoStrategy.includeOnce()) {
                this.typeInfoCache = new TypeInfoCache(new ByteBuffer[0], 0L);
            }
            return this.toMedium.apply(ChunksWrapper.New(buffers));
        }

        private ByteBuffer[] updateTypeInfo() {
            if (this.typeInfoStrategy.hasUpdate() || this.typeInfoCache == null) {
                this.storer.store((Object)this.typeInfoStrategy.get());
                this.storer.commit();
                this.typeInfoCache = new TypeInfoCache(this.output.buffers(), System.nanoTime());
            }
            return this.typeInfoCache.getCachedTypeInfoBuffers();
        }

        @Override
        public synchronized <T> T deserialize(M data) {
            Binary in = this.toBinary.apply(data);
            in.buffers()[0].position(XMemory.byteSize_byte());
            int typeInfoCount = in.buffers()[0].getInt();
            long typeInfoTimeStamp = in.buffers()[0].getLong();
            if (typeInfoCount > 0 && this.lastTypeInfoImportTimeStamp < typeInfoTimeStamp) {
                logger.debug("importing type information from input");
                this.input = ChunksWrapper.New(Arrays.copyOfRange(in.buffers(), 1, typeInfoCount + 1));
                SerializerTypeInfo typeInfo = (SerializerTypeInfo)this.persistenceManager.get();
                for (String type : typeInfo.getSerializedTypes()) {
                    XGettingSequence<PersistenceTypeDefinition> typeDefs = this.typeDefintionBuilder.buildTypeDefinitions(type);
                    this.typeDefinitionImporter.importTypeDefinitions(typeDefs);
                }
                this.lastTypeInfoImportTimeStamp = typeInfoTimeStamp;
            }
            this.input = ChunksWrapper.New(Arrays.copyOfRange(in.buffers(), typeInfoCount + 1, in.buffers().length));
            Object content = this.persistenceManager.get();
            return (T)content;
        }

        @Override
        public synchronized void close() {
            if (this.persistenceManager != null) {
                this.persistenceManager.objectRegistry().truncateAll();
                this.persistenceManager.close();
                this.persistenceManager = null;
                this.input = null;
                this.output = null;
            }
        }

        private void initialize() {
            if (this.persistenceManager == null) {
                Serializer.Source source = () -> X.Constant((Object)this.input);
                Serializer.Target target = data -> {
                    this.output = data;
                };
                this.foundation.registerEntityType(SerializerTypeInfo.class);
                this.persistenceManager = ((SerializerFoundation)((SerializerFoundation)this.foundation.setPersistenceSource(source)).setPersistenceTarget(target)).createPersistenceManager();
                this.storer = this.persistenceManager.createStorer((PersistenceStorer.Creator)new Serializer.Default.SerializerStorer.Creator(this.foundation.isByteOrderMismatch()));
                this.typeDefintionBuilder = new TypeDefinitionBuilder.Default(this.foundation.getTypeDictionaryParser(), this.foundation.getTypeDefinitionCreator(), this.foundation.getTypeDescriptionResolverProvider());
                this.typeDefinitionImporter = new TypeDefinitionImporter.Default((PersistenceTypeHandlerManager<Binary>)this.foundation.getTypeHandlerManager(), (PersistenceTypeHandlerEnsurer<Binary>)this.foundation.getTypeHandlerEnsurer());
            } else {
                this.persistenceManager.objectRegistry().truncateAll();
            }
            this.typeInfoStrategy = this.foundation.getSerializerTypeInfoStrategyCreator().create(this.persistenceManager);
        }

        private static class TypeInfoCache {
            private final ByteBuffer[] cachedTypeInfoBuffers;
            private final long lastTypeInfoTimeStamp;

            public TypeInfoCache(ByteBuffer[] cachedTypeInfoBuffers, long lastTypeInfoTimeStamp) {
                this.cachedTypeInfoBuffers = cachedTypeInfoBuffers;
                this.lastTypeInfoTimeStamp = lastTypeInfoTimeStamp;
            }

            public ByteBuffer[] getCachedTypeInfoBuffers() {
                return this.cachedTypeInfoBuffers;
            }

            public long getLastTypeInfoTimeStamp() {
                return this.lastTypeInfoTimeStamp;
            }
        }
    }

    public static final class Static {
        public static byte[] toBytes(Binary binary) {
            int overallLength = 0;
            for (ByteBuffer source : binary.buffers()) {
                overallLength += source.remaining() + XMemory.byteSize_int();
            }
            byte[] bytes = new byte[overallLength];
            int pos = 0;
            for (ByteBuffer source : binary.buffers()) {
                int length = source.remaining();
                int currentSourcePosition = source.position();
                XMemory.set_intInBytes((byte[])bytes, (int)pos, (int)length);
                source.get(bytes, pos += XMemory.byteSize_int(), length);
                pos += length;
                source.position(currentSourcePosition);
            }
            return bytes;
        }

        public static Binary toBinary(byte[] bytes) {
            byte b = bytes[XMemory.byteSize_int()];
            ByteOrder byteOrder = b == 0 ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
            ByteBuffer bb = ByteBuffer.wrap(bytes).order(byteOrder);
            ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>();
            while (bb.hasRemaining()) {
                int contentSize = bb.getInt();
                ByteBuffer contentBuffer = XMemory.allocateDirectNative((int)contentSize);
                contentBuffer.put(bytes, bb.position(), contentSize);
                bb.position(bb.position() + contentSize);
                buffers.add(contentBuffer);
            }
            return ChunksWrapper.New(buffers.toArray(new ByteBuffer[0]));
        }

        private Static() {
            throw new UnsupportedOperationException();
        }
    }
}

