/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.binary.internal;

import java.util.function.Consumer;
import java.util.function.Predicate;
import one.microstream.X;
import one.microstream.collections.types.XGettingEnum;
import one.microstream.collections.types.XGettingSequence;
import one.microstream.persistence.binary.types.Binary;
import one.microstream.persistence.binary.types.BinaryLegacyTypeHandler;
import one.microstream.persistence.binary.types.BinaryReferenceTraverser;
import one.microstream.persistence.binary.types.BinaryValueSetter;
import one.microstream.persistence.exceptions.PersistenceException;
import one.microstream.persistence.exceptions.PersistenceExceptionTypeNotPersistable;
import one.microstream.persistence.types.PersistenceFunction;
import one.microstream.persistence.types.PersistenceLegacyTypeHandlingListener;
import one.microstream.persistence.types.PersistenceLoadHandler;
import one.microstream.persistence.types.PersistenceTypeDefinition;
import one.microstream.persistence.types.PersistenceTypeDefinitionMember;
import one.microstream.persistence.types.PersistenceTypeDescriptionMember;
import one.microstream.persistence.types.PersistenceTypeHandler;
import one.microstream.typing.KeyValue;
import one.microstream.util.cql.CQL;

public abstract class AbstractBinaryLegacyTypeHandlerTranslating<T>
extends BinaryLegacyTypeHandler.Abstract<T> {
    private final PersistenceTypeHandler<Binary, T> typeHandler;
    private final BinaryValueSetter[] valueTranslators;
    private final long[] targetOffsets;
    private final PersistenceLegacyTypeHandlingListener<Binary> listener;

    public static BinaryValueSetter[] toTranslators(XGettingEnum<KeyValue<Long, BinaryValueSetter>> translatorsWithTargetOffsets) {
        AbstractBinaryLegacyTypeHandlerTranslating.validate(translatorsWithTargetOffsets);
        return (BinaryValueSetter[])CQL.from(translatorsWithTargetOffsets).project(KeyValue::value).executeInto((Object[])new BinaryValueSetter[translatorsWithTargetOffsets.intSize()]);
    }

    public static long[] toTargetOffsets(XGettingEnum<KeyValue<Long, BinaryValueSetter>> translatorsWithTargetOffsets) {
        AbstractBinaryLegacyTypeHandlerTranslating.validate(translatorsWithTargetOffsets);
        return X.unbox((Long[])((Long[])CQL.from(translatorsWithTargetOffsets).project(kv -> {
            Long offset = (Long)kv.key();
            return offset == null ? -1L : offset;
        }).executeInto((Object[])new Long[translatorsWithTargetOffsets.intSize()])));
    }

    private static void validate(XGettingEnum<KeyValue<Long, BinaryValueSetter>> translatorsWithTargetOffsets) {
        Predicate<KeyValue> isNullEntry = e -> e.value() == null;
        if (translatorsWithTargetOffsets.containsSearched(isNullEntry)) {
            throw new PersistenceException("Value translator mapping contains an invalid null-entry.");
        }
    }

    public static final BinaryReferenceTraverser[] deriveReferenceTraversers(PersistenceTypeDefinition typeDefinition, boolean switchByteOrder) {
        BinaryReferenceTraverser[] referenceTraversers = BinaryReferenceTraverser.Static.deriveReferenceTraversers((XGettingSequence<? extends PersistenceTypeDescriptionMember>)typeDefinition.instanceMembers(), switchByteOrder);
        return BinaryReferenceTraverser.Static.cropToReferences(referenceTraversers);
    }

    protected AbstractBinaryLegacyTypeHandlerTranslating(PersistenceTypeDefinition typeDefinition, PersistenceTypeHandler<Binary, T> typeHandler, BinaryValueSetter[] valueTranslators, long[] targetOffsets, PersistenceLegacyTypeHandlingListener<Binary> listener, boolean switchByteOrder) {
        super(typeDefinition);
        this.typeHandler = typeHandler;
        this.valueTranslators = valueTranslators;
        this.targetOffsets = targetOffsets;
        this.listener = listener;
    }

    protected BinaryValueSetter[] valueTranslators() {
        return this.valueTranslators;
    }

    protected long[] targetOffsets() {
        return this.targetOffsets;
    }

    public PersistenceTypeHandler<Binary, T> typeHandler() {
        return this.typeHandler;
    }

    public XGettingEnum<? extends PersistenceTypeDefinitionMember> membersInDeclaredOrder() {
        return this.typeHandler.membersInDeclaredOrder();
    }

    public XGettingEnum<? extends PersistenceTypeDescriptionMember> storingMembers() {
        return this.typeHandler.storingMembers();
    }

    public XGettingEnum<? extends PersistenceTypeDescriptionMember> settingMembers() {
        return this.typeHandler.settingMembers();
    }

    public void guaranteeSpecificInstanceViablity() throws PersistenceExceptionTypeNotPersistable {
        this.typeHandler.guaranteeSpecificInstanceViablity();
    }

    public boolean isSpecificInstanceViable() {
        return this.typeHandler.isSpecificInstanceViable();
    }

    public void guaranteeSubTypeInstanceViablity() throws PersistenceExceptionTypeNotPersistable {
        this.typeHandler.guaranteeSubTypeInstanceViablity();
    }

    public boolean isSubTypeInstanceViable() {
        return this.typeHandler.isSubTypeInstanceViable();
    }

    public Object[] collectEnumConstants() {
        return null;
    }

    public int getPersistedEnumOrdinal(Binary data) {
        return this.typeHandler.getPersistedEnumOrdinal((Object)data);
    }

    public Class<T> type() {
        return this.typeHandler.type();
    }

    public void iterateInstanceReferences(T instance, PersistenceFunction iterator) {
        this.typeHandler.iterateInstanceReferences(instance, iterator);
    }

    public <C extends Consumer<? super Class<?>>> C iterateMemberTypes(C logic) {
        return (C)this.typeHandler.iterateMemberTypes(logic);
    }

    public final T create(Binary rawData, PersistenceLoadHandler handler) {
        return this.listener == null ? this.internalCreate(rawData, handler) : this.internalCreateListening(rawData, handler);
    }

    private final T internalCreateListening(Binary rawData, PersistenceLoadHandler handler) {
        T instance = this.internalCreate(rawData, handler);
        this.listener.registerLegacyTypeHandlingCreation(rawData.getBuildItemObjectId(), instance, this.legacyTypeDefinition(), this.typeHandler());
        return instance;
    }

    protected abstract T internalCreate(Binary var1, PersistenceLoadHandler var2);
}

