/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.binary.internal;

import java.nio.ByteBuffer;
import one.microstream.X;
import one.microstream.afs.types.AFS;
import one.microstream.afs.types.AFile;
import one.microstream.afs.types.AReadableFile;
import one.microstream.collections.BulkList;
import one.microstream.collections.Constant;
import one.microstream.collections.types.XGettingCollection;
import one.microstream.memory.XMemory;
import one.microstream.persistence.binary.types.Binary;
import one.microstream.persistence.binary.types.ChunksWrapper;
import one.microstream.persistence.binary.types.ChunksWrapperByteReversing;
import one.microstream.persistence.binary.types.MessageWaiter;
import one.microstream.persistence.exceptions.PersistenceExceptionTransfer;
import one.microstream.persistence.types.PersistenceIdSet;
import one.microstream.persistence.types.PersistenceSource;

public class BinaryFileSource
implements PersistenceSource<Binary>,
MessageWaiter {
    private final AFile file;
    private final boolean switchByteOrder;

    public static final BinaryFileSource New(AFile file, boolean switchByteOrder) {
        return new BinaryFileSource((AFile)X.notNull((Object)file), switchByteOrder);
    }

    BinaryFileSource(AFile file, boolean switchByteOrder) {
        this.switchByteOrder = switchByteOrder;
        this.file = file;
    }

    private ByteBuffer readChunk(AReadableFile channel, long chunkTotalLength) {
        ByteBuffer byteBuffer = XMemory.allocateDirectNative((int)X.checkArrayRange((long)chunkTotalLength));
        channel.readBytes(byteBuffer);
        return byteBuffer;
    }

    private Constant<Binary> read(AReadableFile file) {
        BulkList chunks = new BulkList();
        chunks.add((Object)this.readChunk(file, file.size()));
        return X.Constant((Object)this.createChunksWrapper((ByteBuffer[])chunks.toArray(ByteBuffer.class)));
    }

    private ChunksWrapper createChunksWrapper(ByteBuffer[] byteBuffers) {
        return this.switchByteOrder ? ChunksWrapperByteReversing.New(byteBuffers) : ChunksWrapper.New(byteBuffers);
    }

    public XGettingCollection<? extends Binary> read() throws PersistenceExceptionTransfer {
        try {
            return (XGettingCollection)AFS.apply((AFile)this.file, rf -> this.read((AReadableFile)rf));
        }
        catch (Exception t) {
            throw new PersistenceExceptionTransfer((Throwable)t);
        }
    }

    public XGettingCollection<? extends Binary> readByObjectIds(PersistenceIdSet[] oids) throws PersistenceExceptionTransfer {
        return X.empty();
    }

    @Override
    public void waitForBytes(int readCount) {
    }
}

