/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.binary.java.net;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import one.microstream.persistence.binary.internal.CustomBinaryHandler;
import one.microstream.persistence.binary.types.Binary;
import one.microstream.persistence.binary.types.BinaryField;
import one.microstream.persistence.types.PersistenceLoadHandler;
import one.microstream.reflect.XReflect;

public final class BinaryHandlerInetSocketAddress
extends CustomBinaryHandler<InetSocketAddress> {
    final BinaryField<InetSocketAddress> hostname = BinaryHandlerInetSocketAddress.Field(String.class, InetSocketAddress::getHostName);
    final BinaryField<InetSocketAddress> address = BinaryHandlerInetSocketAddress.Field(InetAddress.class, InetSocketAddress::getAddress);
    final BinaryField<InetSocketAddress> port = BinaryHandlerInetSocketAddress.Field_int(InetSocketAddress::getPort);

    public static BinaryHandlerInetSocketAddress New() {
        return new BinaryHandlerInetSocketAddress();
    }

    public static String uninitializedHostName() {
        return "[uninitialized]";
    }

    BinaryHandlerInetSocketAddress() {
        super(InetSocketAddress.class);
    }

    @Override
    public InetSocketAddress create(Binary data, PersistenceLoadHandler handler) {
        return InetSocketAddress.createUnresolved(BinaryHandlerInetSocketAddress.uninitializedHostName(), 0);
    }

    @Override
    public void initializeState(Binary data, InetSocketAddress instance, PersistenceLoadHandler handler) {
        String hostname = (String)this.hostname.readReference(data, handler);
        InetAddress address = (InetAddress)this.address.readReference(data, handler);
        int port = this.port.read_int(data);
        InetSocketAddress copyDummy = address == null ? new InetSocketAddress(hostname, port) : new InetSocketAddress(address, port);
        XReflect.copyFields((Object)copyDummy, (Object)instance);
    }

    @Override
    public void updateState(Binary data, InetSocketAddress instance, PersistenceLoadHandler handler) {
        super.updateState(data, instance, handler);
    }
}

