/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.binary.java.util;

import java.util.OptionalDouble;
import one.microstream.collections.types.XGettingSequence;
import one.microstream.memory.XMemory;
import one.microstream.persistence.binary.internal.AbstractBinaryHandlerCustomValueFixedLength;
import one.microstream.persistence.binary.types.Binary;
import one.microstream.persistence.types.PersistenceLoadHandler;
import one.microstream.persistence.types.PersistenceStoreHandler;
import one.microstream.persistence.types.PersistenceTypeDefinitionMember;
import one.microstream.persistence.types.PersistenceTypeDefinitionMemberFieldGeneric;

public final class BinaryHandlerOptionalDouble
extends AbstractBinaryHandlerCustomValueFixedLength<OptionalDouble, Double> {
    static final long BINARY_OFFSET_IS_PRESENT = 0L;
    static final long BINARY_OFFSET_VALUE = 1L;
    static final long BINARY_LENGTH = 9L;

    public static BinaryHandlerOptionalDouble New() {
        return new BinaryHandlerOptionalDouble();
    }

    BinaryHandlerOptionalDouble() {
        super(OptionalDouble.class, (XGettingSequence<? extends PersistenceTypeDefinitionMember>)BinaryHandlerOptionalDouble.CustomFields(new PersistenceTypeDefinitionMemberFieldGeneric[]{BinaryHandlerOptionalDouble.CustomField(Boolean.TYPE, "isPresent"), BinaryHandlerOptionalDouble.CustomField(Double.TYPE, "value")}));
    }

    private static double instanceState(OptionalDouble instance) {
        return instance.orElse(0.0);
    }

    private static double binaryState(Binary data) {
        return data.read_double(1L);
    }

    @Override
    public void store(Binary data, OptionalDouble instance, long objectId, PersistenceStoreHandler<Binary> handler) {
        data.storeEntityHeader(9L, this.typeId(), objectId);
        data.store_boolean(0L, instance.isPresent());
        data.store_double(1L, BinaryHandlerOptionalDouble.instanceState(instance));
    }

    @Override
    public OptionalDouble create(Binary data, PersistenceLoadHandler handler) {
        boolean isPresent = data.read_boolean(0L);
        return isPresent ? OptionalDouble.of(data.read_double(1L)) : (OptionalDouble)XMemory.instantiateBlank(OptionalDouble.class);
    }

    @Override
    public Double getValidationStateFromInstance(OptionalDouble instance) {
        return BinaryHandlerOptionalDouble.instanceState(instance);
    }

    @Override
    public Double getValidationStateFromBinary(Binary data) {
        return BinaryHandlerOptionalDouble.binaryState(data);
    }

    @Override
    public void validateState(Binary data, OptionalDouble instance, PersistenceLoadHandler handler) {
        double binaryState;
        double instanceState = BinaryHandlerOptionalDouble.instanceState(instance);
        if (instanceState == (binaryState = BinaryHandlerOptionalDouble.binaryState(data))) {
            return;
        }
        this.throwInconsistentStateException(instance, instanceState, binaryState);
    }
}

